/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.maven.common.PropertiesUtils;
import org.kuali.maven.common.ResourceUtils;
import org.kuali.maven.ec2.AbstractEC2Mojo;
import org.kuali.maven.ec2.EC2Utils;
import org.kuali.maven.ec2.WaitControl;

public class LaunchInstanceMojo
extends AbstractEC2Mojo {
    private String ami;
    private String key;
    private String type;
    private List<String> securityGroups;
    private String userData;
    private String userDataFile;
    private boolean filterUserData;
    private String encoding;
    private boolean wait;
    private int waitTimeout;
    private String state;
    private int initialPause;

    @Override
    public void execute(EC2Utils ec2Utils) throws MojoExecutionException {
        EC2Utils.sleep(this.initialPause);
        RunInstancesRequest request = this.getRunSingleEC2InstanceRequest();
        Instance i = ec2Utils.getSingleEC2Instance(request);
        ec2Utils.createTags(i, this.tags);
        WaitControl wc = new WaitControl(this.wait, this.waitTimeout, this.state);
        Properties props = this.project.getProperties();
        Instance running = ec2Utils.wait(i, wc, props);
        props.setProperty("ec2.instance.id", running.getInstanceId());
        props.setProperty("ec2.instance.name", ec2Utils.getTagValue(running, "Name"));
    }

    protected RunInstancesRequest getRunSingleEC2InstanceRequest() throws MojoExecutionException {
        RunInstancesRequest request = new RunInstancesRequest();
        request.setMaxCount(Integer.valueOf(1));
        request.setMinCount(Integer.valueOf(1));
        request.setImageId(this.ami);
        request.setKeyName(this.key);
        request.setInstanceType(InstanceType.fromValue((String)this.type));
        request.setSecurityGroups(this.securityGroups);
        String data = this.getUserData(this.userData, this.userDataFile, this.encoding);
        request.setUserData(data);
        return request;
    }

    protected String getUserData(String data, String location, String encoding) throws MojoExecutionException {
        String s = data;
        if (!StringUtils.isBlank((String)location)) {
            try {
                s = this.getString(location, encoding);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading from " + location, (Exception)e);
            }
        }
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        if (this.filterUserData) {
            PropertiesUtils pu = new PropertiesUtils();
            Properties properties = pu.getMavenProperties(this.project);
            s = pu.getResolvedValue(s, properties);
        }
        this.getLog().debug((CharSequence)("filteredUserData=" + s));
        byte[] bytes = Base64.encodeBase64((byte[])s.getBytes());
        String base64 = new String(bytes);
        this.getLog().debug((CharSequence)("base64Encoded=" + base64));
        return base64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(String location, String encoding) throws IOException {
        String string;
        InputStream in = null;
        try {
            ResourceUtils ru = new ResourceUtils();
            in = ru.getInputStream(location);
            string = IOUtils.toString((InputStream)in, (String)encoding);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    public String getAmi() {
        return this.ami;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isFilterUserData() {
        return this.filterUserData;
    }

    public void setFilterUserData(boolean filterUserData) {
        this.filterUserData = filterUserData;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getUserDataFile() {
        return this.userDataFile;
    }

    public void setUserDataFile(String userDataFile) {
        this.userDataFile = userDataFile;
    }
}

