/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class UpdateJobsMavenVersionMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException {
        try {
            List<File> configFiles = this.getConfigFiles();
            this.getLog().info((CharSequence)("Located " + configFiles.size() + " job config files"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error", e);
        }
    }

    protected void updateContent(List<File> files, List<String> rtokens, String replacement, String extension) throws IOException {
        for (File file : files) {
            String newContent;
            String oldContent = FileUtils.readFileToString((File)file);
            if (oldContent.equals(newContent = this.getReplacementContent(oldContent, rtokens, replacement))) continue;
            this.getLog().info((CharSequence)("Updating " + file));
            File bak = new File(file.getAbsolutePath() + extension);
            FileUtils.copyFile((File)file, (File)bak);
            FileUtils.writeStringToFile((File)file, (String)newContent);
        }
    }

    protected String getReplacementContent(String s, List<String> rtokens, String replacement) {
        for (String rtoken : rtokens) {
            s = s.replace(rtoken, replacement);
        }
        return s;
    }

    protected void addTokens(String[] tokens, Map<String, Integer> map, String open, String close) {
        if (tokens == null) {
            return;
        }
        for (String token : tokens) {
            if (token == null) continue;
            String s = open + token + close;
            Integer count = map.get(s);
            if (count == null) {
                count = new Integer(1);
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            map.put(s, count);
        }
    }

    protected List<String> getMvn303ReplacementTokens(List<File> files) throws IOException {
        for (File file : files) {
            String s = FileUtils.readFileToString((File)file);
            int pos = s.indexOf("Maven-3.0.3");
            if (pos == -1) continue;
            this.getLog().info((CharSequence)(file + ""));
        }
        ArrayList<String> rtokens = new ArrayList<String>();
        return rtokens;
    }

    protected List<String> getJdkReplacementTokens(List<File> files) throws IOException {
        String open = "<jdk>";
        String close = "</jdk>";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (File file : files) {
            String s = FileUtils.readFileToString((File)file);
            String[] tokens = StringUtils.substringsBetween((String)s, (String)open, (String)close);
            this.addTokens(tokens, map, open, close);
        }
        ArrayList<String> rtokens = new ArrayList<String>();
        Set keys = map.keySet();
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            String key;
            String rtoken = key = (String)i$.next();
            this.getLog().info((CharSequence)(key + "=" + map.get(key)));
            rtokens.add(rtoken);
        }
        return rtokens;
    }

    protected List<String> getMvnReplacementTokens(List<File> files) throws IOException {
        String open = "<mavenName>";
        String close = "</mavenName>";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (File file : files) {
            String s = FileUtils.readFileToString((File)file);
            String[] tokens = StringUtils.substringsBetween((String)s, (String)open, (String)close);
            this.addTokens(tokens, map, open, close);
        }
        ArrayList<String> rtokens = new ArrayList<String>();
        Set keys = map.keySet();
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            String key;
            String rtoken = key = (String)i$.next();
            this.getLog().info((CharSequence)(key + "=" + map.get(key)));
            rtokens.add(rtoken);
        }
        return rtokens;
    }

    protected List<File> getConfigFiles() {
        File directory = new File("/var/lib/jenkins/jobs");
        File[] files = directory.listFiles();
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files) {
            File config = new File(file.getAbsolutePath() + "/config.xml");
            if (!config.exists()) continue;
            list.add(config);
        }
        return list;
    }
}

