/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins.helper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class Helper {
    public static final String EQUALS = "=";
    public static final String SPACE = " ";
    public static final String COMMA = ",";
    public static final String EMPTY_STRING = "";
    public static final String FS = System.getProperty("file.separator");

    public static final String getRelativePath(File dir, File file) {
        String dirPath = dir.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        int pos = filePath.indexOf(dirPath);
        int len = dirPath.length();
        if (pos == -1) {
            return null;
        }
        return filePath.substring(pos + len + FS.length());
    }

    public static final String toCSV(int[] integers) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < integers.length; ++i) {
            if (i != 0) {
                sb.append(COMMA);
            }
            sb.append(integers[i]);
        }
        return sb.toString();
    }

    public static final String toCSV(Integer[] integers) {
        return Helper.toCSV(Helper.toIntArray(integers));
    }

    public static final String toCSV(List<Integer> integers) {
        return Helper.toCSV(Helper.toIntegerArray(integers));
    }

    public static final int[] toIntArray(List<Integer> integers) {
        int[] ints = new int[integers.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = integers.get(i);
        }
        return ints;
    }

    public static final int[] toIntArray(Integer[] integers) {
        return Helper.toIntArray(Helper.toIntegerList(integers));
    }

    public static final Integer[] toIntegerArray(List<Integer> integers) {
        return integers.toArray(new Integer[integers.size()]);
    }

    public static final List<Integer> toIntegerList(Integer[] integers) {
        return Arrays.asList(integers);
    }

    public static final List<Integer> toIntegerList(String csv) {
        int[] integers = Helper.toIntArray(csv);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int integer : integers) {
            list.add(integer);
        }
        return list;
    }

    public static final int[] toIntArray(String csv) {
        String[] tokens = Helper.splitAndTrimCSV(csv);
        int[] integers = new int[tokens.length];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = new Integer(tokens[i]);
        }
        return integers;
    }

    public static final List<String> getLines(String s) {
        if (StringUtils.isBlank((String)s)) {
            return new ArrayList<String>();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        try {
            return IOUtils.readLines((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final List<String> toKeyValueList(Map<String, String> map, String csv) {
        ArrayList<String> list = new ArrayList<String>();
        if (!Helper.isEmpty(map)) {
            list.addAll(Helper.toKeyValueList(map));
        }
        if (!StringUtils.isBlank((String)csv)) {
            String[] tokens = Helper.splitAndTrimCSV(csv);
            list.addAll(Arrays.asList(tokens));
        }
        return list;
    }

    public static final Map<String, String> toMap(String[] keyValuePairs) {
        return Helper.toMap(Arrays.asList(keyValuePairs));
    }

    public static final Map<String, String> toMap(List<String> keyValuePairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keyValuePair : keyValuePairs) {
            String[] tokens = StringUtils.split((String)keyValuePair, (String)EQUALS);
            String key = tokens[0];
            String value = tokens[1];
            map.put(key, value);
        }
        return map;
    }

    public static final List<String> toKeyValueList(Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> pair : map.entrySet()) {
            String s = pair.getKey() + EQUALS + pair.getValue();
            list.add(s);
        }
        return list;
    }

    public static final List<String> splitAndTrimCSVToList(String s) {
        return Helper.toList(Helper.splitAndTrim(s, COMMA));
    }

    public static final String[] splitAndTrimCSV(String s) {
        return Helper.splitAndTrim(s, COMMA);
    }

    public static final String[] splitAndTrim(String s, String separator) {
        String[] tokens;
        for (String token : tokens = StringUtils.split((String)s, (String)separator)) {
            token = token.trim();
        }
        return tokens;
    }

    public static final List<String> toList(String ... strings) {
        return Arrays.asList(strings);
    }

    public static final <T> List<T> toList(T element) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(element);
        return list;
    }

    public static final String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static final String toEmpty(String s) {
        if (StringUtils.isBlank((String)s)) {
            return EMPTY_STRING;
        }
        return s;
    }

    public static final String toString(List<String> list) {
        return Helper.toString(Helper.toArray(list), SPACE);
    }

    public static final String toString(List<String> list, String separator) {
        return Helper.toString(Helper.toArray(list), separator);
    }

    public static final String toString(String[] tokens) {
        return Helper.toString(tokens, SPACE);
    }

    public static final String toString(String[] tokens, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static final boolean isMatch(int target, int ... values) {
        for (int value : values) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static final boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static final boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    public static final boolean anyAreBlank(String ... strings) {
        for (String string : strings) {
            if (!StringUtils.isBlank((String)string)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isEmpty(String[] strings) {
        return strings == null || strings.length == 0;
    }

    public static final void addToList(List<String> list, String ... args) {
        if (Helper.isEmpty(args)) {
            return;
        }
        for (String arg : args) {
            list.add(arg);
        }
    }
}

