/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import org.apache.commons.lang.StringUtils;
import org.kuali.maven.mojo.s3.Tag;

public class HtmlUtils {
    int indent = 0;

    public String getIndentedContent(String content) {
        return this.getIndent() + content;
    }

    public String getIndent() {
        return StringUtils.repeat((String)" ", (int)this.indent);
    }

    public String getHref(String dest, String show) {
        return this.getIndent() + "<a href=\"" + dest + "\">" + show + "</a>";
    }

    public String getImage(String image) {
        return this.getIndent() + "<img src=\"" + image + "\">";
    }

    public String openTag(Tag tag) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getIndent());
        ++this.indent;
        sb.append("<" + tag.getName());
        if (tag.getId() != null) {
            sb.append(" id=\"" + tag.getId() + '\"');
        }
        if (tag.getClazz() != null) {
            sb.append(" class=\"" + tag.getClazz() + '\"');
        }
        sb.append(">\n");
        return sb.toString();
    }

    public String closeTag(Tag tag) {
        --this.indent;
        return this.getIndent() + "</" + tag.getName() + ">\n";
    }

    public String getTag(Tag tag, String content) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(tag));
        sb.append(this.getIndent());
        sb.append(content);
        sb.append("\n");
        sb.append(this.closeTag(tag));
        return sb.toString();
    }
}

