/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ListIteratorContext;
import org.kuali.maven.mojo.s3.ListObjectsContext;
import org.kuali.maven.mojo.s3.S3BucketContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListObjectsContextHandler
implements ElementHandler<ListObjectsContext> {
    private final Logger logger = LoggerFactory.getLogger(ListObjectsContextHandler.class);
    private final Object mutex = new Object();
    List<ObjectListing> objectListings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleElement(ListIteratorContext<ListObjectsContext> context, int index, ListObjectsContext element) {
        S3BucketContext bucketContext = element.getBucketContext();
        AmazonS3Client client = bucketContext.getClient();
        ListObjectsRequest request = element.getRequest();
        request.getPrefix();
        this.logger.debug("[Thread:" + this.lpad(context.getId()) + ", Element:" + this.lpad(index) + "] " + request.getPrefix());
        ObjectListing listing = client.listObjects(request);
        Object object = this.mutex;
        synchronized (object) {
            if (this.objectListings == null) {
                this.objectListings = new ArrayList<ObjectListing>();
            }
            this.objectListings.add(listing);
        }
    }

    protected String lpad(int i) {
        return StringUtils.leftPad((String)(i + ""), (int)3, (String)" ");
    }

    public List<ObjectListing> getObjectListings() {
        return this.objectListings;
    }

    public void setObjectListings(List<ObjectListing> objectListings) {
        this.objectListings = objectListings;
    }
}

