/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.maven.mojo.s3.DisplayRow;
import org.kuali.maven.mojo.s3.DisplayRowComparator;
import org.kuali.maven.mojo.s3.HtmlUtils;
import org.kuali.maven.mojo.s3.S3BucketContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3DataConverter {
    HtmlUtils html = new HtmlUtils();
    NumberFormat nf = this.getNumberFormatInstance();
    S3BucketContext context;
    String browseKey;

    public S3DataConverter() {
        this(null);
    }

    public S3DataConverter(S3BucketContext context) {
        this.context = context;
    }

    protected NumberFormat getNumberFormatInstance() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        nf.setGroupingUsed(false);
        return nf;
    }

    protected String getTrimmedPrefix(String prefix, String delimiter) {
        int pos = prefix.lastIndexOf(delimiter);
        if (pos == -1) {
            return prefix;
        }
        return prefix.substring(0, pos);
    }

    protected void addDisplayRows(List<DisplayRow> displayRows, List<String[]> data) {
        for (DisplayRow displayRow : displayRows) {
            this.addDisplayRow(displayRow, data);
        }
    }

    protected void addDisplayRow(DisplayRow displayRow, List<String[]> data) {
        if (displayRow == null) {
            return;
        }
        String[] row = new String[]{displayRow.getImage(), displayRow.getAhref(), displayRow.getLastModified(), displayRow.getSize()};
        data.add(row);
    }

    protected String getShow(String key, String prefix) {
        if (prefix == null) {
            return key;
        }
        int index = prefix.length();
        String s = key.substring(index);
        return s;
    }

    protected DisplayRow getDisplayRow(String commonPrefix, String prefix, String delimiter) {
        String image = this.html.getImage(this.context.getDirectoryImage());
        String show = this.getShow(commonPrefix, prefix);
        String dest = delimiter + commonPrefix;
        String ahref = this.html.getHref(dest, show);
        String date = "-";
        String size = "-";
        DisplayRow displayRow = new DisplayRow();
        displayRow.setImage(image);
        displayRow.setAhref(ahref);
        displayRow.setLastModified(date);
        displayRow.setSize(size);
        displayRow.setShow(show);
        return displayRow;
    }

    protected List<DisplayRow> getDirectoryDisplayRows(ObjectListing objectListing, String prefix, String delimiter) {
        ArrayList<DisplayRow> displayRows = new ArrayList<DisplayRow>();
        for (String commonPrefix : objectListing.getCommonPrefixes()) {
            DisplayRow displayRow = this.getDisplayRow(commonPrefix, prefix, delimiter);
            if (displayRow == null) continue;
            displayRows.add(displayRow);
        }
        return displayRows;
    }

    public List<String[]> getData(ObjectListing objectListing, String prefix, String delimiter) {
        DisplayRow upOneDirectory = this.getUpOneDirectoryDisplayRow(prefix, delimiter);
        List<DisplayRow> objectDisplayRows = this.getObjectDisplayRows(objectListing, prefix, delimiter);
        List<DisplayRow> directoryDisplayRows = this.getDirectoryDisplayRows(objectListing, prefix, delimiter);
        DisplayRowComparator c = new DisplayRowComparator();
        Collections.sort(directoryDisplayRows, c);
        ArrayList<String[]> data = new ArrayList<String[]>();
        this.addDisplayRow(upOneDirectory, data);
        this.addDisplayRows(directoryDisplayRows, data);
        this.addDisplayRows(objectDisplayRows, data);
        return data;
    }

    protected boolean isDirectory(S3ObjectSummary summary, List<String> commonPrefixes, String prefix, String delimiter) {
        String key = summary.getKey();
        if (key.equals(prefix)) {
            return true;
        }
        for (String commonPrefix : commonPrefixes) {
            if (key.equals(commonPrefix)) {
                return true;
            }
            String trimmedPrefix = this.getTrimmedPrefix(commonPrefix, delimiter);
            if (!key.equals(trimmedPrefix)) continue;
            return true;
        }
        return false;
    }

    protected DisplayRow getDisplayRow(S3ObjectSummary summary, String prefix, String delimiter) {
        String key = summary.getKey();
        String image = this.html.getImage(this.context.getFileImage());
        String show = this.getShow(key, prefix);
        String dest = delimiter + key;
        String ahref = this.html.getHref(dest, show);
        String date = this.context.getLastModifiedDateFormatter().format(summary.getLastModified());
        String size = this.nf.format((double)summary.getSize() / 1024.0) + " KiB";
        DisplayRow displayRow = new DisplayRow();
        displayRow.setShow(show);
        displayRow.setImage(image);
        displayRow.setAhref(ahref);
        displayRow.setLastModified(date);
        displayRow.setSize(size);
        return displayRow;
    }

    protected List<DisplayRow> getObjectDisplayRows(ObjectListing objectListing, String prefix, String delimiter) {
        ArrayList<DisplayRow> displayRows = new ArrayList<DisplayRow>();
        for (S3ObjectSummary summary : objectListing.getObjectSummaries()) {
            DisplayRow displayRow;
            if (this.isDirectory(summary, objectListing.getCommonPrefixes(), prefix, delimiter) || (displayRow = this.getDisplayRow(summary, prefix, delimiter)) == null) continue;
            displayRows.add(displayRow);
        }
        return displayRows;
    }

    protected DisplayRow getUpOneDirectoryDisplayRow(String prefix, String delimiter) {
        if (StringUtils.isEmpty((String)prefix)) {
            return null;
        }
        String image = "";
        String show = ".." + delimiter;
        String dest = this.getUpOneDirectoryDest(prefix, delimiter);
        String ahref = this.html.getHref(dest, show);
        String date = "";
        String size = "";
        DisplayRow displayRow = new DisplayRow();
        displayRow.setImage(image);
        displayRow.setAhref(ahref);
        displayRow.setLastModified(date);
        displayRow.setSize(size);
        return displayRow;
    }

    protected String getUpOneDirectoryDest(String prefix, String delimiter) {
        int pos;
        if (prefix.endsWith(delimiter)) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if ((pos = prefix.lastIndexOf(delimiter)) == -1) {
            return delimiter + this.getBrowseKey();
        }
        return delimiter + prefix.substring(0, pos + 1);
    }

    public void setContext(S3BucketContext context) {
        this.context = context;
    }

    public S3BucketContext getContext() {
        return this.context;
    }

    public String getBrowseKey() {
        return this.browseKey;
    }

    public void setBrowseKey(String browseHtml) {
        this.browseKey = browseHtml;
    }
}

