/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.kuali.maven.mojo.s3.BaseMojo;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public abstract class S3Mojo
extends BaseMojo {
    Mimetypes mimeTypes = Mimetypes.getInstance();
    private String serverId;
    private String prefix;
    private String delimiter;
    private Integer maxKeys;
    private String accessKeyId;
    private String secretAccessKey;
    private String bucket;

    protected ObjectMetadata getObjectMetadata(String location, Resource resource) throws IOException {
        ObjectMetadata om = new ObjectMetadata();
        String contentType = this.mimeTypes.getMimetype(location);
        om.setContentType(contentType);
        om.setContentLength(resource.contentLength());
        return om;
    }

    protected PutObjectRequest getPutObjectRequest(String location, String key) throws IOException {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(location);
        InputStream in = resource.getInputStream();
        ObjectMetadata objectMetadata = this.getObjectMetadata(location, resource);
        PutObjectRequest request = new PutObjectRequest(this.getBucket(), key, in, objectMetadata);
        request.setCannedAcl(CannedAccessControlList.PublicRead);
        return request;
    }

    protected PutObjectRequest getPutObjectRequest(String location) throws IOException {
        String key = location.substring(1);
        return this.getPutObjectRequest(location, key);
    }

    protected String getAuthenticationErrorMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\nError: accessKeyId and secretAccessKey must be provided.\n");
        sb.append("Provide them in the plugin configuration or specify them on the command line:\n\n");
        sb.append("-DaccessKeyId=XXXX\n");
        sb.append("-DsecretAccessKey=XXXX\n");
        sb.append("\n");
        sb.append("You can also provide them in settings.xml as username and password:\n\n");
        sb.append("<server>\n");
        sb.append("  <id>[serverId]</id>\n");
        sb.append("  <username>[AWS Access Key ID]</username>\n");
        sb.append("  <password>[AWS Secret Access Key]</password>\n");
        sb.append("</server>\n\n.\n");
        return sb.toString();
    }

    protected void updateCredentials() {
        if (this.getServerId() == null) {
            return;
        }
        Server server = this.getSettings().getServer(this.getServerId());
        if (this.getAccessKeyId() == null) {
            this.setAccessKeyId(server.getUsername());
        }
        if (this.getSecretAccessKey() == null) {
            this.setSecretAccessKey(server.getPassword());
        }
    }

    protected void validateCredentials() throws MojoExecutionException {
        if (this.getAccessKeyId() == null || this.getSecretAccessKey() == null) {
            throw new MojoExecutionException(this.getAuthenticationErrorMessage());
        }
    }

    protected AWSCredentials getCredentials() throws MojoExecutionException {
        return new BasicAWSCredentials(this.getAccessKeyId(), this.getSecretAccessKey());
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }
}

