/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.spring;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.maven.plugins.spring.MavenConstants;
import org.kuali.maven.plugins.spring.SpringMojoService;

public abstract class AbstractSpringMojo
extends AbstractMojo {
    @Component
    MavenProject project;
    @Parameter(property="spring.addPropertySources", defaultValue="true")
    boolean addPropertySources = new Boolean("true");
    @Parameter(property="spring.removeExistingPropertySources", defaultValue="false")
    boolean removeExistingPropertySources = new Boolean("false");
    @Parameter(property="spring.injectMavenProperties", defaultValue="true")
    boolean injectMavenProperties = new Boolean("true");
    @Parameter(property="spring.injectMavenProject", defaultValue="false")
    boolean injectMavenProject = new Boolean("false");
    @Parameter(property="spring.injectMavenMojo", defaultValue="false")
    boolean injectMavenMojo = new Boolean("false");
    @Parameter(property="spring.mavenPropertiesBeanName", defaultValue="mavenProperties")
    String mavenPropertiesBeanName = "mavenProperties";
    @Parameter(property="spring.mavenProjectBeanName", defaultValue="mavenProject")
    String mavenProjectBeanName = "mavenProject";
    @Parameter(property="spring.mavenMojoBeanName", defaultValue="mavenMojo")
    String mavenMojoBeanName = "mavenMojo";
    @Parameter(property="spring.springService")
    String springService = MavenConstants.DEFAULT_SPRING_SERVICE.getName();
    @Parameter(property="spring.springMojoService")
    String springMojoService = MavenConstants.DEFAULT_SPRING_MOJO_SERVICE.getName();
    @Parameter(property="spring.properties")
    Properties properties;
    @Parameter(property="spring.forceMojoExecution", defaultValue="false")
    boolean forceMojoExecution = new Boolean("false");
    @Parameter(property="spring.skip", defaultValue="false")
    boolean skip = new Boolean("false");

    public void execute() throws MojoExecutionException {
        this.configureLogging();
        SpringMojoService service = (SpringMojoService)ReflectionUtils.newInstance((String)this.springMojoService);
        service.loadSpring(this);
    }

    protected boolean isDebugLoggingEnabled() {
        return Boolean.getBoolean("spring.debug") || this.getLog().isDebugEnabled();
    }

    protected void configureLogging() {
        String log4jConfig;
        if (!this.isDebugLoggingEnabled()) {
            return;
        }
        String log4jDebug = System.getProperty("log4j.debug");
        if (StringUtils.isBlank((CharSequence)log4jDebug)) {
            this.getLog().debug((CharSequence)"Setting system property - [log4j.debug=true]");
            System.setProperty("log4j.debug", "true");
        }
        if (StringUtils.isBlank((CharSequence)(log4jConfig = System.getProperty("log4j.configuration")))) {
            this.getLog().debug((CharSequence)"Setting system property - [log4j.configuration=log4jdebug.xml]");
            System.setProperty("log4j.configuration", "log4jdebug.xml");
        } else {
            this.getLog().debug((CharSequence)("Using existing value for the system property log4j.configuration=[" + log4jConfig + "]"));
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isAddPropertySources() {
        return this.addPropertySources;
    }

    public void setAddPropertySources(boolean addPropertySources) {
        this.addPropertySources = addPropertySources;
    }

    public boolean isInjectMavenProperties() {
        return this.injectMavenProperties;
    }

    public void setInjectMavenProperties(boolean injectMavenProperties) {
        this.injectMavenProperties = injectMavenProperties;
    }

    public boolean isInjectMavenProject() {
        return this.injectMavenProject;
    }

    public void setInjectMavenProject(boolean injectMavenProject) {
        this.injectMavenProject = injectMavenProject;
    }

    public boolean isInjectMavenMojo() {
        return this.injectMavenMojo;
    }

    public void setInjectMavenMojo(boolean injectMavenMojo) {
        this.injectMavenMojo = injectMavenMojo;
    }

    public String getMavenPropertiesBeanName() {
        return this.mavenPropertiesBeanName;
    }

    public void setMavenPropertiesBeanName(String mavenPropertiesBeanName) {
        this.mavenPropertiesBeanName = mavenPropertiesBeanName;
    }

    public String getMavenProjectBeanName() {
        return this.mavenProjectBeanName;
    }

    public void setMavenProjectBeanName(String mavenProjectBeanName) {
        this.mavenProjectBeanName = mavenProjectBeanName;
    }

    public String getMavenMojoBeanName() {
        return this.mavenMojoBeanName;
    }

    public void setMavenMojoBeanName(String mavenMojoBeanName) {
        this.mavenMojoBeanName = mavenMojoBeanName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isForceMojoExecution() {
        return this.forceMojoExecution;
    }

    public void setForceMojoExecution(boolean forceMojoExecution) {
        this.forceMojoExecution = forceMojoExecution;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getSpringService() {
        return this.springService;
    }

    public void setSpringService(String serviceClassName) {
        this.springService = serviceClassName;
    }

    public String getSpringMojoService() {
        return this.springMojoService;
    }

    public void setSpringMojoService(String springMojoService) {
        this.springMojoService = springMojoService;
    }

    public boolean isRemoveExistingPropertySources() {
        return this.removeExistingPropertySources;
    }

    public void setRemoveExistingPropertySources(boolean removeExistingPropertySources) {
        this.removeExistingPropertySources = removeExistingPropertySources;
    }
}

