/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.common.maven.spring.MavenAwareUtils;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LongCounter;
import org.kuali.common.util.MavenUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.property.GlobalPropertiesMode;
import org.kuali.common.util.service.PropertySourceContext;
import org.kuali.common.util.service.SpringContext;
import org.kuali.common.util.service.SpringService;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.maven.plugins.spring.AbstractSpringMojo;
import org.kuali.maven.plugins.spring.LoadContext;
import org.kuali.maven.plugins.spring.LoadMojo;
import org.kuali.maven.plugins.spring.LoadXmlMojo;
import org.kuali.maven.plugins.spring.PropertySourcesContext;
import org.kuali.maven.plugins.spring.SpringMojoService;
import org.kuali.maven.plugins.spring.config.MojoConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Service;

@Service
public class DefaultSpringMojoService
implements SpringMojoService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpringMojoService.class);
    private static final LongCounter SEQUENCE = new LongCounter();

    @Override
    public void loadSpring(AbstractSpringMojo mojo) {
        logger.debug("----------------- Delegating mojo execution to Spring ------------------");
        SpringService service = (SpringService)ReflectionUtils.newInstance((String)mojo.getSpringService());
        ArrayList<String> beanNames = new ArrayList<String>();
        beanNames.add("springMojoService");
        beanNames.add("mavenMojo");
        ArrayList<Object> beans = new ArrayList<Object>();
        beans.add(this);
        beans.add((Object)mojo);
        PropertiesPropertySource propertySource = this.getMavenPropertySource(mojo);
        SpringContext context = new SpringContext();
        context.setDisplayName("Spring Maven Plugin : " + SEQUENCE.increment());
        context.setPropertySourceContext(new PropertySourceContext(SpringUtils.asList((PropertySource[])new PropertySource[]{propertySource})));
        context.setAnnotatedClasses(CollectionUtils.asList((Class[])new Class[]{MojoConfig.class}));
        context.setBeanNames(beanNames);
        context.setBeans(beans);
        service.load(context);
    }

    @Override
    public void mojoCallback(LoadXmlMojo mojo) {
        LoadContext lc = this.getLoadContext(mojo);
        if (lc == null) {
            return;
        }
        SpringContext context = this.getSpringContext(mojo, lc.getMavenProperties());
        PropertySourcesContext psc = this.getPropertySourcesContext(mojo, lc);
        this.addPropertySources(psc, mojo, context);
        this.logConfiguration(mojo, lc.getMavenProperties(), context.getLocations());
        lc.getService().load(context);
    }

    @Override
    public void mojoCallback(LoadMojo mojo) {
        LoadContext lc = this.getLoadContext(mojo);
        if (lc == null) {
            return;
        }
        SpringContext context = this.getSpringContext(mojo, lc.getMavenProperties());
        PropertySourcesContext psc = this.getPropertySourcesContext(mojo, lc);
        this.addPropertySources(psc, mojo, context);
        this.logConfiguration(mojo, lc.getMavenProperties(), context.getAnnotatedClasses());
        lc.getService().load(context);
    }

    protected void addPropertySources(PropertySourcesContext ctx, AbstractSpringMojo mojo, SpringContext context) {
        if (mojo.isAddPropertySources()) {
            String source = ctx.getLocation() == null ? ctx.getAnnotatedClass().getName() : ctx.getLocation();
            logger.debug("Acquiring custom property sources - [{}]", (Object)source);
            List<PropertySource<?>> sources = this.getPropertySources(ctx);
            String msg = sources.size() == 1 ? "source" : "sources";
            logger.debug("Located {} custom property {}", (Object)sources.size(), (Object)msg);
            for (PropertySource<?> ps : sources) {
                String name = ps.getName();
                String type = ps.getClass().getName();
                logger.debug("Adding property source - [{}] -> [{}]", (Object)name, (Object)type);
            }
            context.setPropertySourceContext(new PropertySourceContext(sources, mojo.isRemoveExistingPropertySources()));
        }
    }

    protected PropertySourcesContext getPropertySourcesContext(LoadXmlMojo mojo, LoadContext context) {
        PropertySourcesContext psc = new PropertySourcesContext();
        psc.setLocation(mojo.getPropertySourcesLocation());
        psc.setProperties(context.getMavenProperties());
        psc.setService(context.getService());
        psc.setPropertiesBeanName(mojo.getMavenPropertiesBeanName());
        return psc;
    }

    protected PropertySourcesContext getPropertySourcesContext(LoadMojo mojo, LoadContext context) {
        Class annotatedClass = ReflectionUtils.getClass((String)mojo.getPropertySourcesConfig());
        PropertySourcesContext psc = new PropertySourcesContext();
        psc.setAnnotatedClass(annotatedClass);
        psc.setProperties(context.getMavenProperties());
        psc.setService(context.getService());
        psc.setPropertiesBeanName(mojo.getMavenPropertiesBeanName());
        return psc;
    }

    protected List<PropertySource<?>> getPropertySources(PropertySourcesContext ctx) {
        if (ctx.getLocation() != null) {
            return SpringUtils.getPropertySources((SpringService)ctx.getService(), (String)ctx.getLocation(), (String)ctx.getPropertiesBeanName(), (Properties)ctx.getProperties());
        }
        if (ctx.getAnnotatedClass() != null) {
            return SpringUtils.getPropertySources((SpringService)ctx.getService(), ctx.getAnnotatedClass(), (String)ctx.getPropertiesBeanName(), (Properties)ctx.getProperties());
        }
        throw new IllegalArgumentException("Must supply either location or an annotated class");
    }

    protected SpringContext getSpringContext(LoadMojo mojo, Properties mavenProperties) {
        List<String> annotatedClassNames = this.getAnnotatedClassNames(mojo);
        List<Class<?>> annotatedClasses = this.getAnnotatedClasses(annotatedClassNames);
        List<Boolean> includes = Arrays.asList(mojo.isInjectMavenProperties(), mojo.isInjectMavenProject(), mojo.isInjectMavenMojo());
        List beanNames = CollectionUtils.getList(includes, Arrays.asList(mojo.getMavenPropertiesBeanName(), mojo.getMavenProjectBeanName(), mojo.getMavenMojoBeanName()));
        List beans = CollectionUtils.getList(includes, Arrays.asList(new Object[]{mavenProperties, mojo.getProject(), mojo}));
        SpringContext context = new SpringContext();
        context.setDisplayName("Spring Maven Plugin : Load : " + SEQUENCE.increment());
        context.setAnnotatedClasses(annotatedClasses);
        context.setBeanNames(beanNames);
        context.setBeans(beans);
        return context;
    }

    protected List<String> getAnnotatedClassNames(LoadMojo mojo) {
        ArrayList<String> acns = new ArrayList<String>();
        if (!StringUtils.isBlank((String)mojo.getAnnotatedClass())) {
            acns.add(mojo.getAnnotatedClass());
        }
        if (!CollectionUtils.isEmpty(mojo.getAnnotatedClasses())) {
            acns.addAll(mojo.getAnnotatedClasses());
        }
        if (acns.size() == 0) {
            String acn = this.getDefaultAnnotatedClassname(mojo.getProject());
            acns.add(acn);
        }
        return acns;
    }

    protected String getAnnotatedClassName(LoadMojo mojo) {
        if (!StringUtils.isBlank((String)mojo.getAnnotatedClass())) {
            return mojo.getAnnotatedClass();
        }
        String className = this.getDefaultAnnotatedClassname(mojo.getProject());
        try {
            Class annotatedClass = ReflectionUtils.getClass((String)className);
            return annotatedClass.getName();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("No annotated class was provided and the default class [" + className + "] could not be created", e);
        }
    }

    protected List<Class<?>> getAnnotatedClasses(List<String> annotatedClassNames) {
        ArrayList annotatedClasses = new ArrayList();
        for (String annotatedClassName : annotatedClassNames) {
            Class annotatedClass = ReflectionUtils.getClass((String)annotatedClassName);
            annotatedClasses.add(annotatedClass);
        }
        return annotatedClasses;
    }

    protected SpringContext getSpringContext(LoadXmlMojo mojo, Properties mavenProperties) {
        String location = mojo.getLocation() == null ? this.getDefaultLocation(mojo.getProject()) : mojo.getLocation();
        List contextLocations = CollectionUtils.combine((Object)location, mojo.getLocations());
        List<Boolean> includes = Arrays.asList(mojo.isInjectMavenProperties(), mojo.isInjectMavenProject(), mojo.isInjectMavenMojo());
        List beanNames = CollectionUtils.getList(includes, Arrays.asList(mojo.getMavenPropertiesBeanName(), mojo.getMavenProjectBeanName(), mojo.getMavenMojoBeanName()));
        List beans = CollectionUtils.getList(includes, Arrays.asList(new Object[]{mavenProperties, mojo.getProject(), mojo}));
        SpringContext context = new SpringContext();
        context.setDisplayName("Spring Maven Plugin : LoadXML : " + SEQUENCE.increment());
        context.setLocations(contextLocations);
        context.setBeanNames(beanNames);
        context.setBeans(beans);
        return context;
    }

    protected void logConfiguration(AbstractSpringMojo mojo, Properties props, List<?> configurations) {
        logger.debug("---------------- Loading requested Spring configuration ----------------");
        for (Object configuration : configurations) {
            logger.info("Loading - [{}]", configuration);
        }
        if (mojo.isInjectMavenProperties()) {
            logger.debug("Injecting Maven properties - {} total", (Object)props.size());
            logger.debug("Displaying " + props.size() + " properties\n\n" + PropertyUtils.toString((Properties)props));
        }
        if (mojo.isInjectMavenProject()) {
            logger.debug("Injecting [{}] -> [{}]", (Object)mojo.getMavenProjectBeanName(), (Object)mojo.getProject().getClass().getName());
        }
        if (mojo.isInjectMavenMojo()) {
            logger.debug("Injecting [{}] -> [{}]", (Object)mojo.getMavenMojoBeanName(), (Object)((Object)((Object)mojo)).getClass().getName());
        }
    }

    protected Properties getMavenProperties(AbstractSpringMojo mojo) {
        MavenProject project = mojo.getProject();
        Properties internal = MavenAwareUtils.getInternalProperties((MavenProject)project);
        Properties properties = PropertyUtils.combine((Properties[])new Properties[]{project.getProperties(), project.getProperties(), internal});
        PropertyUtils.overrideWithGlobalValues((Properties)properties, (GlobalPropertiesMode)GlobalPropertiesMode.BOTH);
        return properties;
    }

    protected PropertiesPropertySource getMavenPropertySource(AbstractSpringMojo mojo) {
        String name = "mavenProperties";
        Properties source = this.getMavenProperties(mojo);
        return new PropertiesPropertySource(name, source);
    }

    protected String getDefaultLocation(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        sb.append("classpath:");
        sb.append(Str.getPath((String)project.getGroupId()));
        sb.append("/");
        sb.append("spring");
        sb.append("/");
        sb.append(project.getArtifactId());
        sb.append("-");
        sb.append("context.xml");
        return sb.toString();
    }

    protected String getDefaultAnnotatedClassname(MavenProject project) {
        String[] tokens;
        StringBuilder sb = new StringBuilder();
        sb.append(project.getGroupId());
        sb.append(".");
        sb.append("spring");
        sb.append(".");
        String artifactId = project.getArtifactId();
        for (String token : tokens = StringUtils.split((String)artifactId, (String)"-")) {
            String capitalized = StringUtils.capitalizeFirstLetter((String)token);
            sb.append(capitalized);
        }
        sb.append("Config");
        return sb.toString();
    }

    protected LoadContext getLoadContext(AbstractSpringMojo mojo) {
        if (MavenUtils.skip((boolean)mojo.isForceMojoExecution(), (boolean)mojo.isSkip(), (String)mojo.getProject().getPackaging())) {
            return null;
        }
        Properties mavenProperties = this.getMavenProperties(mojo);
        SpringService service = (SpringService)ReflectionUtils.newInstance((String)mojo.getSpringService());
        return new LoadContext(mavenProperties, service);
    }
}

