/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.annotations;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kubek2k.springockito.annotations.DesiredMockitoBeansFinder;
import org.kubek2k.springockito.annotations.MockitoBeansDefiner;
import org.kubek2k.springockito.annotations.MockitoSpiesDefiner;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.support.GenericXmlContextLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringockitoContextLoader
extends GenericXmlContextLoader {
    private Map<String, Class<?>> mockedBeans = new HashMap();
    private Set<String> spiedBeans;
    private DesiredMockitoBeansFinder mockedBeansFinder = new DesiredMockitoBeansFinder();
    private MockitoBeansDefiner mockitoBeansDefiner = new MockitoBeansDefiner();
    private MockitoSpiesDefiner mockitoSpiesDefiner = new MockitoSpiesDefiner();

    protected void customizeContext(GenericApplicationContext context) {
        super.customizeContext(context);
        this.registerMocks(context, this.mockedBeans);
        this.registerSpies(context, this.spiedBeans);
    }

    private void registerMocks(GenericApplicationContext context, Map<String, Class<?>> mockedBeans) {
        for (Map.Entry<String, Class<?>> beanEntry : this.mockedBeans.entrySet()) {
            context.registerBeanDefinition(beanEntry.getKey(), (BeanDefinition)this.mockitoBeansDefiner.createMockFactoryBeanDefinition(beanEntry.getValue()));
        }
    }

    private void registerSpies(GenericApplicationContext context, Set<String> spiedBeanNames) {
        for (String beanName : spiedBeanNames) {
            BeanDefinition beanDefinition = context.getBeanDefinition(beanName);
            String wrappedBeanName = beanName + "$$WRAPPED_WITH_SPY";
            context.registerBeanDefinition(wrappedBeanName, beanDefinition);
            context.registerBeanDefinition(beanName, (BeanDefinition)this.mockitoSpiesDefiner.createSpyDefinition(wrappedBeanName));
        }
    }

    protected String[] generateDefaultLocations(Class<?> clazz) {
        this.mockedBeans = this.mockedBeansFinder.findMockedBeans(clazz);
        this.spiedBeans = this.mockedBeansFinder.findSpiedBeans(clazz);
        return super.generateDefaultLocations(clazz);
    }

    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        this.mockedBeans = this.mockedBeansFinder.findMockedBeans(clazz);
        this.spiedBeans = this.mockedBeansFinder.findSpiedBeans(clazz);
        return super.modifyLocations(clazz, locations);
    }

    void setMockedBeansFinder(DesiredMockitoBeansFinder mockedBeansFinder) {
        this.mockedBeansFinder = mockedBeansFinder;
    }

    void setMockitoBeansDefiner(MockitoBeansDefiner mockitoBeansDefiner) {
        this.mockitoBeansDefiner = mockitoBeansDefiner;
    }

    void setMockitoSpiesDefiner(MockitoSpiesDefiner mockitoSpiesDefiner) {
        this.mockitoSpiesDefiner = mockitoSpiesDefiner;
    }
}

