/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.JsonElement;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.message.ResponseError;

public class JsonRpcErrorException
extends JsonRpcException {
    private static final long serialVersionUID = 1584953670536766280L;
    private final ResponseError error;

    public JsonRpcErrorException(int code, String message) {
        this(code, message, null);
    }

    public JsonRpcErrorException(int code, String message, JsonElement data) {
        this(new ResponseError(code, message, data));
    }

    public JsonRpcErrorException(ResponseError error) {
        super(JsonRpcErrorException.createExceptionMessage(error));
        this.error = error;
    }

    private static String createExceptionMessage(ResponseError error) {
        return error.getMessage() + (error.getData() != null ? ". Data: " + error.getData() : "");
    }

    public ResponseError getError() {
        return this.error;
    }

    public String getData() {
        return this.error.getData();
    }

    public int getCode() {
        return this.error.getCode();
    }
}

