/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.TransportException;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.ws.PendingRequests;
import org.kurento.jsonrpc.internal.ws.WebSocketResponseSender;
import org.kurento.jsonrpc.message.MessageUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectionManager;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class JsonRpcClientWebSocket
extends JsonRpcClient {
    private final Logger log = LoggerFactory.getLogger(JsonRpcClientWebSocket.class);
    private ExecutorService execService = Executors.newFixedThreadPool(10);
    private String url;
    private volatile WebSocketSession wsSession;
    private final PendingRequests pendingRequests = new PendingRequests();
    private final HttpHeaders headers = new HttpHeaders();
    private TransactionImpl.ResponseSender rs;
    private static final long TIMEOUT = 10000L;

    public JsonRpcClientWebSocket(String url) {
        this(url, new HttpHeaders());
    }

    public JsonRpcClientWebSocket(String url, HttpHeaders headers) {
        this.url = url;
        this.rsHelper = new JsonRpcRequestSenderHelper(){

            @Override
            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass);
            }

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> resultClass, Continuation<Response<JsonElement>> continuation) {
                JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass, continuation);
            }
        };
        this.headers.putAll((Map)headers);
    }

    protected void internalSendRequestWebSocket(final Request<? extends Object> request, final Class<JsonElement> resultClass, final Continuation<Response<JsonElement>> continuation) {
        this.execService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Response result = JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass);
                    try {
                        continuation.onSuccess(result);
                    }
                    catch (Exception e) {
                        JsonRpcClientWebSocket.this.log.error("Exception while processing response", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    continuation.onError(e);
                }
            }
        });
    }

    public synchronized void connectIfNecessary() throws IOException {
        if (this.wsSession == null) {
            final CountDownLatch latch = new CountDownLatch(1);
            TextWebSocketHandler webSocketHandler = new TextWebSocketHandler(){

                public void afterConnectionEstablished(WebSocketSession wsSession2) throws Exception {
                    JsonRpcClientWebSocket.this.wsSession = wsSession2;
                    JsonRpcClientWebSocket.this.rs = new WebSocketResponseSender(JsonRpcClientWebSocket.this.wsSession);
                    latch.countDown();
                }

                public void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
                    JsonRpcClientWebSocket.this.handleWebSocketTextMessage(message);
                }

                public void afterConnectionClosed(WebSocketSession s, CloseStatus status) throws Exception {
                    JsonRpcClientWebSocket.this.handlerManager.afterConnectionClosed(JsonRpcClientWebSocket.this.session, status.getReason());
                    JsonRpcClientWebSocket.this.log.debug("WebSocket closed due to: {}", (Object)status);
                    JsonRpcClientWebSocket.this.wsSession = null;
                }
            };
            WebSocketConnectionManager connectionManager = new WebSocketConnectionManager((WebSocketClient)new StandardWebSocketClient(), (WebSocketHandler)webSocketHandler, this.url, new Object[0]);
            connectionManager.setHeaders(this.headers);
            connectionManager.start();
            try {
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    throw new KurentoException("Timeout of 10s when waiting to connect to Websocket server");
                }
                if (this.session == null) {
                    this.session = new ClientSession(null, null, this);
                    this.handlerManager.afterConnectionEstablished(this.session);
                } else {
                    String result = this.rsHelper.sendRequest("reconnect", String.class);
                    this.log.info("Reconnection result: {}", (Object)result);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void handleWebSocketTextMessage(TextMessage message) throws IOException {
        JsonObject jsonMessage = JsonUtils.fromJson((String)message.getPayload(), JsonObject.class);
        if (jsonMessage.has("method")) {
            this.handleRequestFromServer(jsonMessage);
        } else {
            this.handleResponseFromServer(jsonMessage);
        }
    }

    private void handleRequestFromServer(final JsonObject message) throws IOException {
        this.execService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JsonRpcClientWebSocket.this.handlerManager.handleRequest(JsonRpcClientWebSocket.this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), JsonRpcClientWebSocket.this.rs);
                }
                catch (IOException e) {
                    JsonRpcClientWebSocket.this.log.warn("Exception processing request " + message, (Throwable)e);
                }
            }
        });
    }

    private void handleResponseFromServer(JsonObject message) {
        Response<JsonElement> response = JsonUtils.fromJsonResponse(message, JsonElement.class);
        this.setSessionId(response.getSessionId());
        this.pendingRequests.handleResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P, R> Response<R> internalSendRequestWebSocket(Request<P> request, Class<R> resultClass) throws IOException {
        this.connectIfNecessary();
        Future<Response<JsonElement>> responseFuture = null;
        if (request.getId() != null) {
            responseFuture = this.pendingRequests.prepareResponse(request.getId());
        }
        String jsonMessage = request.toString();
        this.log.debug("Req-> {}", (Object)jsonMessage.trim());
        WebSocketSession webSocketSession = this.wsSession;
        synchronized (webSocketSession) {
            this.wsSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)jsonMessage));
        }
        if (responseFuture == null) {
            return null;
        }
        try {
            Response<JsonElement> responseJson = responseFuture.get(10000L, TimeUnit.MILLISECONDS);
            this.log.debug("<-Res {}", (Object)responseJson.toString());
            Response<R> response = MessageUtils.convertResponse(responseJson, resultClass);
            if (response.getSessionId() != null) {
                this.session.setSessionId(response.getSessionId());
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new KurentoException("Interrupted while waiting for a response", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new KurentoException("This exception shouldn't be thrown", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new TransportException("Timeout of 10000 seconds waiting from response", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.wsSession != null) {
            this.wsSession.close();
        }
    }

    public WebSocketSession getWebSocketSession() {
        return this.wsSession;
    }
}

