/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.ws;

import java.io.IOException;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public final class WebSocketResponseSender
implements TransactionImpl.ResponseSender {
    private static final Logger log = LoggerFactory.getLogger(WebSocketResponseSender.class);
    private final WebSocketSession wsSession;

    public WebSocketResponseSender(WebSocketSession wsSession) {
        this.wsSession = wsSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(Message message) throws IOException {
        String jsonMessage = message.toString();
        log.debug("<-Res {}", (Object)jsonMessage);
        WebSocketSession webSocketSession = this.wsSession;
        synchronized (webSocketSession) {
            this.wsSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)jsonMessage));
        }
    }
}

