/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultJsonRpcHandler<P>
implements JsonRpcHandler<P> {
    private final Logger log = LoggerFactory.getLogger(DefaultJsonRpcHandler.class);

    @Override
    public void afterConnectionEstablished(Session session) throws Exception {
    }

    @Override
    public void afterConnectionClosed(Session session, String status) throws Exception {
    }

    @Override
    public void handleTransportError(Session session, Throwable exception) throws Exception {
        this.log.warn("Transport error", exception);
    }

    @Override
    public void handleUncaughtException(Session session, Exception exception) {
        this.log.warn("Uncaught exception in handler {}", (Object)this.getClass().getName(), (Object)exception);
    }

    @Override
    public Class<?> getHandlerType() {
        return this.getClass();
    }
}

