/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.ContentType;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.internal.HttpResponseSender;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClientHttp
extends JsonRpcClient {
    private final Logger log = LoggerFactory.getLogger(JsonRpcClient.class);
    private Thread longPoolingThread;
    private String url;
    private HttpResponseSender rs;

    public JsonRpcClientHttp(String url) {
        this.url = url;
        this.rs = new HttpResponseSender();
        this.rsHelper = new JsonRpcRequestSenderHelper(){

            @Override
            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return JsonRpcClientHttp.this.internalSendRequestHttp(request, resultClass);
            }

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> class1, Continuation<Response<JsonElement>> continuation) {
                throw new UnsupportedOperationException("Async client int local is unavailable");
            }
        };
    }

    private void updateSession(Response<?> response) {
        String sessionId = response.getSessionId();
        this.rsHelper.setSessionId(sessionId);
        if (this.session == null) {
            this.session = new ClientSession(sessionId, this.registerInfo, this);
            this.handlerManager.afterConnectionEstablished(this.session);
            this.startPooling();
        }
    }

    private void startPooling() {
        this.longPoolingThread = new Thread(){

            @Override
            public void run() {
                JsonRpcClientHttp.this.longPooling();
            }
        };
        this.longPoolingThread.start();
    }

    private void longPooling() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.log.debug("Long polling thread interrupted", (Throwable)e);
            }
            if (Thread.interrupted()) break;
            try {
                JsonElement requestsListJsonObject = this.sendRequest("poll", this.rs.getResponseListToSend(), JsonElement.class);
                this.log.info("Response from pool: {}", (Object)requestsListJsonObject);
                Type collectionType = new TypeToken<List<Request<JsonElement>>>(){}.getType();
                List requestList = (List)JsonUtils.fromJson(requestsListJsonObject, collectionType);
                this.processServerRequests(requestList);
            }
            catch (IOException e) {
                this.log.error("Exception when waiting for events (long-polling). Retry", (Throwable)e);
            }
        }
    }

    private void processServerRequests(List<Request<JsonElement>> requestList) {
        for (Request<JsonElement> request : requestList) {
            try {
                this.handlerManager.handleRequest(this.session, request, this.rs);
            }
            catch (IOException e) {
                this.log.error("Exception while processing request from server to client", (Throwable)e);
            }
        }
    }

    private <P, R> Response<R> internalSendRequestHttp(Request<P> request, Class<R> resultClass) throws IOException {
        String resultJson = org.apache.http.client.fluent.Request.Post((String)this.url).bodyString(JsonUtils.toJson(request), ContentType.APPLICATION_JSON).execute().returnContent().asString();
        if (resultJson == null || resultJson.trim().isEmpty()) {
            return new Response(request.getId(), new ResponseError(3, "The server send an empty response"));
        }
        Response<R> response = JsonUtils.fromJsonResponse(resultJson, resultClass);
        this.updateSession(response);
        return response;
    }

    @Override
    public void close() {
        if (this.longPoolingThread != null) {
            this.log.info("Interrupted!!!");
            this.longPoolingThread.interrupt();
        }
        this.handlerManager.afterConnectionClosed(this.session, "Client closed connection");
        this.session = null;
    }

    @Override
    public void connect() throws IOException {
        try {
            org.apache.http.client.fluent.Request.Post((String)this.url).bodyString("", ContentType.APPLICATION_JSON).execute();
        }
        catch (ClientProtocolException clientProtocolException) {
            // empty catch block
        }
    }
}

