/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.TransportException;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcWSConnectionListener;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.internal.client.ClientWebSocketResponseSender;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.ws.PendingRequests;
import org.kurento.jsonrpc.message.MessageUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClientWebSocket
extends JsonRpcClient {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcClientWebSocket.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private ExecutorService execService = Executors.newFixedThreadPool(10);
    private String url;
    private volatile Session wsSession;
    private final PendingRequests pendingRequests = new PendingRequests();
    private TransactionImpl.ResponseSender rs;
    private JsonRpcWSConnectionListener connectionListener;
    private boolean clientClose = false;
    private static final long TIMEOUT = 60000L;
    private WebSocketClient client;

    public JsonRpcClientWebSocket(String url) {
        this(url, null);
    }

    public JsonRpcClientWebSocket(String url, JsonRpcWSConnectionListener connectionListener) {
        this.url = url;
        this.connectionListener = connectionListener;
        this.rsHelper = new JsonRpcRequestSenderHelper(){

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> resultClass, Continuation<Response<JsonElement>> continuation) {
                JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass, continuation);
            }

            @Override
            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass);
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.wsSession != null) {
            this.clientClose = true;
            this.wsSession.close();
            this.client.destroy();
        }
    }

    public void closeNativeSession() {
        this.wsSession.close();
    }

    @Override
    public void connect() throws IOException {
        this.connectIfNecessary();
    }

    public synchronized void connectIfNecessary() throws IOException {
        block11: {
            if (this.wsSession == null || !this.wsSession.isOpen()) {
                try {
                    this.client = new WebSocketClient();
                    SimpleEchoSocket socket = new SimpleEchoSocket();
                    this.client.start();
                    ClientUpgradeRequest request = new ClientUpgradeRequest();
                    Thread.sleep(100L);
                    this.wsSession = (Session)this.client.connect((Object)socket, new URI(this.url), request).get();
                }
                catch (Exception e) {
                    throw new KurentoException("Exception connecting to WebSocket server", (Throwable)e);
                }
                try {
                    if (!this.latch.await(15L, TimeUnit.SECONDS)) {
                        if (this.connectionListener != null) {
                            this.connectionListener.connectionTimeout();
                        }
                        throw new KurentoException("Timeout of 15s when waiting to connect to Websocket server");
                    }
                    if (this.session == null) {
                        this.session = new ClientSession(null, null, this);
                        this.handlerManager.afterConnectionEstablished(this.session);
                        break block11;
                    }
                    try {
                        String result = this.rsHelper.sendRequest("connect", String.class);
                        log.info("Reconnection result: {}", (Object)result);
                        log.info("Reconnected to the same Kurento server");
                    }
                    catch (JsonRpcErrorException e) {
                        if (e.getCode() == 40007) {
                            this.rsHelper.setSessionId(null);
                            String result = this.rsHelper.sendRequest("connect", String.class);
                            log.info("Reconnection result: {}", (Object)result);
                            log.info("Reconnected to a new Kurento server");
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public Session getWebSocketSession() {
        return this.wsSession;
    }

    protected void handleReconnectDisconnection(int statusCode, final String closeReason) {
        if (!this.clientClose) {
            this.execService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JsonRpcClientWebSocket.this.connectIfNecessary();
                    }
                    catch (KurentoException e) {
                        JsonRpcClientWebSocket.this.handlerManager.afterConnectionClosed(JsonRpcClientWebSocket.this.session, closeReason);
                        log.debug("WebSocket closed due to: {}", (Object)closeReason);
                        JsonRpcClientWebSocket.this.wsSession = null;
                        if (JsonRpcClientWebSocket.this.connectionListener != null) {
                            JsonRpcClientWebSocket.this.connectionListener.disconnected();
                        }
                    }
                    catch (IOException e) {
                        log.warn("Exception trying to reconnect", (Throwable)e);
                    }
                }
            });
        } else {
            this.handlerManager.afterConnectionClosed(this.session, closeReason);
            if (this.connectionListener != null) {
                this.connectionListener.disconnected();
            }
        }
    }

    private void handleRequestFromServer(final JsonObject message) throws IOException {
        this.execService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JsonRpcClientWebSocket.this.handlerManager.handleRequest(JsonRpcClientWebSocket.this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), JsonRpcClientWebSocket.this.rs);
                }
                catch (IOException e) {
                    log.warn("Exception processing request " + message, (Throwable)e);
                }
            }
        });
    }

    private void handleResponseFromServer(JsonObject message) {
        Response<JsonElement> response = JsonUtils.fromJsonResponse(message, JsonElement.class);
        this.setSessionId(response.getSessionId());
        this.pendingRequests.handleResponse(response);
    }

    private void handleWebSocketTextMessage(String message) throws IOException {
        JsonObject jsonMessage = JsonUtils.fromJson(message, JsonObject.class);
        if (jsonMessage.has("method")) {
            this.handleRequestFromServer(jsonMessage);
        } else {
            this.handleResponseFromServer(jsonMessage);
        }
    }

    protected void internalSendRequestWebSocket(final Request<? extends Object> request, final Class<JsonElement> resultClass, final Continuation<Response<JsonElement>> continuation) {
        this.execService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Response result = JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass);
                    try {
                        continuation.onSuccess(result);
                    }
                    catch (Exception e) {
                        log.error("Exception while processing response", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    continuation.onError(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P, R> Response<R> internalSendRequestWebSocket(Request<P> request, Class<R> resultClass) throws IOException {
        this.connectIfNecessary();
        Future<Response<JsonElement>> responseFuture = null;
        if (request.getId() != null) {
            responseFuture = this.pendingRequests.prepareResponse(request.getId());
        }
        String jsonMessage = request.toString();
        log.debug("Req-> {}", (Object)jsonMessage.trim());
        Session session = this.wsSession;
        synchronized (session) {
            this.wsSession.getRemote().sendString(jsonMessage);
        }
        if (responseFuture == null) {
            return null;
        }
        try {
            Response<JsonElement> responseJson = responseFuture.get(60000L, TimeUnit.MILLISECONDS);
            log.debug("<-Res {}", (Object)responseJson.toString());
            Response<R> response = MessageUtils.convertResponse(responseJson, resultClass);
            if (response.getSessionId() != null) {
                this.session.setSessionId(response.getSessionId());
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new KurentoException("Interrupted while waiting for a response", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new KurentoException("This exception shouldn't be thrown", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new TransportException("Timeout of 60000 milliseconds waiting from response to request with id:" + request.getId(), e);
        }
    }

    @WebSocket(maxTextMessageSize=65536)
    public class SimpleEchoSocket {
        @OnWebSocketClose
        public void onClose(int statusCode, String closeReason) {
            JsonRpcClientWebSocket.this.handleReconnectDisconnection(statusCode, closeReason);
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
            JsonRpcClientWebSocket.this.wsSession = session;
            JsonRpcClientWebSocket.this.rs = new ClientWebSocketResponseSender(JsonRpcClientWebSocket.this.wsSession);
            JsonRpcClientWebSocket.this.latch.countDown();
            if (JsonRpcClientWebSocket.this.connectionListener != null) {
                JsonRpcClientWebSocket.this.connectionListener.connected();
            }
        }

        @OnWebSocketMessage
        public void onMessage(String message) {
            try {
                JsonRpcClientWebSocket.this.handleWebSocketTextMessage(message);
            }
            catch (IOException e) {
                throw new KurentoException((Throwable)e);
            }
        }
    }
}

