/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtils {
    private static Logger log = LoggerFactory.getLogger(MessageUtils.class);

    public static <R> Response<R> convertResponse(Response<JsonElement> response, Class<R> resultClass) {
        R resultR = MessageUtils.convertJsonTo(response.getResult(), resultClass);
        Response<JsonElement> responseR = response;
        responseR.setResult((JsonElement)resultR);
        return responseR;
    }

    public static <P> Request<P> convertRequest(Request<? extends Object> request, Class<P> paramsClass) {
        Object paramsP = null;
        Object params = request.getParams();
        if (params != null) {
            if (paramsClass.isAssignableFrom(params.getClass())) {
                paramsP = params;
            } else if (params instanceof JsonElement) {
                paramsP = MessageUtils.convertJsonTo((JsonElement)request.getParams(), paramsClass);
            } else {
                throw new ClassCastException();
            }
        }
        Request<? extends Object> requestP = request;
        requestP.setParams(paramsP);
        return requestP;
    }

    private static <R> R convertJsonTo(JsonElement resultJsonObject, Class<R> resultClass) {
        if (resultJsonObject == null) {
            return null;
        }
        Object resultR = null;
        if (resultClass == String.class || resultClass == Boolean.class || resultClass == Character.class || Number.class.isAssignableFrom(resultClass) || resultClass.isPrimitive()) {
            Object value;
            if (resultJsonObject.isJsonObject()) {
                Set properties = ((JsonObject)resultJsonObject).entrySet();
                if (properties.size() > 1) {
                    Map.Entry prop = (Map.Entry)properties.iterator().next();
                    log.warn("Converting a result with {} properties in a value of type {}. Selecting propoerty '{}'", new Object[]{properties.size(), resultClass, prop.getKey()});
                    value = (JsonElement)prop.getValue();
                } else {
                    value = properties.size() == 1 ? (JsonElement)((Map.Entry)properties.iterator().next()).getValue() : null;
                }
            } else if (resultJsonObject.isJsonArray()) {
                JsonArray array = (JsonArray)resultJsonObject;
                if (array.size() > 1) {
                    log.warn("Converting an array with {} elements in a value of type {}. Selecting first element", (Object)array.size(), resultClass);
                }
                value = array.get(0);
            } else {
                value = resultJsonObject;
            }
            resultR = JsonUtils.getGson().fromJson(value, resultClass);
        } else {
            resultR = JsonUtils.getGson().fromJson(resultJsonObject, resultClass);
        }
        return (R)resultR;
    }
}

