/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.ThreadFactoryCreator;
import org.kurento.commons.TimeoutReentrantLock;
import org.kurento.commons.TimeoutRuntimeException;
import org.kurento.jsonrpc.JsonRpcClientClosedException;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.Handler;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcWSConnectionListener;
import org.kurento.jsonrpc.client.ReconnectedHandler;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.ws.PendingRequests;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.MessageUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonRpcClientWebSocket
extends JsonRpcClient {
    private static final int CONNECTION_LOCK_TIMEOUT = 25000;
    private static Logger log = LoggerFactory.getLogger(AbstractJsonRpcClientWebSocket.class);
    protected static final long RECONNECT_DELAY_TIME_MILLIS = PropertiesManager.getProperty((String)"jsonRpcClientWebSocket.reconnectionDelay", (int)2000);
    private long requestTimeout = PropertiesManager.getProperty((String)"jsonRpcClientWebSocket.timeout", (int)60000);
    protected static final int maxPacketSize = PropertiesManager.getProperty((String)"jsonRpcClientWebSocket.packetSize", (int)1000000);
    private volatile ExecutorService reqResEventExec;
    private volatile ScheduledExecutorService disconnectExec;
    protected URI uri;
    private final PendingRequests pendingRequests = new PendingRequests();
    private TransactionImpl.ResponseSender rs;
    private JsonRpcWSConnectionListener connectionListener;
    private Handler connectedHandler;
    private Handler connectionFailedHandler;
    private Handler disconnectedHandler;
    private Handler reconnectingHandler;
    private ReconnectedHandler reconnectedHandler;
    private volatile boolean reconnecting;
    private TimeoutReentrantLock lock;
    private boolean sendCloseMessage;
    private boolean concurrentServerRequest = true;
    private boolean tryReconnectingForever;
    private long tryReconnectingMaxTime;
    private boolean retryingIfTimeoutToConnect;
    private boolean startSessionWhenConnected;
    private long maxTimeReconnecting;
    private Object executorsLock = new Object();

    public AbstractJsonRpcClientWebSocket(String url, JsonRpcWSConnectionListener connectionListener) {
        String scheme;
        this.lock = new TimeoutReentrantLock(25000L, "Server " + url);
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The URL received as argument is not a valid URL", e);
        }
        String string = scheme = this.uri.getScheme() == null ? "ws" : this.uri.getScheme();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Only WS(S) is supported.");
        }
        this.connectionListener = connectionListener;
        this.rsHelper = new JsonRpcRequestSenderHelper(){

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> resultClass, Continuation<Response<JsonElement>> continuation) {
                AbstractJsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass, continuation);
            }

            @Override
            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return AbstractJsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass);
            }
        };
    }

    @Override
    public void setRequestTimeout(long timeout) {
        this.requestTimeout = timeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setSendCloseMessage(boolean sendCloseMessage) {
        this.sendCloseMessage = sendCloseMessage;
    }

    public boolean isSendCloseMessage() {
        return this.sendCloseMessage;
    }

    public void setTryReconnectingForever(boolean tryReconnectingForever) {
        this.tryReconnectingForever = tryReconnectingForever;
    }

    public boolean isTryReconnectingForever() {
        return this.tryReconnectingForever;
    }

    public void setConcurrentServerRequest(boolean concurrentServerRequest) {
        this.concurrentServerRequest = concurrentServerRequest;
    }

    public boolean isConcurrentServerRequest() {
        return this.concurrentServerRequest;
    }

    private void fireEvent(Runnable r) {
        this.createExecServiceIfNecessary();
        this.reqResEventExec.submit(r);
    }

    protected void fireReconnectedNewServer() {
        if (this.connectionListener != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectionListener.reconnected(false);
                }
            });
        }
        if (this.reconnectedHandler != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.reconnectedHandler.run(false);
                }
            });
        }
    }

    protected void fireReconnectedSameServer() {
        if (this.connectionListener != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectionListener.reconnected(true);
                }
            });
        }
        if (this.reconnectedHandler != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.reconnectedHandler.run(true);
                }
            });
        }
    }

    protected void fireConnectionFailed() {
        if (this.connectionListener != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectionListener.connectionFailed();
                }
            });
        }
        if (this.connectionFailedHandler != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectionFailedHandler.run();
                }
            });
        }
    }

    protected void fireConnected() {
        if (this.connectionListener != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectionListener.connected();
                }
            });
        }
        if (this.connectedHandler != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectedHandler.run();
                }
            });
        }
    }

    protected void fireReconnecting() {
        if (this.connectionListener != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectionListener.reconnecting();
                }
            });
        }
        if (this.reconnectingHandler != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.reconnectingHandler.run();
                }
            });
        }
    }

    protected void fireDisconnected() {
        if (this.connectionListener != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.connectionListener.disconnected();
                }
            });
        }
        if (this.disconnectedHandler != null) {
            this.fireEvent(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.disconnectedHandler.run();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createExecServiceIfNecessary() {
        if (this.reqResEventExec == null || this.disconnectExec == null || this.reqResEventExec.isShutdown() || this.reqResEventExec.isTerminated() || this.disconnectExec.isShutdown() || this.disconnectExec.isTerminated()) {
            Object object = this.executorsLock;
            synchronized (object) {
                if (this.reqResEventExec == null || this.reqResEventExec.isShutdown() || this.reqResEventExec.isTerminated()) {
                    this.reqResEventExec = Executors.newCachedThreadPool(ThreadFactoryCreator.create((String)"AbstractJsonRpcClientWebSocket-reqResEventExec"));
                }
                if (this.disconnectExec == null || this.disconnectExec.isShutdown() || this.disconnectExec.isTerminated()) {
                    this.disconnectExec = Executors.newScheduledThreadPool(1, ThreadFactoryCreator.create((String)"AbstractJsonRpcClientWebSocket-disconnectExec"));
                }
            }
        }
    }

    protected <P, R> Response<R> internalSendRequestWebSocket(Request<P> request, Class<R> resultClass) throws IOException {
        this.connectIfNecessary(false);
        ListenableFuture<Response<JsonElement>> responseFuture = null;
        if (request.getId() != null) {
            responseFuture = this.pendingRequests.prepareResponse(request.getId());
        }
        boolean isPing = false;
        String jsonMessage = request.toString();
        if ("ping".equals(request.getMethod())) {
            isPing = true;
            log.trace("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
        } else {
            log.debug("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
        }
        this.sendTextMessage(jsonMessage);
        if (responseFuture == null) {
            return null;
        }
        try {
            Response responseJson = (Response)responseFuture.get(this.requestTimeout, TimeUnit.MILLISECONDS);
            if (isPing) {
                log.trace("{} <-Res {}", (Object)this.label, (Object)responseJson.toString());
            } else {
                log.debug("{} <-Res {}", (Object)this.label, (Object)responseJson.toString());
            }
            Response<R> response = MessageUtils.convertResponse(responseJson, resultClass);
            if (response.getSessionId() != null) {
                this.session.setSessionId(response.getSessionId());
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new JsonRpcException(this.label + " Interrupted while waiting for a response", e);
        }
        catch (ExecutionException e) {
            throw new JsonRpcException(this.label + " This exception shouldn't be thrown", e);
        }
        catch (TimeoutException e) {
            throw new JsonRpcException(this.label + " Timeout of " + this.requestTimeout + " milliseconds waiting from response to request " + jsonMessage.trim(), e);
        }
    }

    protected <P> void internalSendRequestWebSocket(Request<P> request, final Class<JsonElement> resultClass, final Continuation<Response<JsonElement>> continuation) {
        try {
            boolean isPing;
            this.connectIfNecessary(false);
            ListenableFuture<Response<JsonElement>> responseFuture = null;
            if (request.getId() != null) {
                responseFuture = this.pendingRequests.prepareResponse(request.getId());
            }
            String jsonMessage = request.toString();
            if ("ping".equals(request.getMethod())) {
                isPing = true;
                log.trace("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
            } else {
                isPing = false;
                log.debug("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
            }
            this.sendTextMessage(jsonMessage);
            if (responseFuture != null) {
                this.createExecServiceIfNecessary();
                Futures.addCallback(responseFuture, (FutureCallback)new FutureCallback<Response<JsonElement>>(){

                    public void onSuccess(Response<JsonElement> responseJson) {
                        if (isPing) {
                            log.trace("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)responseJson.toString());
                        } else {
                            log.debug("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)responseJson.toString());
                        }
                        try {
                            Response response = MessageUtils.convertResponse(responseJson, resultClass);
                            if (response.getSessionId() != null) {
                                AbstractJsonRpcClientWebSocket.this.session.setSessionId(response.getSessionId());
                            }
                            continuation.onSuccess(response);
                        }
                        catch (Exception e) {
                            continuation.onError(e);
                        }
                    }

                    public void onFailure(Throwable thrown) {
                        continuation.onError(thrown);
                    }
                }, (Executor)this.reqResEventExec);
            }
        }
        catch (Exception e) {
            continuation.onError(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        String sessionId = this.session != null ? this.session.getSessionId() : "";
        log.debug("{} Explicit close of JsonRpcClientWebsocket with sessionId={}", (Object)this.label, (Object)sessionId);
        if (this.sendCloseMessage) {
            try {
                this.sendRequest("closeSession");
            }
            catch (Exception e) {
                log.warn("{} Exception sending close message. {}:{}", new Object[]{this.label, e.getClass().getName(), e.getMessage()});
            }
        }
        this.reconnecting = false;
        this.closeClient("Session closed by JsonRpcClientWebsocket user", true);
    }

    protected synchronized void closeClient(String reason, boolean shutdownReconnectThread) {
        if (!this.reconnecting) {
            this.notifyDisconnection(reason, false);
        }
        this.closeNativeClient();
        if (this.reqResEventExec != null) {
            try {
                this.reqResEventExec.shutdown();
            }
            catch (Exception e) {
                log.debug("{} Could not properly shut down executor service. Reason: {}", (Object)this.label, (Object)e.getMessage());
            }
            this.reqResEventExec = null;
        }
        if (this.disconnectExec != null && shutdownReconnectThread) {
            try {
                this.disconnectExec.shutdownNow();
            }
            catch (Exception e) {
                log.debug("{} Could not properly shut down disconnect executor service. Reason: {}", (Object)this.label, (Object)e.getMessage());
            }
            this.disconnectExec = null;
        }
        if (this.heartbeating) {
            this.disableHeartbeat();
        }
    }

    private void notifyDisconnection(String reason, boolean connectedBefore) {
        if (this.isClosedByUser() || connectedBefore) {
            this.fireDisconnected();
        } else {
            this.fireConnectionFailed();
        }
        this.pendingRequests.closeAllPendingRequests();
        if (this.session != null) {
            this.handlerManager.afterConnectionClosed(this.session, reason);
        }
    }

    protected void handleResponseFromServer(JsonObject message) {
        Response<JsonElement> response = JsonUtils.fromJsonResponse(message, JsonElement.class);
        this.setSessionId(response.getSessionId());
        this.pendingRequests.handleResponse(response);
    }

    protected void receivedTextMessage(String message) {
        try {
            JsonObject jsonMessage = JsonUtils.fromJson(message, JsonObject.class);
            if (jsonMessage.has("method")) {
                this.handleRequestFromServer(jsonMessage);
            } else {
                this.handleResponseFromServer(jsonMessage);
            }
        }
        catch (Exception e) {
            log.error("{} Exception processing jsonRpc message {}", new Object[]{this.label, message, e});
        }
    }

    void handleRequestFromServer(final JsonObject message) {
        if (this.concurrentServerRequest) {
            this.createExecServiceIfNecessary();
            this.reqResEventExec.submit(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.handlerManager.handleRequest(AbstractJsonRpcClientWebSocket.this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), AbstractJsonRpcClientWebSocket.this.rs);
                }
            });
        } else {
            try {
                this.handlerManager.handleRequest(this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), this.rs);
            }
            catch (Exception e) {
                log.warn("{} Exception processing request {}", new Object[]{this.label, message, e});
            }
        }
    }

    protected void handleReconnectDisconnection(int statusCode, String closeReason) {
        if (!this.isClosedByUser()) {
            log.debug("{}JsonRpcWsClient disconnected from {} because {}.", new Object[]{this.label, this.uri, closeReason});
            this.reconnect(closeReason);
        } else {
            this.pendingRequests.closeAllPendingRequests();
            this.handlerManager.afterConnectionClosed(this.session, closeReason);
            this.fireDisconnected();
        }
    }

    private void reconnect(String closeReason) {
        this.reconnect(closeReason, 0L, true);
    }

    private void reconnect(final String closeReason, long delayMillis, boolean fireReconnecting) {
        this.reconnecting = true;
        if (fireReconnecting) {
            this.fireReconnecting();
        }
        if (this.heartbeating) {
            this.disableHeartbeat();
        }
        this.createExecServiceIfNecessary();
        this.disconnectExec.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug("{} JsonRpcWsClient reconnecting to {}. ", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)AbstractJsonRpcClientWebSocket.this.uri);
                    AbstractJsonRpcClientWebSocket.this.connectIfNecessary(true);
                    AbstractJsonRpcClientWebSocket.this.reconnecting = false;
                }
                catch (Exception e) {
                    log.debug("tryReconnectingForever = {}", (Object)AbstractJsonRpcClientWebSocket.this.tryReconnectingForever);
                    log.debug("tryReconnectingMaxTime = {}", (Object)AbstractJsonRpcClientWebSocket.this.tryReconnectingMaxTime);
                    log.debug("maxTimeReconnecting = {}", (Object)AbstractJsonRpcClientWebSocket.this.maxTimeReconnecting);
                    log.debug("currentTime = {}", (Object)System.currentTimeMillis());
                    log.debug("Stop connection retries: {}", (Object)(System.currentTimeMillis() > AbstractJsonRpcClientWebSocket.this.maxTimeReconnecting ? 1 : 0));
                    if (!(AbstractJsonRpcClientWebSocket.this.tryReconnectingForever || AbstractJsonRpcClientWebSocket.this.tryReconnectingMaxTime != 0L && System.currentTimeMillis() <= AbstractJsonRpcClientWebSocket.this.maxTimeReconnecting)) {
                        log.warn("{} Exception trying to reconnect to server {}. Notifying disconnection", new Object[]{AbstractJsonRpcClientWebSocket.this.label, AbstractJsonRpcClientWebSocket.this.uri, e});
                        AbstractJsonRpcClientWebSocket.this.notifyDisconnection(closeReason, true);
                    }
                    log.warn("{} Exception trying to reconnect to server {}. Retrying in {} ms", new Object[]{AbstractJsonRpcClientWebSocket.this.label, AbstractJsonRpcClientWebSocket.this.uri, RECONNECT_DELAY_TIME_MILLIS, e});
                    AbstractJsonRpcClientWebSocket.this.reconnect(closeReason, RECONNECT_DELAY_TIME_MILLIS, false);
                }
            }
        }, delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void closeWithReconnection() {
        log.debug("{} Closing websocket session to force reconnection", (Object)this.label);
        this.closeNativeClient();
        this.handleReconnectDisconnection(999, "ping timeout");
    }

    @Override
    public void connect() throws IOException {
        this.closedByClient = false;
        this.connectIfNecessary(true);
    }

    public void connectWithSession() throws IOException {
        this.startSessionWhenConnected = true;
        this.closedByClient = false;
        this.connectIfNecessary(true);
        log.debug("{} Connected to server with session {}", (Object)this.label, (Object)this.getSession().getSessionId());
    }

    protected void internalConnectIfNecessary(boolean shutdownReconnectThread) throws IOException {
        if (!this.isNativeClientConnected()) {
            if (!this.reconnecting) {
                this.updateMaxTimeReconnecting();
            }
            if (this.isClosedByUser()) {
                throw new JsonRpcClientClosedException("Trying to send a message in a client closed explicitly. When a client is closed, it can't be reused. It is necessary to create another one");
            }
            log.debug("{} Connecting webSocket client to server {}", (Object)this.label, (Object)this.uri);
            try {
                this.connectNativeClient();
            }
            catch (Exception e) {
                String exceptionMessage;
                if (e instanceof TimeoutException) {
                    exceptionMessage = this.label + " Timeout of " + this.connectionTimeout + "ms when waiting to connect to Websocket server " + this.uri;
                    if (this.retryingIfTimeoutToConnect) {
                        log.debug(exceptionMessage + ". Retrying...");
                        this.internalConnectIfNecessary(shutdownReconnectThread);
                    }
                } else {
                    exceptionMessage = this.label + " Exception connecting to WebSocket server " + this.uri;
                }
                this.closeClient("Closed by exception: " + exceptionMessage, shutdownReconnectThread);
                throw new JsonRpcException(exceptionMessage, e);
            }
            this.updateSession();
        }
    }

    private void updateMaxTimeReconnecting() {
        this.maxTimeReconnecting = this.tryReconnectingForever ? Long.MAX_VALUE : (this.tryReconnectingMaxTime <= 0L ? 0L : System.currentTimeMillis() + this.tryReconnectingMaxTime);
    }

    private void updateSession() throws IOException {
        if (this.session == null) {
            this.session = new ClientSession(null, null, this);
            this.configureResponseSender();
        }
        if (this.reconnecting) {
            boolean sameServer = this.executeConnectProtocol();
            if (sameServer) {
                this.fireReconnectedSameServer();
            } else {
                this.fireReconnectedNewServer();
            }
        } else {
            if (this.startSessionWhenConnected) {
                this.rsHelper.sendRequest("connect", String.class);
            }
            this.handlerManager.afterConnectionEstablished(this.session);
            this.fireConnected();
        }
        if (this.heartbeating) {
            this.enableHeartbeat();
        }
    }

    boolean executeConnectProtocol() throws IOException {
        try {
            this.rsHelper.sendRequest("connect", String.class);
            log.debug("{} Reconnected to the same session in server {}", (Object)this.label, (Object)this.uri);
            return true;
        }
        catch (JsonRpcErrorException e) {
            if (e.getCode() == 40007) {
                this.pendingRequests.closeAllPendingRequests();
                try {
                    this.rsHelper.setSessionId(null);
                    this.rsHelper.sendRequest("connect", String.class);
                    log.debug("{} Reconnected to a new session in server {}", (Object)this.label, (Object)this.uri);
                    return false;
                }
                catch (Exception e2) {
                    this.closeClient("Closed by exception: " + e.getMessage(), true);
                    throw new JsonRpcException(this.label + " Exception executing reconnect protocol", e2);
                }
            }
            this.closeClient("Closed by exception: " + e.getMessage(), true);
            throw new JsonRpcException(this.label + " Exception executing reconnect protocol", (Throwable)((Object)e));
        }
    }

    void configureResponseSender() {
        this.rs = new TransactionImpl.ResponseSender(){

            @Override
            public void sendResponse(Message message) throws IOException {
                String jsonMessage = message.toString();
                log.debug("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)jsonMessage);
                AbstractJsonRpcClientWebSocket.this.sendTextMessage(jsonMessage);
            }

            @Override
            public void sendPingResponse(Message message) throws IOException {
                String jsonMessage = message.toString();
                log.trace("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)jsonMessage);
                AbstractJsonRpcClientWebSocket.this.sendTextMessage(jsonMessage);
            }
        };
    }

    protected void connectIfNecessary(boolean shutdownReconnectThread) throws IOException {
        try {
            this.lock.tryLockTimeout("connectIfNecessary()");
            try {
                this.internalConnectIfNecessary(shutdownReconnectThread);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (TimeoutRuntimeException e) {
            this.closeClient("Closed by exception: " + e.getMessage(), shutdownReconnectThread);
            throw new TimeoutRuntimeException(this.label + " Timeout trying to connect to websocket server " + this.uri, (Throwable)e);
        }
    }

    public void onConnected(Handler connectedHandler) {
        this.connectedHandler = connectedHandler;
    }

    public void onConnectionFailed(Handler connectionFailedHandler) {
        this.connectionFailedHandler = connectionFailedHandler;
    }

    public void onDisconnected(Handler disconnectedHandler) {
        this.disconnectedHandler = disconnectedHandler;
    }

    public void onReconnecting(Handler reconnectingHandler) {
        this.reconnectingHandler = reconnectingHandler;
    }

    public void onReconnected(ReconnectedHandler reconnectedHandler) {
        this.reconnectedHandler = reconnectedHandler;
    }

    public void setTryReconnectingMaxTime(long tryReconnectingMaxTime) {
        this.tryReconnectingForever = false;
        this.tryReconnectingMaxTime = tryReconnectingMaxTime;
    }

    protected abstract void sendTextMessage(String var1) throws IOException;

    protected abstract void closeNativeClient();

    protected abstract boolean isNativeClientConnected();

    protected abstract void connectNativeClient() throws TimeoutException, Exception;
}

