/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.ThreadFactoryCreator;
import org.kurento.commons.TimeoutReentrantLock;
import org.kurento.commons.TimeoutRuntimeException;
import org.kurento.jsonrpc.JsonRpcClientClosedException;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcWSConnectionListener;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.ws.PendingRequests;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.MessageUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonRpcClientWebSocket
extends JsonRpcClient {
    private static final int CONNECTION_LOCK_TIMEOUT = 25000;
    public static Logger log = LoggerFactory.getLogger(AbstractJsonRpcClientWebSocket.class);
    protected static final long RECONNECT_DELAY_TIME_MILLIS = 5000L;
    private long requestTimeout = PropertiesManager.getProperty((String)"jsonRpcClientWebSocket.timeout", (int)60000);
    private volatile ExecutorService reqResEventExec;
    private volatile ScheduledExecutorService disconnectExec;
    protected String url;
    private final PendingRequests pendingRequests = new PendingRequests();
    private TransactionImpl.ResponseSender rs;
    private JsonRpcWSConnectionListener connectionListener;
    private volatile boolean reconnecting;
    private TimeoutReentrantLock lock;
    private boolean sendCloseMessage;
    private boolean concurrentServerRequest = true;
    private boolean tryReconnectingForever = false;
    private boolean retryingIfTimeoutToConnect = false;
    private boolean startSessionWhenConnected = false;

    public AbstractJsonRpcClientWebSocket(String url, JsonRpcWSConnectionListener connectionListener) {
        this.lock = new TimeoutReentrantLock(25000L, "Server " + url);
        this.url = url;
        this.connectionListener = connectionListener;
        this.rsHelper = new JsonRpcRequestSenderHelper(){

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> resultClass, Continuation<Response<JsonElement>> continuation) {
                AbstractJsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass, continuation);
            }

            @Override
            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return AbstractJsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass);
            }
        };
    }

    @Override
    public void setRequestTimeout(long timeout) {
        this.requestTimeout = timeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setSendCloseMessage(boolean sendCloseMessage) {
        this.sendCloseMessage = sendCloseMessage;
    }

    public boolean isSendCloseMessage() {
        return this.sendCloseMessage;
    }

    public void setTryReconnectingForever(boolean tryReconnectingForever) {
        this.tryReconnectingForever = tryReconnectingForever;
    }

    public boolean isTryReconnectingForever() {
        return this.tryReconnectingForever;
    }

    public void setConcurrentServerRequest(boolean concurrentServerRequest) {
        this.concurrentServerRequest = concurrentServerRequest;
    }

    public boolean isConcurrentServerRequest() {
        return this.concurrentServerRequest;
    }

    private void fireEvent(Runnable r) {
        if (this.connectionListener != null) {
            this.createExecServiceIfNecessary();
            this.reqResEventExec.submit(r);
        }
    }

    protected void fireReconnectedNewServer() {
        this.fireEvent(new Runnable(){

            @Override
            public void run() {
                AbstractJsonRpcClientWebSocket.this.connectionListener.reconnected(false);
            }
        });
    }

    protected void fireReconnectedSameServer() {
        this.fireEvent(new Runnable(){

            @Override
            public void run() {
                AbstractJsonRpcClientWebSocket.this.connectionListener.reconnected(true);
            }
        });
    }

    protected void fireConnectionFailed() {
        this.fireEvent(new Runnable(){

            @Override
            public void run() {
                AbstractJsonRpcClientWebSocket.this.connectionListener.connectionFailed();
            }
        });
    }

    protected void fireConnected() {
        this.fireEvent(new Runnable(){

            @Override
            public void run() {
                AbstractJsonRpcClientWebSocket.this.connectionListener.connected();
            }
        });
    }

    protected void fireReconnecting() {
        this.fireEvent(new Runnable(){

            @Override
            public void run() {
                AbstractJsonRpcClientWebSocket.this.connectionListener.reconnecting();
            }
        });
    }

    protected void fireDisconnected() {
        this.fireEvent(new Runnable(){

            @Override
            public void run() {
                AbstractJsonRpcClientWebSocket.this.connectionListener.disconnected();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createExecServiceIfNecessary() {
        if (this.reqResEventExec == null || this.disconnectExec == null || this.reqResEventExec.isShutdown() || this.reqResEventExec.isTerminated() || this.disconnectExec.isShutdown() || this.disconnectExec.isTerminated()) {
            this.lock.tryLockTimeout("createExecServiceIfNecessary");
            try {
                if (this.reqResEventExec == null || this.reqResEventExec.isShutdown() || this.reqResEventExec.isTerminated()) {
                    this.reqResEventExec = Executors.newCachedThreadPool(ThreadFactoryCreator.create((String)"AbstractJsonRpcClientWebSocket-reqResEventExec"));
                }
                if (this.disconnectExec == null || this.disconnectExec.isShutdown() || this.disconnectExec.isTerminated()) {
                    this.disconnectExec = Executors.newScheduledThreadPool(1, ThreadFactoryCreator.create((String)"AbstractJsonRpcClientWebSocket-disconnectExec"));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected <P, R> Response<R> internalSendRequestWebSocket(Request<P> request, Class<R> resultClass) throws IOException {
        this.connectIfNecessary();
        ListenableFuture<Response<JsonElement>> responseFuture = null;
        if (request.getId() != null) {
            responseFuture = this.pendingRequests.prepareResponse(request.getId());
        }
        boolean isPing = false;
        String jsonMessage = request.toString();
        if ("ping".equals(request.getMethod())) {
            isPing = true;
            log.trace("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
        } else {
            log.debug("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
        }
        this.sendTextMessage(jsonMessage);
        if (responseFuture == null) {
            return null;
        }
        try {
            Response responseJson = (Response)responseFuture.get(this.requestTimeout, TimeUnit.MILLISECONDS);
            if (isPing) {
                log.trace("{} <-Res {}", (Object)this.label, (Object)responseJson.toString());
            } else {
                log.debug("{} <-Res {}", (Object)this.label, (Object)responseJson.toString());
            }
            Response<R> response = MessageUtils.convertResponse(responseJson, resultClass);
            if (response.getSessionId() != null) {
                this.session.setSessionId(response.getSessionId());
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new JsonRpcException(this.label + " Interrupted while waiting for a response", e);
        }
        catch (ExecutionException e) {
            throw new JsonRpcException(this.label + " This exception shouldn't be thrown", e);
        }
        catch (TimeoutException e) {
            throw new JsonRpcException(this.label + " Timeout of " + this.requestTimeout + " milliseconds waiting from response to request " + jsonMessage.trim(), e);
        }
    }

    protected <P> void internalSendRequestWebSocket(Request<P> request, final Class<JsonElement> resultClass, final Continuation<Response<JsonElement>> continuation) {
        try {
            boolean isPing;
            this.connectIfNecessary();
            ListenableFuture<Response<JsonElement>> responseFuture = null;
            if (request.getId() != null) {
                responseFuture = this.pendingRequests.prepareResponse(request.getId());
            }
            String jsonMessage = request.toString();
            if ("ping".equals(request.getMethod())) {
                isPing = true;
                log.trace("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
            } else {
                isPing = false;
                log.debug("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
            }
            this.sendTextMessage(jsonMessage);
            if (responseFuture != null) {
                this.createExecServiceIfNecessary();
                Futures.addCallback(responseFuture, (FutureCallback)new FutureCallback<Response<JsonElement>>(){

                    public void onSuccess(Response<JsonElement> responseJson) {
                        if (isPing) {
                            log.trace("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)responseJson.toString());
                        } else {
                            log.debug("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)responseJson.toString());
                        }
                        try {
                            Response response = MessageUtils.convertResponse(responseJson, resultClass);
                            if (response.getSessionId() != null) {
                                AbstractJsonRpcClientWebSocket.this.session.setSessionId(response.getSessionId());
                            }
                            continuation.onSuccess(response);
                        }
                        catch (Exception e) {
                            continuation.onError(e);
                        }
                    }

                    public void onFailure(Throwable thrown) {
                        continuation.onError(thrown);
                    }
                }, (Executor)this.reqResEventExec);
            }
        }
        catch (Exception e) {
            continuation.onError(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        String sessionId = this.session != null ? this.session.getSessionId() : "";
        log.info("{} Explicit close of JsonRpcClientWebsocket with sessionId={}", (Object)this.label, (Object)sessionId);
        if (this.sendCloseMessage) {
            try {
                this.sendRequest("closeSession");
            }
            catch (Exception e) {
                log.warn("{} Exception sending close message. {}:{}", new Object[]{this.label, e.getClass().getName(), e.getMessage()});
            }
        }
        this.reconnecting = false;
        this.closeClient("Session closed by JsonRpcClientWebsocket user");
    }

    protected synchronized void closeClient(String reason) {
        if (!this.reconnecting) {
            this.notifyUserClientClosed(reason, false);
        }
        this.closeNativeClient();
        if (this.reqResEventExec != null) {
            try {
                this.reqResEventExec.shutdown();
            }
            catch (Exception e) {
                log.debug("{} Could not properly shut down executor service. Reason: {}", (Object)this.label, (Object)e.getMessage());
            }
            this.reqResEventExec = null;
        }
        if (this.disconnectExec != null) {
            try {
                this.disconnectExec.shutdown();
            }
            catch (Exception e) {
                log.debug("{} Could not properly shut down disconnect executor service. Reason: {}", (Object)this.label, (Object)e.getMessage());
            }
            this.disconnectExec = null;
        }
        if (this.heartbeating) {
            this.disableHeartbeat();
        }
    }

    private void notifyUserClientClosed(String reason, boolean connectedBefore) {
        if (this.isClosedByUser() || connectedBefore) {
            this.fireDisconnected();
        } else {
            this.fireConnectionFailed();
        }
        this.pendingRequests.closeAllPendingRequests();
        if (this.session != null) {
            this.handlerManager.afterConnectionClosed(this.session, reason);
        }
    }

    protected void handleResponseFromServer(JsonObject message) {
        Response<JsonElement> response = JsonUtils.fromJsonResponse(message, JsonElement.class);
        this.setSessionId(response.getSessionId());
        this.pendingRequests.handleResponse(response);
    }

    protected void receivedTextMessage(String message) {
        try {
            JsonObject jsonMessage = JsonUtils.fromJson(message, JsonObject.class);
            if (jsonMessage.has("method")) {
                this.handleRequestFromServer(jsonMessage);
            } else {
                this.handleResponseFromServer(jsonMessage);
            }
        }
        catch (Exception e) {
            log.error("{} Exception processing jsonRpc message {}", new Object[]{this.label, message, e});
        }
    }

    void handleRequestFromServer(final JsonObject message) {
        if (this.concurrentServerRequest) {
            this.createExecServiceIfNecessary();
            this.reqResEventExec.submit(new Runnable(){

                @Override
                public void run() {
                    AbstractJsonRpcClientWebSocket.this.handlerManager.handleRequest(AbstractJsonRpcClientWebSocket.this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), AbstractJsonRpcClientWebSocket.this.rs);
                }
            });
        } else {
            try {
                this.handlerManager.handleRequest(this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), this.rs);
            }
            catch (Exception e) {
                log.warn("{} Exception processing request {}", new Object[]{this.label, message, e});
            }
        }
    }

    protected void handleReconnectDisconnection(int statusCode, String closeReason) {
        if (!this.isClosedByUser()) {
            this.reconnect(closeReason);
        } else {
            this.pendingRequests.closeAllPendingRequests();
            this.handlerManager.afterConnectionClosed(this.session, closeReason);
            this.fireDisconnected();
        }
    }

    private void reconnect(String closeReason) {
        this.reconnect(closeReason, 0L);
    }

    private void reconnect(final String closeReason, long delayMillis) {
        this.reconnecting = true;
        this.fireReconnecting();
        if (this.heartbeating) {
            this.disableHeartbeat();
        }
        this.createExecServiceIfNecessary();
        this.disconnectExec.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug("{}JsonRpcWsClient reconnecting to {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)AbstractJsonRpcClientWebSocket.this.url);
                    AbstractJsonRpcClientWebSocket.this.connectIfNecessary();
                    AbstractJsonRpcClientWebSocket.this.reconnecting = false;
                }
                catch (Exception e) {
                    if (!AbstractJsonRpcClientWebSocket.this.tryReconnectingForever) {
                        log.warn("{} Exception trying to reconnect to server {}. The websocket was closed due to {}", new Object[]{AbstractJsonRpcClientWebSocket.this.label, AbstractJsonRpcClientWebSocket.this.url, closeReason, e});
                        AbstractJsonRpcClientWebSocket.this.notifyUserClientClosed(closeReason, true);
                    }
                    AbstractJsonRpcClientWebSocket.this.reconnect(closeReason, 5000L);
                }
            }
        }, delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void closeWithReconnection() {
        log.info("{} Closing websocket session to force reconnection", (Object)this.label);
        this.closeNativeClient();
        this.handleReconnectDisconnection(999, "ping timeout");
    }

    @Override
    public void connect() throws IOException {
        this.closedByClient = false;
        this.connectIfNecessary();
    }

    public void connectWithSession() throws IOException {
        this.startSessionWhenConnected = true;
        this.closedByClient = false;
        this.connectIfNecessary();
        log.info("{} Connected to server with session {}", (Object)this.label, (Object)this.getSession().getSessionId());
    }

    protected void internalConnectIfNecessary() throws IOException {
        if (!this.isNativeClientConnected()) {
            if (this.isClosedByUser()) {
                throw new JsonRpcClientClosedException("Trying to send a message in a client closed explicitly. When a client is closed, it can't be reused. It is necessary to create another one");
            }
            log.debug("{} Connecting webSocket client to server {}", (Object)this.label, (Object)this.url);
            try {
                this.connectNativeClient();
            }
            catch (Exception e) {
                String exceptionMessage;
                if (e instanceof TimeoutException) {
                    exceptionMessage = this.label + " Timeout of " + this.connectionTimeout + "ms when waiting to connect to Websocket server " + this.url;
                    if (this.retryingIfTimeoutToConnect) {
                        log.debug(exceptionMessage + ". Retrying...");
                        this.internalConnectIfNecessary();
                    }
                } else {
                    exceptionMessage = this.label + " Exception connecting to WebSocket server " + this.url;
                }
                this.closeClient("Closed by exception: " + exceptionMessage);
                throw new JsonRpcException(exceptionMessage, e);
            }
            this.updateSession();
        }
    }

    private void updateSession() throws IOException {
        if (this.session == null) {
            this.session = new ClientSession(null, null, this);
            this.configureResponseSender();
        }
        if (this.reconnecting) {
            boolean sameServer = this.executeConnectProtocol();
            if (sameServer) {
                this.fireReconnectedSameServer();
            } else {
                this.fireReconnectedNewServer();
            }
        } else {
            if (this.startSessionWhenConnected) {
                this.rsHelper.sendRequest("connect", String.class);
            }
            this.handlerManager.afterConnectionEstablished(this.session);
            this.fireConnected();
        }
        if (this.heartbeating) {
            this.enableHeartbeat();
        }
    }

    boolean executeConnectProtocol() throws IOException {
        try {
            this.rsHelper.sendRequest("connect", String.class);
            log.info("{} Reconnected to the same session in server {}", (Object)this.label, (Object)this.url);
            return true;
        }
        catch (JsonRpcErrorException e) {
            if (e.getCode() == 40007) {
                this.pendingRequests.closeAllPendingRequests();
                try {
                    this.rsHelper.setSessionId(null);
                    this.rsHelper.sendRequest("connect", String.class);
                    log.info("{} Reconnected to a new session in server {}", (Object)this.label, (Object)this.url);
                    return false;
                }
                catch (Exception e2) {
                    this.closeClient("Closed by exception: " + e.getMessage());
                    throw new JsonRpcException(this.label + " Exception executing reconnect protocol", e2);
                }
            }
            this.closeClient("Closed by exception: " + e.getMessage());
            throw new JsonRpcException(this.label + " Exception executing reconnect protocol", (Throwable)((Object)e));
        }
    }

    void configureResponseSender() {
        this.rs = new TransactionImpl.ResponseSender(){

            @Override
            public void sendResponse(Message message) throws IOException {
                String jsonMessage = message.toString();
                log.debug("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)jsonMessage);
                AbstractJsonRpcClientWebSocket.this.sendTextMessage(jsonMessage);
            }

            @Override
            public void sendPingResponse(Message message) throws IOException {
                String jsonMessage = message.toString();
                log.trace("{} <-Res {}", (Object)AbstractJsonRpcClientWebSocket.this.label, (Object)jsonMessage);
                AbstractJsonRpcClientWebSocket.this.sendTextMessage(jsonMessage);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectIfNecessary() throws IOException {
        try {
            this.lock.tryLockTimeout("connectIfNecessary()");
            try {
                this.internalConnectIfNecessary();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (TimeoutRuntimeException e) {
            this.closeClient("Closed by exception: " + e.getMessage());
            throw new TimeoutRuntimeException(this.label + " Timeout trying to connect to websocket server " + this.url, (Throwable)e);
        }
    }

    protected abstract void sendTextMessage(String var1) throws IOException;

    protected abstract void closeNativeClient();

    protected abstract boolean isNativeClientConnected();

    protected abstract void connectNativeClient() throws TimeoutException, Exception;
}

