/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.message;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.kurento.jsonrpc.JsonRpcErrorException;

public class ResponseError {
    private static final String TYPE_PROPERTY = "type";
    private Integer code;
    private String message;
    private JsonElement data;
    private String type;

    public static ResponseError newFromException(Throwable e) {
        return ResponseError.newFromException(-1, null, e);
    }

    public static ResponseError newFromException(String message, Throwable e) {
        return ResponseError.newFromException(-1, message, e);
    }

    public static ResponseError newFromException(int requestId, Throwable e) {
        return ResponseError.newFromException(requestId, null, e);
    }

    public static ResponseError newFromException(int requestId, String message, Throwable e) {
        if (e instanceof JsonRpcErrorException) {
            JsonRpcErrorException jsonRpcError = (JsonRpcErrorException)((Object)e);
            return new ResponseError(jsonRpcError.getCode(), jsonRpcError.getMessage(), jsonRpcError.getData());
        }
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String exceptionMessage = "";
        if (message != null) {
            exceptionMessage = exceptionMessage + message;
        }
        exceptionMessage = exceptionMessage + e.getClass().getName() + ":" + e.getMessage();
        return new ResponseError(requestId, exceptionMessage, writer.toString());
    }

    public ResponseError() {
    }

    public ResponseError(int code, String message, String data) {
        this.code = code;
        this.message = message;
        if (data != null) {
            this.data = new JsonPrimitive(data);
        }
    }

    public ResponseError(int code, String message, JsonElement data) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.type = ResponseError.getErrorType(data);
    }

    public ResponseError(int code, String type, String message, String data) {
        this.code = code;
        this.message = message;
        if (data != null) {
            this.data = new JsonPrimitive(data);
        }
        this.type = type;
    }

    public ResponseError(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code != null ? this.code : 0;
    }

    void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String getData() {
        if (this.data instanceof JsonPrimitive) {
            return ((JsonPrimitive)this.data).getAsString();
        }
        if (this.data != null) {
            return this.data.toString();
        }
        return null;
    }

    void setData(String data) {
        this.data = new JsonPrimitive(data);
    }

    public String getType() {
        return this.type;
    }

    public String getCompleteMessage() {
        return this.message + " (Code:" + this.code + ", Type:" + this.type + ", Data: " + this.data + ")";
    }

    private static String getErrorType(JsonElement data) {
        JsonObject dataObject;
        JsonElement typeProp;
        if (data != null && data instanceof JsonObject && (typeProp = (dataObject = (JsonObject)data).get(TYPE_PROPERTY)) instanceof JsonPrimitive) {
            return ((JsonPrimitive)typeProp).getAsString();
        }
        return null;
    }
}

