/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.kurento.commons.exception.KurentoException;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.RepositoryItemAttributes;
import org.kurento.repository.internal.RepositoryHttpEndpointImpl;
import org.kurento.repository.internal.http.RepositoryHttpManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@WebServlet(value={"/repository_servlet/*"}, loadOnStartup=1)
public class RepositoryHttpServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(RepositoryHttpServlet.class);
    private static final long serialVersionUID = 1L;
    protected static final List<Range> FULL = new ArrayList<Range>();
    protected static final String MIME_SEPARATION = "KURENTO_MIME_BOUNDARY";
    protected static final int FILE_BUFFER_SIZE = 4096;
    private static final int INPUT_BUFFER_SIZE = 2048;
    private static final int OUTPUT_BUFFER_SIZE = 2048;
    protected int debug;
    @Autowired
    protected transient RepositoryHttpManager repoHttpManager;
    @Autowired
    private RepositoryApiConfiguration config;

    public void destroy() {
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.configureServletMapping(servletConfig);
        this.configureWebappPublicUrl(servletConfig);
        if (servletConfig.getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(this.getServletConfig().getInitParameter("debug"));
        }
    }

    private String configureWebappPublicUrl(ServletConfig servletConfig) {
        String webappUrl = this.config.getWebappPublicUrl();
        if (webappUrl == null || webappUrl.trim().isEmpty()) {
            webappUrl = servletConfig.getServletContext().getContextPath();
        } else if (webappUrl.endsWith("/")) {
            webappUrl = webappUrl.substring(0, webappUrl.length() - 1);
        }
        this.repoHttpManager.setWebappPublicUrl(webappUrl);
        return webappUrl;
    }

    private String configureServletMapping(ServletConfig servletConfig) {
        Collection mappings = servletConfig.getServletContext().getServletRegistration(servletConfig.getServletName()).getMappings();
        if (mappings.isEmpty()) {
            throw new KurentoException("There is no mapping for servlet " + RepositoryHttpServlet.class.getName());
        }
        String mapping = (String)mappings.iterator().next();
        mapping = mapping.substring(0, mapping.length() - 1);
        this.repoHttpManager.setServletPath(mapping);
        return mapping;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.logRequest(req);
        super.service(req, resp);
        this.logResponse(resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET, HEAD, POST, PUT, OPTIONS");
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPut(request, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.uploadContent(req, resp);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadContent(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String sessionId = this.extractSessionId(req);
        RepositoryHttpEndpointImpl elem = this.repoHttpManager.getHttpRepoItemElem(sessionId);
        if (elem == null) {
            resp.setStatus(404);
            return;
        }
        elem.stopCurrentTimer();
        elem.fireStartedEventIfFirstTime();
        try (ServletInputStream requestInputStream = req.getInputStream();){
            OutputStream repoItemOutputStream = elem.getRepoItemOutputStream();
            Range range = this.parseContentRange(req, resp);
            if (range != null) {
                if (range.start > elem.getWrittenBytes()) {
                    resp.setStatus(501);
                    resp.getOutputStream().println("The server doesn't support writing ranges ahead of previously written bytes");
                } else if (range.end == elem.getWrittenBytes()) {
                    resp.setStatus(200);
                    resp.getOutputStream().println("The server has detected that the submited range has already submited in a previous request");
                } else if (range.start < elem.getWrittenBytes() && range.end > elem.getWrittenBytes()) {
                    Range copyRange = new Range();
                    copyRange.start = elem.getWrittenBytes() - range.start;
                    copyRange.end = range.end - range.start;
                    this.copyStreamsRange((InputStream)requestInputStream, repoItemOutputStream, copyRange);
                    resp.setStatus(200);
                } else if (range.start == elem.getWrittenBytes()) {
                    IOUtils.copy((InputStream)requestInputStream, (OutputStream)repoItemOutputStream);
                    resp.setStatus(200);
                }
            } else {
                boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
                if (isMultipart) {
                    this.uploadMultipart(req, resp, repoItemOutputStream);
                } else {
                    try {
                        log.debug("Start to receive bytes (estimated " + req.getContentLength() + " bytes)");
                        int bytes = IOUtils.copy((InputStream)requestInputStream, (OutputStream)repoItemOutputStream);
                        resp.setStatus(200);
                        log.debug("Bytes received: " + bytes);
                    }
                    catch (Exception e) {
                        log.warn("Exception when uploading content", (Throwable)e);
                        elem.fireSessionErrorEvent(e);
                        resp.setStatus(500);
                    }
                }
            }
        }
        finally {
            elem.stopInTimeout();
        }
    }

    private void uploadMultipart(HttpServletRequest req, HttpServletResponse resp, OutputStream repoItemOutputStrem) throws IOException {
        log.debug("Multipart detected");
        ServletFileUpload upload = new ServletFileUpload();
        try {
            FileItemIterator iter = upload.getItemIterator(req);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                InputStream stream = item.openStream();
                Throwable throwable = null;
                try {
                    if (item.isFormField()) {
                        log.debug("Form field {} with value {} detected.", (Object)name, (Object)Streams.asString((InputStream)stream));
                        continue;
                    }
                    log.debug("File field {} with file name detected.", (Object)name, (Object)item.getName());
                    log.debug("Start to receive bytes (estimated bytes)", (Object)Integer.toString(req.getContentLength()));
                    int bytes = IOUtils.copy((InputStream)stream, (OutputStream)repoItemOutputStrem);
                    resp.setStatus(200);
                    log.debug("Bytes received: {}", (Object)Integer.toString(bytes));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
    }

    private void logRequest(HttpServletRequest req) {
        log.debug("Request received " + req.getRequestURL());
        log.debug("  Method: " + req.getMethod());
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration values = req.getHeaders(headerName);
            ArrayList valueList = new ArrayList();
            while (values.hasMoreElements()) {
                valueList.add(values.nextElement());
            }
            log.debug("  Header {}: {}", (Object)headerName, valueList);
        }
    }

    private void logResponse(HttpServletResponse resp) {
        Collection headerNames = resp.getHeaderNames();
        for (String headerName : headerNames) {
            Collection values = resp.getHeaders(headerName);
            log.debug("  Header {}: {}", (Object)headerName, (Object)values);
        }
    }

    protected String extractSessionId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.length() >= 1) {
            return pathInfo.substring(1);
        }
        return null;
    }

    protected File executePartialPut(HttpServletRequest req, Range range, String sessionId) throws IOException {
        String convertedResourcePath;
        File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        File contentFile = new File(tempDir, convertedResourcePath = sessionId.replace('/', '.'));
        if (contentFile.createNewFile()) {
            contentFile.deleteOnExit();
        }
        try (RandomAccessFile randAccessContentFile = new RandomAccessFile(contentFile, "rw");){
            RepositoryHttpEndpointImpl repoItemHttpElem = this.repoHttpManager.getHttpRepoItemElem(sessionId);
            if (repoItemHttpElem != null) {
                try (BufferedInputStream bufOldRevStream = new BufferedInputStream(repoItemHttpElem.createRepoItemInputStream(), 4096);){
                    int numBytesRead;
                    byte[] copyBuffer = new byte[4096];
                    while ((numBytesRead = bufOldRevStream.read(copyBuffer)) != -1) {
                        randAccessContentFile.write(copyBuffer, 0, numBytesRead);
                    }
                }
            }
            randAccessContentFile.setLength(range.length);
            randAccessContentFile.seek(range.start);
            byte[] transferBuffer = new byte[4096];
            try (BufferedInputStream requestBufInStream = new BufferedInputStream((InputStream)req.getInputStream(), 4096);){
                int numBytesRead;
                while ((numBytesRead = requestBufInStream.read(transferBuffer)) != -1) {
                    randAccessContentFile.write(transferBuffer, 0, numBytesRead);
                }
            }
        }
        return contentFile;
    }

    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, RepositoryItemAttributes resourceAttributes) throws IOException {
        return this.checkIfMatch(request, response, resourceAttributes) && this.checkIfModifiedSince(request, response, resourceAttributes) && this.checkIfNoneMatch(request, response, resourceAttributes) && this.checkIfUnmodifiedSince(request, response, resourceAttributes);
    }

    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        boolean noRanges;
        boolean contentWritten;
        long contentLength;
        boolean malformedRequest;
        boolean serveContent = content;
        String sessionId = this.extractSessionId(request);
        RepositoryHttpEndpointImpl elem = this.repoHttpManager.getHttpRepoItemElem(sessionId);
        if (elem == null) {
            if (this.debug > 0) {
                this.log("Resource with sessionId '" + sessionId + "' not found");
            }
            response.sendError(404, request.getRequestURI());
            return;
        }
        elem.fireStartedEventIfFirstTime();
        RepositoryItem repositoryItem = elem.getRepositoryItem();
        RepositoryItemAttributes attributes = repositoryItem.getAttributes();
        if (this.debug > 0) {
            if (serveContent) {
                this.log("Serving resource with sessionId '" + sessionId + "' headers and data. This resource corresponds to repository item '" + repositoryItem.getId() + "'");
            } else {
                this.log("Serving resource with sessionId '" + sessionId + "' headers only. This resource corresponds to repository item '" + repositoryItem.getId() + "'");
            }
        }
        boolean bl = malformedRequest = response.getStatus() >= 400;
        if (!malformedRequest && !this.checkIfHeaders(request, response, attributes)) {
            return;
        }
        String contentType = this.getContentType(elem, attributes);
        List<Range> ranges = null;
        if (!malformedRequest) {
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", attributes.getETag());
            response.setHeader("Last-Modified", attributes.getLastModifiedHttp());
            ranges = this.parseRange(request, response, attributes);
        }
        if ((contentLength = attributes.getContentLength()) == 0L) {
            serveContent = false;
        }
        if (contentWritten = response.isCommitted()) {
            ranges = FULL;
        }
        boolean bl2 = noRanges = ranges == null || ranges.isEmpty();
        if (malformedRequest || noRanges && request.getHeader("Range") == null || ranges == FULL) {
            this.setContentType(response, contentType);
            if (contentLength >= 0L && !contentWritten) {
                this.setContentLength(response, contentLength);
            }
            if (serveContent) {
                this.copy(elem, response);
            }
        } else {
            if (noRanges) {
                return;
            }
            response.setStatus(206);
            if (ranges.size() == 1) {
                Range range = ranges.get(0);
                response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                long length = range.end - range.start + 1L;
                this.setContentLength(response, length);
                this.setContentType(response, contentType);
                if (serveContent) {
                    this.copy(elem, response, range);
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=KURENTO_MIME_BOUNDARY");
                if (serveContent) {
                    this.copy(elem, response, ranges, contentType);
                }
            }
        }
        elem.stopInTimeout();
    }

    private String getContentType(RepositoryHttpEndpointImpl repoItemHttpElem, RepositoryItemAttributes attributes) {
        String contentType = attributes.getMimeType();
        if (contentType == null) {
            contentType = this.getServletContext().getMimeType(repoItemHttpElem.getRepositoryItem().getId());
            attributes.setMimeType(contentType);
        }
        return contentType;
    }

    private void setContentType(HttpServletResponse response, String contentType) {
        if (contentType != null) {
            if (this.debug > 0) {
                this.log("contentType='" + contentType + "'");
            }
            response.setContentType(contentType);
        }
    }

    private void setContentLength(HttpServletResponse response, long length) {
        if (this.debug > 0) {
            this.log("contentLength=" + length);
        }
        if (length < Integer.MAX_VALUE) {
            response.setContentLength((int)length);
        } else {
            response.setHeader("content-length", "" + length);
        }
    }

    protected Range parseContentRange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String rangeHeader = request.getHeader("Content-Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.sendError(400);
            return null;
        }
        rangeHeader = rangeHeader.substring(6).trim();
        int dashPos = rangeHeader.indexOf(45);
        int slashPos = rangeHeader.indexOf(47);
        if (dashPos == -1) {
            response.sendError(400);
            return null;
        }
        if (slashPos == -1) {
            response.sendError(400);
            return null;
        }
        Range range = new Range();
        try {
            range.start = Long.parseLong(rangeHeader.substring(0, dashPos));
            range.end = Long.parseLong(rangeHeader.substring(dashPos + 1, slashPos));
            String lengthString = rangeHeader.substring(slashPos + 1, rangeHeader.length());
            range.length = lengthString.equals("*") ? -1L : Long.parseLong(lengthString);
        }
        catch (NumberFormatException e) {
            response.sendError(400);
            return null;
        }
        if (!range.validate()) {
            response.sendError(400);
            return null;
        }
        return range;
    }

    protected List<Range> parseRange(HttpServletRequest request, HttpServletResponse response, RepositoryItemAttributes resourceAttributes) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String eTag = resourceAttributes.getETag();
            long lastModified = resourceAttributes.getLastModified();
            if (headerValueTime == -1L ? !eTag.equals(headerValue.trim()) : lastModified > headerValueTime + 1000L) {
                return FULL;
            }
        }
        if ((fileLength = resourceAttributes.getContentLength()) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    protected boolean checkIfMatch(HttpServletRequest request, HttpServletResponse response, RepositoryItemAttributes resourceAttributes) throws IOException {
        String eTag = resourceAttributes.getETag();
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, RepositoryItemAttributes resourceAttributes) {
        try {
            long headerValue = request.getDateHeader("If-Modified-Since");
            long lastModified = resourceAttributes.getLastModified();
            if (headerValue != -1L && request.getHeader("If-None-Match") == null && lastModified < headerValue + 1000L) {
                response.setStatus(304);
                response.setHeader("ETag", resourceAttributes.getETag());
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    protected boolean checkIfNoneMatch(HttpServletRequest request, HttpServletResponse response, RepositoryItemAttributes resourceAttributes) throws IOException {
        String eTag = resourceAttributes.getETag();
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                    response.setStatus(304);
                    response.setHeader("ETag", eTag);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(HttpServletRequest request, HttpServletResponse response, RepositoryItemAttributes resourceAttributes) throws IOException {
        try {
            long lastModified = resourceAttributes.getLastModified();
            long headerValue = request.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && lastModified >= headerValue + 1000L) {
                response.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    protected void copy(RepositoryHttpEndpointImpl repoItemHttpElem, HttpServletResponse response) throws IOException {
        this.copy(repoItemHttpElem, response, null);
    }

    protected void copy(RepositoryHttpEndpointImpl repoItemHttpElem, HttpServletResponse response, Range range) throws IOException {
        IOException exception;
        try {
            response.setBufferSize(2048);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try (ServletOutputStream ostream = response.getOutputStream();
             BufferedInputStream istream = new BufferedInputStream(repoItemHttpElem.createRepoItemInputStream(), 2048);){
            exception = range != null ? this.copyStreamsRange(istream, (OutputStream)ostream, range) : this.copyStreams(istream, (OutputStream)ostream);
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(RepositoryHttpEndpointImpl repoItemHttpElem, HttpServletResponse response, List<Range> ranges, String contentType) throws IOException {
        try {
            response.setBufferSize(2048);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        IOException exception = null;
        try (ServletOutputStream ostream = response.getOutputStream();){
            for (Range currentRange : ranges) {
                BufferedInputStream istream = new BufferedInputStream(repoItemHttpElem.createRepoItemInputStream(), 2048);
                Throwable throwable = null;
                try {
                    ostream.println();
                    ostream.println("--KURENTO_MIME_BOUNDARY");
                    if (contentType != null) {
                        ostream.println("Content-Type: " + contentType);
                    }
                    ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
                    ostream.println();
                    exception = this.copyStreamsRange(istream, (OutputStream)ostream, currentRange);
                    if (exception == null) continue;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (istream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)istream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)istream).close();
                }
            }
            ostream.println();
            ostream.print("--KURENTO_MIME_BOUNDARY--");
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected IOException copyStreams(InputStream istream, OutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[2048];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
                log.debug("{} bytes have been written to item", (Object)len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    protected IOException copyStreamsRange(InputStream istream, OutputStream ostream, Range range) {
        long start = range.start;
        long end = range.end;
        if (this.debug > 10) {
            this.log("Serving bytes:" + start + "-" + end);
        }
        long skipped = 0L;
        try {
            skipped = istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        if (skipped < start) {
            return new IOException("Has been skiped " + skipped + " when " + start + " is required");
        }
        IOException exception = null;
        byte[] buffer = new byte[2048];
        int readBytes = buffer.length;
        for (long remBytes = end - start + 1L; remBytes > 0L; remBytes -= (long)readBytes) {
            try {
                readBytes = istream.read(buffer);
                if (readBytes == -1) break;
                if ((long)readBytes <= remBytes) {
                    ostream.write(buffer, 0, readBytes);
                    continue;
                }
                ostream.write(buffer, 0, (int)remBytes);
            }
            catch (IOException e) {
                exception = e;
            }
            break;
        }
        return exception;
    }

    protected static class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public static Range createWithEnd(long start, long end) {
            Range range = new Range();
            range.start = start;
            range.end = end;
            range.length = end - start;
            return range;
        }

        public static Range createWithLength(long start, long length) {
            Range range = new Range();
            range.start = start;
            range.length = length;
            range.end = start + length;
            return range;
        }

        public static Range create(long length) {
            Range range = new Range();
            range.start = 0L;
            range.length = length;
            range.end = length;
            return range;
        }

        public boolean validate() {
            if (this.length != -1L && this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && (this.length == -1L || this.length > 0L);
        }
    }
}

