/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.repoimpl.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Map;
import org.kurento.commons.exception.KurentoException;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.RepositoryItemAttributes;
import org.kurento.repository.internal.repoimpl.AbstractRepositoryItem;
import org.kurento.repository.internal.repoimpl.filesystem.FileSystemRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRepositoryItem
extends AbstractRepositoryItem {
    private static final Logger log = LoggerFactory.getLogger(FileRepositoryItem.class);
    private final File file;
    private OutputStream storingOutputStream;

    public FileRepositoryItem(FileSystemRepository repository, File file, String id, Map<String, String> metadata) {
        super(id, FileRepositoryItem.calculateState(file), FileRepositoryItem.loadAttributes(file), repository);
        this.file = file;
        this.setMetadata(metadata);
    }

    private static RepositoryItem.State calculateState(File file) {
        return file.exists() && file.length() > 0L ? RepositoryItem.State.STORED : RepositoryItem.State.NEW;
    }

    private static RepositoryItemAttributes loadAttributes(File file) {
        RepositoryItemAttributes attributes = new RepositoryItemAttributes();
        if (file.exists()) {
            attributes.setContentLength(file.length());
            attributes.setLastModified(file.lastModified());
            String mimeType = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                mimeType = URLConnection.guessContentTypeFromStream(is);
            }
            catch (Exception e) {
                log.warn("Exception produced during load of attributes", (Throwable)e);
            }
            attributes.setMimeType(mimeType);
        }
        return attributes;
    }

    @Override
    public InputStream createInputStreamToRead() {
        this.checkState(RepositoryItem.State.STORED);
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new KurentoException("The file storing this repositoty item was deleted before creation", (Throwable)e);
        }
    }

    @Override
    public OutputStream createOutputStreamToWrite() {
        this.checkState(RepositoryItem.State.NEW);
        try {
            this.state = RepositoryItem.State.STORING;
            this.storingOutputStream = new FilterOutputStream(new FileOutputStream(this.file)){

                @Override
                public void close() throws IOException {
                    FileRepositoryItem.this.refreshAttributesOnClose();
                }
            };
            return this.storingOutputStream;
        }
        catch (FileNotFoundException e) {
            throw new KurentoException("There is a problem opening the output stream to the file that will store the contents of the repositoty item", (Throwable)e);
        }
    }

    private void refreshAttributesOnClose() {
        this.state = RepositoryItem.State.STORED;
        this.attributes.setContentLength(this.file.length());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        super.setMetadata(metadata);
        ((FileSystemRepository)this.repository).setMetadataForItem(this, metadata);
    }
}

