/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.repoimpl.filesystem;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsMetadata {
    private final Logger log = LoggerFactory.getLogger(ItemsMetadata.class);
    private ConcurrentMap<String, Map<String, String>> itemsMetadata;
    private final File itemsMetadataFile;

    public ItemsMetadata(File itemsMetadataFile) {
        this.itemsMetadataFile = itemsMetadataFile;
        try {
            this.loadItemsMetadata();
        }
        catch (IOException e) {
            this.log.warn("Exception while loading items metadata", (Throwable)e);
        }
    }

    private void loadItemsMetadata() throws IOException {
        this.itemsMetadata = new ConcurrentHashMap<String, Map<String, String>>();
        DBObject contents = (DBObject)JSON.parse((String)this.loadFileAsString());
        if (contents != null) {
            for (String key : contents.keySet()) {
                try {
                    DBObject metadata = (DBObject)contents.get(key);
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String metadataKey : metadata.keySet()) {
                        map.put(metadataKey, metadata.get(metadataKey).toString());
                    }
                    this.itemsMetadata.put(key, map);
                }
                catch (ClassCastException e) {
                    this.log.warn("Attribute '{}' should be an object", (Object)key);
                }
            }
        }
    }

    private String loadFileAsString() throws IOException {
        if (!this.itemsMetadataFile.exists()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try (FileReader metadataFile = new FileReader(this.itemsMetadataFile);
             BufferedReader br = new BufferedReader(metadataFile);){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        return sb.toString();
    }

    public synchronized void setMetadataForId(String id, Map<String, String> metadata) {
        this.itemsMetadata.put(id, metadata);
    }

    public synchronized Map<String, String> loadMetadata(String id) {
        HashMap metadata = (HashMap)this.itemsMetadata.get(id);
        if (metadata == null) {
            metadata = new HashMap();
            this.itemsMetadata.put(id, metadata);
        }
        return metadata;
    }

    public List<Map.Entry<String, Map<String, String>>> findByAttValue(String attributeName, String value) {
        ArrayList<Map.Entry<String, Map<String, String>>> list = new ArrayList<Map.Entry<String, Map<String, String>>>();
        for (Map.Entry item : this.itemsMetadata.entrySet()) {
            String attValue = (String)((Map)item.getValue()).get(attributeName);
            if (attValue == null || !attValue.equals(value)) continue;
            list.add(item);
        }
        return list;
    }

    public List<Map.Entry<String, Map<String, String>>> findByAttRegex(String attributeName, String regex) {
        Pattern pattern = Pattern.compile(regex);
        ArrayList<Map.Entry<String, Map<String, String>>> list = new ArrayList<Map.Entry<String, Map<String, String>>>();
        for (Map.Entry item : this.itemsMetadata.entrySet()) {
            String value = (String)((Map)item.getValue()).get(attributeName);
            if (value == null || !pattern.matcher(value).matches()) continue;
            list.add(item);
        }
        return list;
    }

    public void save() {
        try {
            if (!this.itemsMetadataFile.exists()) {
                this.itemsMetadataFile.getParentFile().mkdirs();
                this.itemsMetadataFile.createNewFile();
            }
            try (PrintWriter writer = new PrintWriter(this.itemsMetadataFile);){
                String content = JSON.serialize(this.itemsMetadata);
                writer.print(content);
            }
        }
        catch (IOException e) {
            this.log.error("Exception writing metadata file", (Throwable)e);
        }
    }
}

