/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.repoimpl.mongo;

import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.PostConstruct;
import org.kurento.repository.DuplicateItemException;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.internal.http.RepositoryHttpManager;
import org.kurento.repository.internal.repoimpl.RepositoryWithHttp;
import org.kurento.repository.internal.repoimpl.mongo.MongoRepositoryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoRepository
implements RepositoryWithHttp {
    private final Logger log = LoggerFactory.getLogger(MongoRepository.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    private GridFS gridFS;
    @Autowired
    private RepositoryHttpManager httpManager;

    @PostConstruct
    private void postConstruct() {
    }

    public GridFS getGridFS() {
        return this.gridFS;
    }

    @Override
    public RepositoryItem findRepositoryItemById(String id) {
        List dbFiles = this.gridFS.find(id);
        if (dbFiles.size() > 0) {
            if (dbFiles.size() > 1) {
                this.log.warn("There are several files with the same filename and should be only one");
            }
            return this.createRepositoryItem((GridFSDBFile)dbFiles.get(0));
        }
        throw new NoSuchElementException("The repository item with id \"" + id + "\" does not exist");
    }

    private RepositoryItem createRepositoryItem(GridFSInputFile dbFile) {
        return new MongoRepositoryItem(this, dbFile);
    }

    private MongoRepositoryItem createRepositoryItem(GridFSDBFile dbFile) {
        MongoRepositoryItem item = new MongoRepositoryItem(this, dbFile);
        HashMap<String, String> metadata = new HashMap<String, String>();
        DBObject object = dbFile.getMetaData();
        for (String key : object.keySet()) {
            metadata.put(key, object.get(key).toString());
        }
        item.setMetadata(metadata);
        return item;
    }

    @Override
    public RepositoryItem createRepositoryItem() {
        GridFSInputFile dbFile = this.gridFS.createFile();
        dbFile.setFilename(dbFile.getId().toString());
        return this.createRepositoryItem(dbFile);
    }

    @Override
    public RepositoryItem createRepositoryItem(String id) {
        if (!this.gridFS.find(id).isEmpty()) {
            throw new DuplicateItemException(id);
        }
        GridFSInputFile dbFile = this.gridFS.createFile(id);
        dbFile.setId((Object)id);
        return this.createRepositoryItem(dbFile);
    }

    @Override
    public RepositoryHttpManager getRepositoryHttpManager() {
        return this.httpManager;
    }

    @Override
    public void remove(RepositoryItem item) {
        this.httpManager.disposeHttpRepoItemElemByItemId(item, "Repository Item removed");
        this.gridFS.remove(item.getId());
    }

    @Override
    public List<RepositoryItem> findRepositoryItemsByAttValue(String attributeName, String value) {
        String query = "{'metadata." + attributeName + "':'" + value + "'}";
        return this.findRepositoryItemsByQuery(query);
    }

    @Override
    public List<RepositoryItem> findRepositoryItemsByAttRegex(String attributeName, String regex) {
        String query = "{'metadata." + attributeName + "': { $regex : '" + regex + "'}}";
        return this.findRepositoryItemsByQuery(query);
    }

    private List<RepositoryItem> findRepositoryItemsByQuery(String query) {
        List files = this.gridFS.find((DBObject)JSON.parse((String)query));
        ArrayList<RepositoryItem> repositoryItems = new ArrayList<RepositoryItem>();
        for (GridFSDBFile file : files) {
            repositoryItems.add(this.createRepositoryItem(file));
        }
        return repositoryItems;
    }
}

