/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kurento.commons.ConfigFileManager;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.config.Protocol;
import org.kurento.test.config.Retry;
import org.kurento.test.config.TestReport;
import org.kurento.test.config.TestScenario;
import org.kurento.test.lifecycle.FailedTest;
import org.kurento.test.lifecycle.FinishedTest;
import org.kurento.test.lifecycle.KurentoBlockJUnit4ClassRunnerWithParametersFactory;
import org.kurento.test.lifecycle.KurentoTestRunner;
import org.kurento.test.lifecycle.KurentoTestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=KurentoTestRunner.class)
@Parameterized.UseParametersRunnerFactory(value=KurentoBlockJUnit4ClassRunnerWithParametersFactory.class)
public class KurentoTest {
    @Rule
    public Retry retry = new Retry(numRetries);
    @Rule
    public KurentoTestWatcher watcher = new KurentoTestWatcher();
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter
    public TestScenario testScenario;
    protected static int numRetries = PropertiesManager.getProperty((String)"test.num.retries", (int)1);
    protected static String testDir = PropertiesManager.getProperty((String)"test.project.path", (String)"target/surefire-reports/");
    protected static boolean printLogs = PropertiesManager.getProperty((String)"test.print.log", (boolean)true);
    public static Logger log = LoggerFactory.getLogger(KurentoTest.class);
    protected static String testIdentifier;
    protected static String testMethodName;
    protected static String testClassName;
    protected static List<File> logFiles;
    protected static boolean deleteLogsIfSuccess;
    public static final String SEPARATOR;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return TestScenario.empty();
    }

    public KurentoTest() {
        testClassName = this.getClass().getName();
        testIdentifier = this.getClass().getSimpleName() + " [" + new Date() + "]";
        this.retry.useReport(testIdentifier);
        deleteLogsIfSuccess = true;
    }

    @FailedTest
    public static void printKmsLogs() {
        if (printLogs && logFiles != null) {
            for (File logFile : logFiles) {
                if (logFile == null || !logFile.exists()) continue;
                System.err.println(SEPARATOR);
                System.err.println("Log file: " + logFile.getAbsolutePath());
                try {
                    for (String line : FileUtils.readLines((File)logFile)) {
                        System.err.println(line);
                    }
                }
                catch (Throwable e) {
                    log.warn("Error reading log file {}: {} {}", new Object[]{logFile, e.getClass(), e.getMessage()});
                }
                System.err.println(SEPARATOR);
            }
        }
    }

    @FinishedTest
    public static void deleteLogs() {
        File folder;
        File[] files;
        if (KurentoTestWatcher.isSuccees() && deleteLogsIfSuccess && (files = (folder = KurentoTest.getDefaultOutputFolder()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(KurentoTest.getSimpleTestName());
            }
        })) != null) {
            for (File file : files) {
                try {
                    if (file.isDirectory()) {
                        FileUtils.deleteDirectory((File)file);
                    } else {
                        file.delete();
                    }
                    if (!file.exists()) continue;
                    log.error("Can't remove {}", (Object)file.getAbsolutePath());
                }
                catch (Throwable e) {
                    log.warn("Exception deleting file {}: {} {}", new Object[]{file, e.getClass(), e.getMessage()});
                }
            }
        }
    }

    @Before
    public void logStart() {
        log.info("##### Start test: " + this.getClass().getSimpleName() + " -> " + this.name.getMethodName());
    }

    @After
    public void logEnd() {
        log.info("##### Finish test: " + this.getClass().getSimpleName() + " -> " + this.name.getMethodName());
    }

    public TestReport getTestReport() {
        return this.retry.getTestReport();
    }

    public static File getDefaultOutputFolder() {
        File testResultsFolder = new File(testDir + File.separator + testClassName);
        if (!testResultsFolder.exists()) {
            testResultsFolder.mkdirs();
        }
        return testResultsFolder;
    }

    public static String getDefaultOutputFile(String suffix) {
        return KurentoTest.getDefaultOutputFolder().getAbsolutePath() + File.separator + KurentoTest.getSimpleTestName() + suffix;
    }

    public static String getDefaultOutputTestPath() {
        return KurentoTest.getDefaultOutputFolder().getAbsolutePath() + File.separator + KurentoTest.getSimpleTestName() + File.separator;
    }

    public static String getRecordDefaultPath() {
        return PropertiesManager.getProperty((String)"test.record.defaultpath");
    }

    public static String getRecordUrl(String suffix) {
        String recordUrl = PropertiesManager.getProperty((String)"test.record.url");
        if (recordUrl == null) {
            return (Object)((Object)Protocol.FILE) + "://" + KurentoTest.getDefaultOutputFile(suffix);
        }
        return recordUrl + File.separator + KurentoTest.getSimpleTestName() + suffix;
    }

    public static String getPlayerUrl(String mediaName) {
        String playerUrl = PropertiesManager.getProperty((String)"test.files.url");
        if (playerUrl == null) {
            return (Object)((Object)Protocol.HTTP) + "://" + KurentoTest.getTestFilesHttpPath() + mediaName;
        }
        return playerUrl + mediaName;
    }

    public static String getSimpleTestName() {
        String out = testMethodName;
        if (testMethodName != null && out.indexOf(":") != -1) {
            out = out.substring(0, out.indexOf(":")) + "]";
        }
        return out;
    }

    public static String getTestMethodName() {
        return testMethodName;
    }

    public static void setTestMethodName(String testMethodName) {
        KurentoTest.testMethodName = testMethodName;
    }

    public static String getTestClassName() {
        return testClassName;
    }

    public static void setTestClassName(String testClassName) {
        KurentoTest.testClassName = testClassName;
    }

    public static String getTestDir() {
        return testDir;
    }

    public static void setTestDir(String testDir) {
        KurentoTest.testDir = testDir;
    }

    public static String getTestIdentifier() {
        return testIdentifier;
    }

    public static void setTestIdentifier(String testIdentifier) {
        KurentoTest.testIdentifier = testIdentifier;
    }

    public static boolean isDeleteLogsIfSuccess() {
        return deleteLogsIfSuccess;
    }

    public static void setDeleteLogsIfSuccess(boolean deleteLogsIfSuccess) {
        KurentoTest.deleteLogsIfSuccess = deleteLogsIfSuccess;
    }

    public static void addLogFile(File logFile) {
        log.debug("Adding log file: {}", (Object)logFile);
        if (logFiles == null) {
            logFiles = new ArrayList<File>();
        }
        logFiles.add(logFile);
    }

    public static List<File> getServerLogFiles() {
        int countFiles = logFiles != null ? logFiles.size() : 0;
        log.debug("Logs files {}", (Object)countFiles);
        return logFiles;
    }

    public static String getTestFilesDiskPath() {
        String testFilesDisk = PropertiesManager.getProperty((String)"test.files.disk");
        if (testFilesDisk == null) {
            testFilesDisk = PropertiesManager.getProperty((String)"test.files", (String)"/var/lib/jenkins/test-files");
        }
        return testFilesDisk;
    }

    public static String getTestFilesS3Path() {
        String testFilesS3 = PropertiesManager.getProperty((String)"test.files.s3");
        if (testFilesS3 == null) {
            testFilesS3 = PropertiesManager.getProperty((String)"test.s3", (String)"kurento-s3-test");
        }
        return testFilesS3;
    }

    public static String getTestFilesHttpPath() {
        return PropertiesManager.getProperty((String)"test.files.http", (String)"files.openvidu.io");
    }

    public static String getTestFilesMongoPath() {
        return PropertiesManager.getProperty((String)"test.files.mongodb", (String)"files.openvidu.io:27017");
    }

    public static void logMessage(String message) {
        log.debug(SEPARATOR);
        log.debug(message);
        log.debug(SEPARATOR);
    }

    public static int getTestSeekRepetitions() {
        return PropertiesManager.getProperty((String)"test.seek.repetitions", (int)20);
    }

    public static String getTestStunServerUrl() {
        return "stun:" + PropertiesManager.getProperty((String)"kms.stun.ip") + ":" + PropertiesManager.getProperty((String)"kms.stun.port");
    }

    public static String getTestIceServerUrl() {
        return PropertiesManager.getProperty((String)"test.ice.server.url");
    }

    public static String getTestIceServerUsername() {
        return PropertiesManager.getProperty((String)"test.ice.server.username");
    }

    public static String getTestIceServerCredential() {
        return PropertiesManager.getProperty((String)"test.ice.server.credential");
    }

    static {
        SEPARATOR = "+" + StringUtils.repeat((String)"-", (int)70);
        ConfigFileManager.loadConfigFile((String)"test.conf.json");
    }
}

