/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkField;
import org.kurento.test.lifecycle.KurentoRunNotifier;
import org.kurento.test.lifecycle.KurentoTestListener;
import org.kurento.test.services.Service;

public class KurentoTestRunner
extends Parameterized {
    private static boolean shutdownHook = false;
    private static KurentoTestListener listener;

    public KurentoTestRunner(Class<?> clazz) throws Throwable {
        super(clazz);
    }

    public void run(RunNotifier notifier) {
        if (listener != null) {
            notifier.removeListener((RunListener)listener);
        }
        List services = this.getTestClass().getAnnotatedFields(Service.class);
        ArrayList<FrameworkField> sortedServices = new ArrayList<FrameworkField>(services);
        Collections.sort(sortedServices, new Comparator<FrameworkField>(){

            @Override
            public int compare(FrameworkField o1, FrameworkField o2) {
                return Integer.compare(((Service)o1.getAnnotation(Service.class)).value(), ((Service)o2.getAnnotation(Service.class)).value());
            }
        });
        listener = new KurentoTestListener(sortedServices);
        notifier.addListener((RunListener)listener);
        listener.testRunStarted(this.getDescription());
        if (!shutdownHook) {
            shutdownHook = true;
            Runtime.getRuntime().addShutdownHook(new Thread("app-shutdown-hook"){

                @Override
                public void run() {
                    listener.testSuiteFinished();
                }
            });
        }
        notifier = new KurentoRunNotifier(notifier);
        super.run(notifier);
    }
}

