/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kurento.client.Stats;
import org.kurento.test.monitor.MonitorStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRtcEndpointStats
extends MonitorStats {
    private static final Logger log = LoggerFactory.getLogger(WebRtcEndpointStats.class);
    private Map<String, Stats> stats;

    public WebRtcEndpointStats(Map<String, Stats> stats) {
        this.stats = stats;
    }

    public Map<String, Stats> getStats() {
        return this.stats;
    }

    public List<String> calculateHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (Map.Entry<String, Stats> statEntry : this.stats.entrySet()) {
            for (Method method : statEntry.getValue().getClass().getMethods()) {
                if (!this.isGetter(method)) continue;
                headers.add(statEntry.getKey() + "_" + this.getGetterName(method));
            }
        }
        return headers;
    }

    public List<Object> calculateValues(List<String> headers) {
        HashMap<String, Object> rtcServerStatsValues = new HashMap<String, Object>();
        for (Map.Entry<String, Stats> statEntry : this.stats.entrySet()) {
            for (Method method : statEntry.getValue().getClass().getMethods()) {
                if (!this.isGetter(method)) continue;
                Object value = null;
                try {
                    value = method.invoke((Object)statEntry.getValue(), new Object[0]);
                }
                catch (Exception e) {
                    log.error("Exception invoking method", (Throwable)e);
                }
                String keyList = statEntry.getKey() + "_" + this.getGetterName(method);
                rtcServerStatsValues.put(keyList, value);
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (String header : headers) {
            values.add(rtcServerStatsValues.get(header));
        }
        return values;
    }
}

