/**
 * This file is generated with Kurento-maven-plugin.
 * Please don't edit.
 */
package org.kurento.module.platedetector;

import org.kurento.client.*;

/**
 *
 * PlateDetectorFilter interface. This type of {@link module:core/abstracts.Endpoint Endpoint} detects
 * vehicle plates in a video feed.
 *
 **/
@org.kurento.client.internal.RemoteClass
public interface PlateDetectorFilter extends Filter {



/**
 *
 * Configures the average width of the license plates in the image represented as an image percentage.
 *
 * @param plateWidthPercentage
 *       average width of the license plates represented as an image percentage [0..1].
 *
 **/
  void setPlateWidthPercentage(@org.kurento.client.internal.server.Param("plateWidthPercentage") float plateWidthPercentage);

/**
 *
 * Asynchronous version of setPlateWidthPercentage:
 * {@link Continuation#onSuccess} is called when the action is
 * done. If an error occurs, {@link Continuation#onError} is called.
 * @see PlateDetectorFilter#setPlateWidthPercentage
 *
 * @param plateWidthPercentage
 *       average width of the license plates represented as an image percentage [0..1].
 *
 **/
    void setPlateWidthPercentage(@org.kurento.client.internal.server.Param("plateWidthPercentage") float plateWidthPercentage, Continuation<Void> cont);

/**
 *
 * Configures the average width of the license plates in the image represented as an image percentage.
 *
 * @param plateWidthPercentage
 *       average width of the license plates represented as an image percentage [0..1].
 *
 **/
    void setPlateWidthPercentage(Transaction tx, @org.kurento.client.internal.server.Param("plateWidthPercentage") float plateWidthPercentage);

    /**
     * Add a {@link EventListener} for event {@link PlateDetectedEvent}. Synchronous call.
     *
     * @param  listener Listener to be called on PlateDetectedEvent
     * @return ListenerSubscription for the given Listener
     *
     **/
    @org.kurento.client.internal.server.EventSubscription(PlateDetectedEvent.class)
    ListenerSubscription addPlateDetectedListener(EventListener<PlateDetectedEvent> listener);
    /**
     * Add a {@link EventListener} for event {@link PlateDetectedEvent}. Asynchronous call.
     * Calls Continuation&lt;ListenerSubscription&gt; when it has been added.
     *
     * @param listener Listener to be called on PlateDetectedEvent
     * @param cont     Continuation to be called when the listener is registered
     *
     **/
    @org.kurento.client.internal.server.EventSubscription(PlateDetectedEvent.class)
    void addPlateDetectedListener(EventListener<PlateDetectedEvent> listener, Continuation<ListenerSubscription> cont);
    
	/**
     * Remove a {@link ListenerSubscription} for event {@link PlateDetectedEvent}. Synchronous call.
     *
     * @param listenerSubscription Listener subscription to be removed
     *
     **/
    @org.kurento.client.internal.server.EventSubscription(PlateDetectedEvent.class)
    void removePlateDetectedListener(ListenerSubscription listenerSubscription);
    /**
     * Remove a {@link ListenerSubscription} for event {@link PlateDetectedEvent}. Asynchronous call.
     * Calls Continuation&lt;Void&gt; when it has been removed.
     *
     * @param listenerSubscription Listener subscription to be removed
     * @param cont                 Continuation to be called when the listener is removed
     *
     **/
    @org.kurento.client.internal.server.EventSubscription(PlateDetectedEvent.class)
    void removePlateDetectedListener(ListenerSubscription listenerSubscription, Continuation<Void> cont);
    



    public class Builder extends AbstractBuilder<PlateDetectorFilter> {

/**
 *
 * Creates a Builder for PlateDetectorFilter
 *
 **/
    public Builder(org.kurento.client.MediaPipeline mediaPipeline){

      super(PlateDetectorFilter.class,mediaPipeline);

      props.add("mediaPipeline",mediaPipeline);
    }

	public Builder withProperties(Properties properties) {
    	return (Builder)super.withProperties(properties);
  	}

	public Builder with(String name, Object value) {
		return (Builder)super.with(name, value);
	}
	
    }


}