/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.common;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Consumer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.l2x6.pom.tuner.model.GavSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BannedDependencyResource {
    private String location;
    private String xsltLocation;
    private GavSet bannedSet;

    public BannedDependencyResource() {
    }

    public BannedDependencyResource(String path, String xsltLocation) {
        this.location = path;
        this.xsltLocation = xsltLocation;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String path) {
        this.location = path;
    }

    public String getXsltLocation() {
        return this.xsltLocation;
    }

    public void setXsltLocation(String xsltLocation) {
        this.xsltLocation = xsltLocation;
    }

    public GavSet getBannedSet(Charset charset) {
        if (this.bannedSet == null) {
            Document document;
            DOMResult result;
            if (this.location == null || this.location.isBlank()) {
                throw new IllegalStateException("path must be specified for " + this);
            }
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                result = new DOMResult();
                try (Reader r = BannedDependencyResource.openReader(this.location, charset);){
                    transformer.transform(new StreamSource(r), result);
                    document = (Document)result.getNode();
                    if (this.xsltLocation != null && !this.xsltLocation.isBlank()) {
                        document = BannedDependencyResource.transform(this.location, document, this.xsltLocation, charset);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read " + this.location, e);
                }
                catch (TransformerException e) {
                    throw new RuntimeException("Could not parse " + this.location, e);
                }
            }
            catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
                throw new RuntimeException(e);
            }
            XPath xPath = XPathFactory.newInstance().newXPath();
            result = GavSet.builder().defaultResult(GavSet.excludeAll());
            BannedDependencyResource.processPatterns(this.location, document, xPath, "//*[local-name() = 'exclude']/text()", arg_0 -> ((GavSet.IncludeExcludeGavSet.Builder)result).include(arg_0));
            BannedDependencyResource.processPatterns(this.location, document, xPath, "//*[local-name() = 'include']/text()", arg_0 -> ((GavSet.IncludeExcludeGavSet.Builder)result).exclude(arg_0));
            this.bannedSet = result.build();
        }
        return this.bannedSet;
    }

    static Document transform(String sourceLocation, Document sourceDocument, String xsltLocation, Charset charset) {
        Document document;
        block10: {
            if (xsltLocation == null || xsltLocation.isBlank()) {
                return sourceDocument;
            }
            Reader xsltReader = BannedDependencyResource.openReader(xsltLocation, charset);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltReader));
                DOMResult result = new DOMResult();
                transformer.transform(new DOMSource(sourceDocument), result);
                document = (Document)result.getNode();
                if (xsltReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (xsltReader != null) {
                        try {
                            xsltReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not open resource " + xsltLocation);
                }
                catch (TransformerException e) {
                    throw new RuntimeException("Could not transform " + sourceLocation + " usinng XSLT " + xsltLocation);
                }
            }
            xsltReader.close();
        }
        return document;
    }

    static void processPatterns(String path, Document document, XPath xPath, String xPathExpression, Consumer<String> gavPatternConsumer) {
        try {
            NodeList nodes = (NodeList)xPath.evaluate(xPathExpression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                String bannedPattern = n.getTextContent();
                gavPatternConsumer.accept(bannedPattern);
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Could not evaluate " + xPathExpression + " on " + path, e);
        }
    }

    static Reader openReader(String path, Charset charset) throws IOException {
        String prefix = "classpath:";
        if (path.startsWith("classpath:")) {
            if ((path = path.substring("classpath:".length())).startsWith("/")) {
                path = path.substring(1);
            }
            return new InputStreamReader(BannedDependencyResource.class.getClassLoader().getResourceAsStream(path), charset);
        }
        return Files.newBufferedReader(Paths.get(path, new String[0]), charset);
    }

    public String toString() {
        return "BannedDependencyResource [location=" + this.location + ", xsltLocation=" + this.xsltLocation + "]";
    }
}

