/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.DefaultRuntimeProvider;
import org.apache.camel.catalog.DefaultVersionManager;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.impl.CatalogHelper;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.Kind;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.l2x6.cq.common.CqCommonUtils;

public class CqCatalog {
    static final Predicate<Kind> SUPPORTED_CATALOG_KIND_FILTER = kind -> kind.equals((Object)Kind.component) || kind.equals((Object)Kind.dataformat) || kind.equals((Object)Kind.language) || kind.equals((Object)Kind.other);
    static final Predicate<ArtifactModel> SUPPORTED_CATALOG_MODEL_FILTER = artifactModel -> SUPPORTED_CATALOG_KIND_FILTER.test(artifactModel.getKind());
    private final DefaultCamelCatalog catalog;
    protected final Path baseDir;
    private Flavor flavor;

    public CqCatalog(Path baseDir, Flavor flavor) {
        this.baseDir = baseDir;
        this.flavor = flavor;
        DefaultCamelCatalog c = new DefaultCamelCatalog(true);
        c.setRuntimeProvider(flavor.createRuntimeProvider(c));
        c.setVersionManager((VersionManager)new CqVersionManager((CamelCatalog)c, baseDir));
        this.catalog = c;
    }

    public CqCatalog(Flavor flavor) {
        this.flavor = flavor;
        this.baseDir = null;
        this.catalog = new DefaultCamelCatalog(true);
    }

    public List<String> toCamelArtifactIdBase(String cqArtifactIdBase) {
        if ("core".equals(cqArtifactIdBase)) {
            return Arrays.asList("camel-base", "camel-core-languages");
        }
        if ("reactive-executor".equals(cqArtifactIdBase)) {
            return Collections.singletonList("camel-reactive-executor-vertx");
        }
        return Collections.singletonList("camel-" + cqArtifactIdBase);
    }

    public Stream<ArtifactModel<?>> filterModels(String cqArtifactIdBase) {
        List<String> camelArtifactIds = this.toCamelArtifactIdBase(cqArtifactIdBase);
        return this.models().filter(SUPPORTED_CATALOG_MODEL_FILTER).filter(model -> camelArtifactIds.contains(model.getArtifactId()));
    }

    public List<ArtifactModel<?>> primaryModel(String cqArtifactIdBase) {
        List<ArtifactModel<?>> componentModels;
        List<ArtifactModel<?>> models = this.filterModels(cqArtifactIdBase).filter(CqCatalog::isFirstScheme).filter(m -> !m.getName().startsWith("google-") || !m.getName().endsWith("-stream")).collect(Collectors.toList());
        if (models.size() > 1 && (componentModels = models.stream().filter(m -> m.getKind().equals((Object)Kind.component)).collect(Collectors.toList())).size() == 1) {
            return componentModels;
        }
        return models;
    }

    public Stream<ArtifactModel<?>> models() {
        return CqCatalog.kinds().filter(kind -> kind.equals((Object)Kind.component) || kind.equals((Object)Kind.dataformat) || kind.equals((Object)Kind.language) || kind.equals((Object)Kind.other)).flatMap(this::models);
    }

    public Stream<ArtifactModel<?>> models(Kind kind) {
        return this.findNames(kind).stream().map(name -> (ArtifactModel)this.model(kind, (String)name));
    }

    List<String> findNames(Kind kind) {
        switch (kind) {
            case model: {
                return this.catalog.findModelNames();
            }
        }
        return this.catalog.findNames(kind);
    }

    BaseModel<?> model(Kind kind, String name) {
        switch (kind) {
            case bean: {
                return this.catalog.pojoBeanModel(name);
            }
            case model: {
                return this.catalog.eipModel(name);
            }
        }
        return this.catalog.model(kind, name);
    }

    public Stream<EipModel> eips() {
        return this.catalog.findNames(Kind.eip).stream().map(arg_0 -> ((DefaultCamelCatalog)this.catalog).eipModel(arg_0));
    }

    public static Stream<Kind> kinds() {
        return Stream.of(Kind.values()).filter(kind -> kind != Kind.eip && kind != Kind.model);
    }

    public static boolean isCamelQuarkusOrphan(String scheme) {
        return "qute".equals(scheme);
    }

    public static boolean isFirstScheme(ArtifactModel<?> model) {
        if (model.getKind().equals((Object)Kind.component)) {
            String altSchemes = ((ComponentModel)model).getAlternativeSchemes();
            if (altSchemes == null || altSchemes.isEmpty()) {
                return true;
            }
            String scheme = model.getName();
            return altSchemes.equals(scheme) || altSchemes.startsWith(scheme + ",");
        }
        return true;
    }

    public static Comparator<ArtifactModel<?>> compareArtifactId() {
        return (m1, m2) -> m1.getArtifactId().compareTo(m2.getArtifactId());
    }

    public BaseModel<?> load(Kind kind, String name) {
        return this.catalog.model(kind, name);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Flavor {
        camel("org.apache.camel", "camel-catalog"){

            @Override
            public RuntimeProvider createRuntimeProvider(DefaultCamelCatalog c) {
                return new DefaultRuntimeProvider((CamelCatalog)c);
            }
        }
        ,
        camelQuarkus("org.apache.camel.quarkus", "camel-quarkus-catalog"){

            @Override
            public RuntimeProvider createRuntimeProvider(DefaultCamelCatalog c) {
                return new CqRuntimeProvider((CamelCatalog)c);
            }
        };

        private final String groupId;
        private final String artifactId;

        private Flavor(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public abstract RuntimeProvider createRuntimeProvider(DefaultCamelCatalog var1);

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }
    }

    static class CqVersionManager
    extends DefaultVersionManager {
        private final Path baseDir;

        public CqVersionManager(CamelCatalog camelCatalog, Path baseDir) {
            super(camelCatalog);
            this.baseDir = baseDir;
        }

        public InputStream getResourceAsStream(String name) {
            try {
                return Files.newInputStream(this.baseDir.resolve(name), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class GavCqCatalog
    extends CqCatalog
    implements AutoCloseable {
        private final FileSystem jarFileSystem;

        public static GavCqCatalog open(Path localRepository, Flavor flavor, String version, List<RemoteRepository> remoteRepositories, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
            Path jarPath = CqCommonUtils.resolveJar(localRepository, flavor.getGroupId(), flavor.getArtifactId(), version, remoteRepositories, repoSystem, repoSession);
            try {
                FileSystem fs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);
                return new GavCqCatalog(fs, flavor);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open file system " + jarPath, e);
            }
        }

        GavCqCatalog(FileSystem jarFileSystem, Flavor flavor) {
            super(jarFileSystem.getRootDirectories().iterator().next(), flavor);
            this.jarFileSystem = jarFileSystem;
        }

        @Override
        public void close() {
            try {
                this.jarFileSystem.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close catalog " + this.baseDir, e);
            }
        }
    }

    static class CqRuntimeProvider
    implements RuntimeProvider {
        public static final String CQ_CATALOG_DIR = "org/apache/camel/catalog/quarkus";
        private static final String COMPONENT_DIR = "org/apache/camel/catalog/quarkus/components";
        private static final String DATAFORMAT_DIR = "org/apache/camel/catalog/quarkus/dataformats";
        private static final String LANGUAGE_DIR = "org/apache/camel/catalog/quarkus/languages";
        private static final String OTHER_DIR = "org/apache/camel/catalog/quarkus/others";
        private static final String DEV_CONSOLE_DIR = "org/apache/camel/catalog/quarkus/consoles";
        private static final String POJO_BEAN_DIR = "org/apache/camel/catalog/quarkus/beans";
        private static final String TRANSFORMER_DIR = "org/apache/camel/catalog/quarkus/transformers";
        private static final String COMPONENTS_CATALOG = "org/apache/camel/catalog/quarkus/components.properties";
        private static final String DATA_FORMATS_CATALOG = "org/apache/camel/catalog/quarkus/dataformats.properties";
        private static final String LANGUAGE_CATALOG = "org/apache/camel/catalog/quarkus/languages.properties";
        private static final String OTHER_CATALOG = "org/apache/camel/catalog/quarkus/others.properties";
        private static final String DEV_CONSOLE_CATALOG = "org/apache/camel/catalog/quarkus/consoles.properties";
        private static final String POJO_BEAN_CATALOG = "org/apache/camel/catalog/quarkus/beans.properties";
        private static final String TRANSFORMER_CATALOG = "org/apache/camel/catalog/quarkus/transformers.properties";
        private static final String CAPABILITIES_CATALOG = "org/apache/camel/catalog/quarkus/capabilities.properties";
        private CamelCatalog camelCatalog;

        public CqRuntimeProvider(CamelCatalog camelCatalog) {
            this.camelCatalog = camelCatalog;
        }

        public CamelCatalog getCamelCatalog() {
            return this.camelCatalog;
        }

        public void setCamelCatalog(CamelCatalog camelCatalog) {
            this.camelCatalog = camelCatalog;
        }

        public String getProviderName() {
            return "camel-quarkus";
        }

        public String getProviderGroupId() {
            return "org.apache.camel.quarkus";
        }

        public String getProviderArtifactId() {
            return "camel-quarkus-catalog";
        }

        public String getComponentJSonSchemaDirectory() {
            return COMPONENT_DIR;
        }

        public String getDataFormatJSonSchemaDirectory() {
            return DATAFORMAT_DIR;
        }

        public String getLanguageJSonSchemaDirectory() {
            return LANGUAGE_DIR;
        }

        public String getOtherJSonSchemaDirectory() {
            return OTHER_DIR;
        }

        public String getDevConsoleJSonSchemaDirectory() {
            return DEV_CONSOLE_DIR;
        }

        public String getPojoBeanJSonSchemaDirectory() {
            return POJO_BEAN_DIR;
        }

        public String getTransformerJSonSchemaDirectory() {
            return TRANSFORMER_DIR;
        }

        public List<String> findComponentNames() {
            return this.findNames(COMPONENTS_CATALOG);
        }

        public List<String> findDataFormatNames() {
            return this.findNames(DATA_FORMATS_CATALOG);
        }

        public List<String> findLanguageNames() {
            return this.findNames(LANGUAGE_CATALOG);
        }

        public List<String> findOtherNames() {
            return this.findNames(OTHER_CATALOG);
        }

        public List<String> findBeansNames() {
            return this.findNames(POJO_BEAN_CATALOG);
        }

        public Map<String, String> findCapabilities() {
            Properties properties = new Properties();
            try (InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(CAPABILITIES_CATALOG);){
                properties.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new TreeMap<Object, Object>(properties);
        }

        public List<String> findDevConsoleNames() {
            return this.findNames(DEV_CONSOLE_CATALOG);
        }

        public List<String> findTransformerNames() {
            return this.findNames(TRANSFORMER_CATALOG);
        }

        List<String> findNames(String path) {
            ArrayList<String> names = new ArrayList<String>();
            InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(path);
            if (is != null) {
                try {
                    CatalogHelper.loadLines((InputStream)is, names);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return names;
        }
    }
}

