/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.common;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.tooling.model.Kind;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.assertj.core.util.diff.Delta;
import org.assertj.core.util.diff.DiffUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.l2x6.cq.common.OnFailure;
import org.l2x6.cq.common.PomModelCache;
import org.l2x6.cq.common.sync.SyncExpression;
import org.l2x6.cq.common.sync.SyncExpressions;
import org.l2x6.pom.tuner.MavenSourceTree;
import org.l2x6.pom.tuner.PomTransformer;
import org.l2x6.pom.tuner.PomTunerUtils;
import org.l2x6.pom.tuner.model.Ga;
import org.l2x6.pom.tuner.model.Gavtcs;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CqCommonUtils {
    public static final String VIRTUAL_DEPS_INITIAL_COMMENT = " The following dependencies guarantee that this module is built after them. You can update them by running `mvn process-resources -Pformat -N` from the source tree root directory ";
    private static final int CREATE_RETRY_COUNT = 256;
    private static final long DELETE_RETRY_MILLIS = 5000L;
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    private static final Pattern SIMPLE_XML_ELEMENT_PATTERN = Pattern.compile("\\s+/>");
    private static final List<String> MAVEN_MODULE_NAME_DELIMITERS = List.of(Pattern.quote(" :: "), Pattern.quote(" : "), Pattern.quote(" - "));

    private CqCommonUtils() {
    }

    public static Path resolveJar(Path localRepository, String groupId, String artifactId, String version, List<RemoteRepository> remoteRepositories, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        return CqCommonUtils.resolveArtifact(localRepository, groupId, artifactId, version, "jar", remoteRepositories, repoSystem, repoSession);
    }

    public static Path resolveArtifact(Path localRepository, String groupId, String artifactId, String version, String type, List<RemoteRepository> repositories, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        ArtifactResult resolutionResult;
        String relativeJarPath = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "." + type;
        Path localPath = localRepository.resolve(relativeJarPath);
        if (Files.exists(localPath, new LinkOption[0])) {
            return localPath;
        }
        DefaultArtifact aetherArtifact = new DefaultArtifact(groupId, artifactId, null, type, version);
        ArtifactRequest req = new ArtifactRequest().setRepositories(repositories).setArtifact((Artifact)aetherArtifact);
        try {
            resolutionResult = repoSystem.resolveArtifact(repoSession, req);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException("Artifact " + (Artifact)aetherArtifact + " could not be resolved.", e);
        }
        return resolutionResult.getArtifact().getFile().toPath();
    }

    public static Path installArtifact(Path source, Path localRepository, String groupId, String artifactId, String version, String type) {
        String relativeJarPath = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "." + type;
        Path localPath = localRepository.resolve(relativeJarPath);
        try {
            Files.createDirectories(localPath.getParent(), new FileAttribute[0]);
            Files.copy(source, localPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy " + source + " to " + localPath, e);
        }
        return localPath;
    }

    public static Path copyArtifact(Path localRepository, String groupId, String artifactId, String version, String type, List<String> remoteRepositories) {
        Path result;
        String relativeJarPath = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "." + type;
        Path localPath = localRepository.resolve(relativeJarPath);
        boolean localExists = Files.exists(localPath, new LinkOption[0]);
        try {
            result = Files.createTempFile(null, localPath.getFileName().toString(), new FileAttribute[0]);
            try (InputStream in = localExists ? Files.newInputStream(localPath, new OpenOption[0]) : CqCommonUtils.openFirst(remoteRepositories, relativeJarPath);
                 OutputStream out = Files.newOutputStream(result, new OpenOption[0]);){
                int len;
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy " + (Comparable)(localExists ? localPath : relativeJarPath) + " to " + result, e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temp file", e);
        }
        return result;
    }

    public static InputStream openFirst(List<String> remoteRepositories, String relativePath) throws IOException, MalformedURLException {
        for (String repo : remoteRepositories) {
            try {
                String uri = repo.endsWith("/") ? repo + relativePath : repo + "/" + relativePath;
                return new URL(uri).openStream();
            }
            catch (IOException iOException) {
            }
        }
        throw new RuntimeException("Could not get " + relativePath + " from any of " + remoteRepositories.stream().map(r -> r + relativePath).collect(Collectors.joining(", ")));
    }

    public static boolean isEmptyPropertiesFile(Path file) {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + file, e);
        }
        return props.isEmpty();
    }

    public static Model readPom(Path path, Charset charset) {
        Model model;
        block8: {
            BufferedReader r = Files.newBufferedReader(path, charset);
            try {
                model = new MavenXpp3Reader().read((Reader)r);
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new RuntimeException("Could not parse " + path, e);
                }
            }
            ((Reader)r).close();
        }
        return model;
    }

    public static String humanPlural(Kind kind) {
        switch (kind) {
            case eip: {
                return "EIPs";
            }
        }
        return CqCommonUtils.firstCap(kind.name()) + "s";
    }

    public static String firstCap(String in) {
        if (in == null) {
            return null;
        }
        if (in.isEmpty()) {
            return in;
        }
        StringBuilder sb = new StringBuilder(in.length());
        sb.append(Character.toUpperCase(in.charAt(0)));
        if (in.length() > 1) {
            sb.append(in.substring(1));
        }
        return sb.toString();
    }

    public static void updateVirtualDependencies(Charset charset, PomTransformer.SimpleElementWhitespace simpleElementWhitespace, Set<Gavtcs> allVirtualExtensions, Path pomXmlPath) {
        new PomTransformer(pomXmlPath, charset, simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.updateDependencySubset(gavtcs -> gavtcs.isVirtual(), allVirtualExtensions, (Comparator)Gavtcs.scopeAndTypeFirstComparator(), (String)VIRTUAL_DEPS_INITIAL_COMMENT), PomTransformer.Transformation.removeProperty((boolean)true, (boolean)true, (String)"mvnd.builder.rule"), PomTransformer.Transformation.removeContainerElementIfEmpty((boolean)true, (boolean)true, (boolean)true, (String)"properties", (String[])new String[0])});
    }

    public static String virtualDepsCommentXPath() {
        return "//comment()[contains(.,' The following dependencies guarantee that this module is built after them. You can update them by running `mvn process-resources -Pformat -N` from the source tree root directory ')]";
    }

    public static void deleteDirectory(Path directory) {
        if (Files.exists(directory, new LinkOption[0])) {
            try {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (isWindows) {
                            long deadline = System.currentTimeMillis() + 5000L;
                            FileSystemException lastException = null;
                            while (true) {
                                try {
                                    Files.delete(file);
                                    return FileVisitResult.CONTINUE;
                                }
                                catch (FileSystemException e) {
                                    lastException = e;
                                    if (System.currentTimeMillis() < deadline) continue;
                                    throw new IOException(String.format("Could not delete file [%s] after retrying for %d ms", file, 5000L), lastException);
                                }
                                break;
                            }
                        }
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Could not delete " + directory, e);
            }
        }
    }

    public static void ensureDirectoryExists(Path dir) {
        Exception toThrow = null;
        for (int i = 0; i < 256; ++i) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                if (!Files.exists(dir, new LinkOption[0])) continue;
                return;
            }
            catch (AccessDeniedException e) {
                toThrow = e;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    toThrow = e1;
                }
                continue;
            }
            catch (IOException e) {
                toThrow = e;
            }
        }
        if (toThrow != null) {
            throw new RuntimeException(String.format("Could not create directory [%s]", dir), toThrow);
        }
        throw new RuntimeException(String.format("Could not create directory [%s] attempting [%d] times", dir, 256));
    }

    public static void ensureDirectoryExistsAndEmpty(Path dir) {
        block11: {
            if (Files.exists(dir, new LinkOption[0])) {
                try (DirectoryStream<Path> subPaths = Files.newDirectoryStream(dir);){
                    for (Path subPath : subPaths) {
                        if (Files.isDirectory(subPath, new LinkOption[0])) {
                            CqCommonUtils.deleteDirectory(subPath);
                            continue;
                        }
                        Files.delete(subPath);
                    }
                    break block11;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not process " + dir, e);
                }
            }
            CqCommonUtils.ensureDirectoryExists(dir);
        }
    }

    public static List<Delta<String>> compareFiles(Path actual, Path expected, Charset charset) {
        List<String> expectedLines;
        List<String> actualLines;
        try {
            actualLines = Files.readAllLines(actual, charset);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + actual);
        }
        try {
            expectedLines = Files.readAllLines(expected, charset);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + expected);
        }
        if (actual.getFileName().toString().endsWith(".xml") || expected.getFileName().toString().endsWith(".xml")) {
            CqCommonUtils.normalizeXML(actualLines);
            CqCommonUtils.normalizeXML(expectedLines);
        }
        return DiffUtils.diff(actualLines, expectedLines).getDeltas();
    }

    static List<String> normalizeXML(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            lines.set(i, SIMPLE_XML_ELEMENT_PATTERN.matcher(line).replaceAll("/>"));
        }
        return lines;
    }

    public static void visitPoms(Path src, Consumer<Path> pomConsumer, final Predicate<Path> additionalFiles) {
        final TreeSet paths = new TreeSet();
        try {
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String dirName = dir.getFileName().toString();
                    if (dirName.equals("target") && Files.isRegularFile(dir.getParent().resolve("pom.xml"), new LinkOption[0])) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.equals("pom.xml") || additionalFiles.test(file)) {
                        paths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not visit pom.xml files under " + src, e);
        }
        paths.stream().forEach(pomConsumer);
    }

    public static Path copyPoms(Path src, Path dest, Predicate<Path> additionalFiles) {
        CqCommonUtils.ensureDirectoryExistsAndEmpty(dest);
        CqCommonUtils.visitPoms(src, file -> {
            Path destPath = dest.resolve(src.relativize((Path)file));
            try {
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                Files.copy(file, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy " + file + " to " + destPath, e);
            }
        }, additionalFiles);
        return dest;
    }

    public static void assertPomsMatch(Path src, Path dest, Set<String> activeRelativePomPaths, Predicate<Path> additionalFiles, Charset charset, Path basedir, Path referenceFile, OnFailure onCheckFailure, Consumer<String> warn, String fqFixMojo) {
        CqCommonUtils.visitPoms(src, file -> {
            Path destPath;
            List<Delta<String>> diffs;
            Path relPomPath = src.relativize((Path)file);
            String unixPath = PomTunerUtils.toUnixPath((String)relPomPath.toString());
            if (!(unixPath.endsWith("/pom.xml") && !activeRelativePomPaths.contains(unixPath) || (diffs = CqCommonUtils.compareFiles(file, destPath = dest.resolve(relPomPath), charset)).isEmpty())) {
                String msg = "File [" + PomTunerUtils.toUnixPath((String)basedir.relativize(destPath).toString()) + "] is not in sync with " + PomTunerUtils.toUnixPath((String)basedir.relativize(referenceFile).toString()) + ":\n\n    " + diffs.stream().map(Delta::toString).collect(Collectors.joining("\n    ")) + "\n\n Consider running mvn " + fqFixMojo + " -N\n\n";
                switch (onCheckFailure) {
                    case FAIL: {
                        throw new RuntimeException(msg);
                    }
                    case WARN: {
                        warn.accept(msg);
                        break;
                    }
                    case IGNORE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected " + OnFailure.class + " value " + onCheckFailure);
                    }
                }
            }
        }, additionalFiles);
    }

    public static Stream<Ga> filterExtensions(Stream<Ga> gas) {
        return gas.filter(ga -> ga.getArtifactId().endsWith("-deployment")).map(ga -> new Ga(ga.getGroupId(), ga.getArtifactId().substring(0, ga.getArtifactId().length() - "-deployment".length())));
    }

    public static void syncVersions(Path pomXml, MojoDescriptorCreator mojoDescriptorCreator, MavenSession session, MavenProject project, Charset charset, PomTransformer.SimpleElementWhitespace simpleElementWhitespace, Path localRepositoryPath, Log log, Map<String, String> versionTransformations, List<RemoteRepository> repositories, RepositorySystemSession repoSession, RepositorySystem repoSystem) {
        try {
            new PomTransformer(pomXml, charset, simpleElementWhitespace).transform(new PomTransformer.Transformation[]{new UpdateVersionsTransformation(new PomModelCache(localRepositoryPath, repositories, repoSystem, repoSession, project.getModel()), session, mojoDescriptorCreator, log, versionTransformations)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Predicate<org.l2x6.pom.tuner.model.Profile> getProfiles(MavenSession session) {
        Predicate profiles = MavenSourceTree.ActiveProfiles.of((String[])((String[])session.getCurrentProject().getActiveProfiles().stream().map(Profile::getId).toArray(String[]::new)));
        return profiles;
    }

    public static String getNameBase(String name) {
        String[] nameParts = MAVEN_MODULE_NAME_DELIMITERS.stream().map(delim -> name.split((String)delim)).filter(parts -> ((String[])parts).length >= 2).findFirst().orElseThrow(() -> new IllegalStateException("Could not split Maven module name '" + name + "' using any of delimiters " + MAVEN_MODULE_NAME_DELIMITERS + " expecting 3 parts"));
        return nameParts[1];
    }

    public static Model resolveEffectiveModel(Path pomFile, ProjectBuilder mavenProjectBuilder, MavenSession session) {
        DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        pbr.setProcessPlugins(false);
        try {
            return mavenProjectBuilder.build(pomFile.toFile(), (ProjectBuildingRequest)pbr).getProject().getModel();
        }
        catch (ProjectBuildingException e) {
            throw new RuntimeException("Failed to create model for " + pomFile, e);
        }
    }

    static class UpdateVersionsTransformation
    implements PomTransformer.Transformation {
        private final PomModelCache pomModels;
        private final MavenSession session;
        private final Log log;
        private final Map<String, String> versionTransformations;
        private final MojoDescriptorCreator mojoDescriptorCreator;

        public UpdateVersionsTransformation(PomModelCache pomModels, MavenSession session, MojoDescriptorCreator mojoDescriptorCreator, Log log, Map<String, String> versionTransformations) {
            this.pomModels = pomModels;
            this.session = session;
            this.mojoDescriptorCreator = mojoDescriptorCreator;
            this.log = log;
            this.versionTransformations = versionTransformations;
        }

        public void perform(Document document, PomTransformer.TransformationContext context) {
            context.getContainerElement(new String[]{"project", "properties"}).ifPresent(props -> {
                SyncExpressions.Builder expressionsBuilder = SyncExpressions.builder();
                for (PomTransformer.ContainerElement prop : props.childElements()) {
                    Comment nextComment = prop.nextSiblingCommentNode();
                    if (nextComment == null) continue;
                    String commentText = nextComment.getNodeValue();
                    SyncExpression.parse(prop.getNode(), commentText).ifPresent(expr -> expressionsBuilder.expression((SyncExpression)expr));
                }
                SyncExpressions expressions = expressionsBuilder.build();
                Function<String, String> mavenExpressionEvaluator = expr -> {
                    try {
                        MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor("help:evaluate", this.session, this.session.getCurrentProject());
                        return (String)new PluginParameterExpressionEvaluator(this.session, new MojoExecution(mojoDescriptor)).evaluate(expr, String.class);
                    }
                    catch (InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginNotFoundException | PluginResolutionException | NoPluginFoundForPrefixException | PluginVersionResolutionException | ExpressionEvaluationException e) {
                        throw new RuntimeException("Could not evaluate " + expr, e);
                    }
                };
                expressions.evaluate(mavenExpressionEvaluator, this.pomModels, (syncExpression, newValue) -> {
                    String oldValue;
                    String transformedValue;
                    Element propertyNode = syncExpression.getPropertyNode();
                    String propertyName = propertyNode.getLocalName();
                    StringWriter out = new StringWriter();
                    String versionTransformation = this.versionTransformations.get(propertyName);
                    if (versionTransformation != null) {
                        Configuration templateCfg = new Configuration(Configuration.VERSION_2_3_28);
                        templateCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                        try {
                            Template t = new Template(versionTransformation, (Reader)new StringReader(versionTransformation), templateCfg);
                            Map<String, String> model = Collections.singletonMap("version", newValue);
                            t.process(model, (Writer)out);
                            transformedValue = out.toString();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Could not parse " + versionTransformation, e);
                        }
                        catch (TemplateException e) {
                            throw new RuntimeException("Could not process " + versionTransformation, e);
                        }
                    } else {
                        transformedValue = newValue;
                    }
                    if ((oldValue = propertyNode.getTextContent()).equals(transformedValue)) {
                        this.log.info((CharSequence)(" - " + propertyName + ": " + oldValue));
                    } else {
                        this.log.info((CharSequence)(" - " + propertyName + ": " + oldValue + " -> " + transformedValue));
                    }
                    propertyNode.setTextContent(transformedValue);
                    this.session.getCurrentProject().getProperties().setProperty(propertyName, transformedValue);
                });
            });
        }
    }
}

