/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.common;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.io.xpp3.MavenXpp3WriterEx;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.assertj.core.util.diff.Delta;
import org.assertj.core.util.diff.DiffUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.l2x6.cq.common.CqCommonUtils;
import org.l2x6.cq.common.OnFailure;
import org.l2x6.pom.tuner.ExpressionEvaluator;
import org.l2x6.pom.tuner.MavenSourceTree;
import org.l2x6.pom.tuner.PomTransformer;
import org.l2x6.pom.tuner.model.Ga;
import org.l2x6.pom.tuner.model.Gav;
import org.l2x6.pom.tuner.model.GavPattern;
import org.l2x6.pom.tuner.model.GavSet;
import org.l2x6.pom.tuner.model.Gavtcs;
import org.l2x6.pom.tuner.model.Module;
import org.l2x6.pom.tuner.model.Profile;
import org.w3c.dom.Node;

public class FlattenBomTask {
    private final List<String> resolutionEntryPointIncludes;
    private final List<String> resolutionEntryPointExcludes;
    private final List<String> resolutionSuspects;
    private final List<String> originExcludes;
    private final List<BomEntryTransformation> bomEntryTransformations;
    private final GavSet requiredBomEntries;
    private final OnFailure onCheckFailure;
    private final Model effectivePomModel;
    private final String version;
    private final Path basePath;
    private final Path rootModuleDirectory;
    private final Path fullPomPath;
    private final Path reducedVerbosePamPath;
    private final Path reducedPomPath;
    private final Charset charset;
    private final Log log;
    private final List<RemoteRepository> repositories;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final Predicate<Profile> profiles;
    private final boolean format;
    private final PomTransformer.SimpleElementWhitespace simpleElementWhitespace;
    private final MavenProject project;
    private final InstallFlavor installFlavor;
    private final boolean quickly;
    private final GavSet bannedDependencies;
    private final List<Dependency> ownManagedDependencies;
    private final Path localRepositoryPath;
    private final List<Gav> additionalBoms;
    private static final Pattern LOCATION_COMMENT_PATTERN = Pattern.compile("\\s*\\Q<!--#}\\E");
    public static final String DEFAULT_FLATTENED_REDUCED_VERBOSE_POM_FILE = "src/main/generated/flattened-reduced-verbose-pom.xml";
    public static final String DEFAULT_FLATTENED_REDUCED_POM_FILE = "src/main/generated/flattened-reduced-pom.xml";
    public static final String DEFAULT_FLATTENED_FULL_POM_FILE = "src/main/generated/flattened-full-pom.xml";
    public static final String ORG_APACHE_CAMEL_QUARKUS_GROUP_ID = "org.apache.camel.quarkus";
    private static final Comparator<? super org.apache.maven.model.Exclusion> EXCLUSION_COMPARATOR = Comparator.comparing(org.apache.maven.model.Exclusion::getGroupId).thenComparing(org.apache.maven.model.Exclusion::getArtifactId);

    public FlattenBomTask(List<String> resolutionEntryPointIncludes, List<String> resolutionEntryPointExcludes, List<String> resolutionSuspects, List<String> originExcludes, List<BomEntryTransformation> bomEntryTransformations, List<String> requiredBomEntryIncludes, List<String> requiredBomEntryExcludes, OnFailure onCheckFailure, MavenProject project, Path rootModuleDirectory, Path fullPomPath, Path reducedVerbosePamPath, Path reducedPomPath, Charset charset, Log log, List<RemoteRepository> repositories, RepositorySystem repoSystem, RepositorySystemSession repoSession, Predicate<Profile> profiles, boolean format, PomTransformer.SimpleElementWhitespace simpleElementWhitespace, InstallFlavor installFlavor, boolean quickly, GavSet bannedDependencies, Path localRepositoryPath, List<Gav> additionalBoms) {
        this.resolutionEntryPointIncludes = resolutionEntryPointIncludes;
        this.resolutionEntryPointExcludes = resolutionEntryPointExcludes;
        this.resolutionSuspects = resolutionSuspects;
        this.originExcludes = originExcludes;
        this.bomEntryTransformations = FlattenBomTask.mergeTransformations(rootModuleDirectory, bomEntryTransformations, charset);
        this.requiredBomEntries = GavSet.builder().includes(requiredBomEntryIncludes == null ? Collections.emptyList() : requiredBomEntryIncludes).excludes(requiredBomEntryExcludes == null ? Collections.emptyList() : requiredBomEntryExcludes).build();
        this.onCheckFailure = onCheckFailure;
        this.project = project;
        this.effectivePomModel = project.getModel();
        this.basePath = project.getBasedir().toPath();
        Gav self = new Gav(project.getGroupId(), project.getArtifactId(), project.getVersion());
        this.ownManagedDependencies = project.getModel().getDependencyManagement().getDependencies().stream().filter(dep -> !"import".equals(dep.getScope())).filter(dep -> self.equals((Object)Gav.of((String)dep.getLocation((Object)"artifactId").getSource().getModelId()))).collect(Collectors.toList());
        this.version = project.getVersion();
        this.rootModuleDirectory = rootModuleDirectory;
        this.additionalBoms = additionalBoms;
        this.fullPomPath = FlattenBomTask.resolve(this.basePath, fullPomPath, DEFAULT_FLATTENED_FULL_POM_FILE);
        this.reducedVerbosePamPath = FlattenBomTask.resolve(this.basePath, reducedVerbosePamPath, DEFAULT_FLATTENED_REDUCED_VERBOSE_POM_FILE);
        this.reducedPomPath = FlattenBomTask.resolve(this.basePath, reducedPomPath, DEFAULT_FLATTENED_REDUCED_POM_FILE);
        this.charset = charset;
        this.log = log;
        this.repositories = repositories;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.profiles = profiles;
        this.format = format;
        this.simpleElementWhitespace = simpleElementWhitespace;
        this.installFlavor = installFlavor;
        this.quickly = quickly;
        this.bannedDependencies = bannedDependencies;
        this.localRepositoryPath = localRepositoryPath;
    }

    static List<BomEntryTransformation> mergeTransformations(Path rootModuleDirectory, List<BomEntryTransformation> bomEntryTransformations, Charset charset) {
        ArrayList<BomEntryTransformation> result = new ArrayList<BomEntryTransformation>();
        Path prodArtifacts = rootModuleDirectory.resolve("product/src/main/generated/transitive-dependencies-non-productized.txt");
        if (Files.isRegularFile(prodArtifacts, new LinkOption[0])) {
            try {
                Files.readAllLines(prodArtifacts, charset).stream().filter(line -> !line.isBlank()).map(line -> new BomEntryTransformation((String)line, "(\\.fuse)?(\\.temporary)?[\\-\\.]redhat-\\d+$/", null, null)).forEach(result::add);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + prodArtifacts, e);
            }
        }
        result.addAll(bomEntryTransformations);
        return result;
    }

    static Path resolve(Path basePath, Path relPath, String defaultPath) {
        return basePath.resolve(relPath == null ? Paths.get(defaultPath, new String[0]) : relPath);
    }

    public Path execute() {
        if (!this.quickly) {
            List deps;
            GavSet excludedByOrigin = GavSet.builder().includes(this.originExcludes == null ? Collections.emptyList() : this.originExcludes).build();
            GavSet resolveSet = GavSet.builder().includes(this.resolutionEntryPointIncludes == null ? Collections.emptyList() : this.resolutionEntryPointIncludes).excludes(this.resolutionEntryPointExcludes == null ? Collections.emptyList() : this.resolutionEntryPointExcludes).build();
            DependencyManagement effectiveDependencyManagement = this.effectivePomModel.getDependencyManagement();
            List<Object> originalConstrains = effectiveDependencyManagement == null ? Collections.emptyList() : ((deps = effectiveDependencyManagement.getDependencies()) == null ? Collections.emptyList() : Collections.unmodifiableList(deps.stream().map(Dependency::clone).peek(dep -> {
                if (!this.bomEntryTransformations.isEmpty()) {
                    this.bomEntryTransformations.stream().filter(transformation -> transformation.getGavPattern().matches(dep.getGroupId(), dep.getArtifactId(), dep.getVersion())).peek(transformation -> dep.setVersion(transformation.replaceVersion(dep.getVersion()))).forEach(transformation -> {
                        List depExclusions = dep.getExclusions();
                        transformation.getAddExclusions().stream().filter(newExcl -> depExclusions.stream().noneMatch(oldExcl -> EXCLUSION_COMPARATOR.compare((org.apache.maven.model.Exclusion)oldExcl, (org.apache.maven.model.Exclusion)newExcl) == 0)).forEach(depExclusions::add);
                        depExclusions.sort(EXCLUSION_COMPARATOR);
                    });
                }
            }).collect(Collectors.toList())));
            List<Dependency> constraintsFilteredByOrigin = Collections.unmodifiableList(originalConstrains.stream().filter(dep -> {
                Gav locationGav = Gav.of((String)dep.getLocation((Object)"artifactId").getSource().getModelId());
                boolean keep = !excludedByOrigin.contains(locationGav);
                return keep;
            }).collect(Collectors.toList()));
            ArrayList<Dependency> constraintsFilteredByOriginPlusAdditionalBoms = new ArrayList<Dependency>(constraintsFilteredByOrigin);
            TreeMap<Ga, Set<Gav>> additionalBomConstraits = new TreeMap<Ga, Set<Gav>>();
            this.addAdditionalBoms(this.additionalBoms, (gav, dep) -> {
                constraintsFilteredByOriginPlusAdditionalBoms.add((Dependency)dep);
                additionalBomConstraits.compute(new Ga(dep.getGroupId(), dep.getArtifactId()), (k, v) -> {
                    (v == null ? (v = new TreeSet<Gav>()) : v).add((Gav)gav);
                    return v;
                });
            });
            RequiredGas requiredGas = this.collectRequiredGas(constraintsFilteredByOriginPlusAdditionalBoms, constraintsFilteredByOrigin, this.ownManagedDependencies, additionalBomConstraits, resolveSet);
            List<Dependency> requiredConstraints = Collections.unmodifiableList(constraintsFilteredByOrigin.stream().filter(dep -> requiredGas.gas.contains(FlattenBomTask.toGa(dep))).collect(Collectors.toList()));
            this.checkRequiredConstraints(requiredGas.gas, requiredConstraints);
            this.checkExclusions(requiredGas.expectedExclusions);
            InputLocationStringFormatter formatter = new InputLocationStringFormatter(this.version);
            FlattenBomTask.write(originalConstrains, this.fullPomPath, this.effectivePomModel, this.charset, true, formatter);
            FlattenBomTask.write(requiredConstraints, this.reducedVerbosePamPath, this.effectivePomModel, this.charset, true, formatter);
            FlattenBomTask.write(requiredConstraints, this.reducedPomPath, this.effectivePomModel, this.charset, false, formatter);
        }
        Path result = switch (this.installFlavor) {
            case InstallFlavor.FULL -> this.fullPomPath;
            case InstallFlavor.REDUCED -> this.reducedPomPath;
            case InstallFlavor.REDUCED_VERBOSE -> this.reducedVerbosePamPath;
            case InstallFlavor.ORIGINAL -> this.project.getFile().toPath();
            default -> throw new IllegalStateException("Unexpected " + InstallFlavor.class.getSimpleName() + ": " + this.installFlavor);
        };
        this.project.setPomFile(result.toFile());
        return result;
    }

    void addAdditionalBoms(List<Gav> additionalBoms, BiConsumer<Gav, Dependency> additionalBomEntryConsumer) {
        for (Gav gav : additionalBoms) {
            Path path = CqCommonUtils.resolveArtifact(this.localRepositoryPath, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), "pom", this.repositories, this.repoSystem, this.repoSession);
            Model pom = CqCommonUtils.readPom(path, this.charset);
            List deps = pom.getDependencyManagement().getDependencies();
            String msg = deps.stream().filter(dep -> dep.getVersion().contains("${")).map(dep -> dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion()).collect(Collectors.joining("\n    - "));
            if (!msg.isEmpty()) {
                this.reportFailure("Additional BOM " + gav + " contains unresolved versions:\n    - " + msg);
            }
            deps.stream().filter(dep -> !dep.getVersion().contains("${")).forEach(dep -> additionalBomEntryConsumer.accept(gav, (Dependency)dep));
        }
    }

    static void applyTransformations(Ga bomEntry, List<BomEntryTransformation> bomEntryTransformations, BiConsumer<Ga, Ga> addExclusion) {
        bomEntryTransformations.stream().filter(transformation -> transformation.getGavPattern().matches(bomEntry)).map(BomEntryTransformation::getAddExclusions).flatMap(Collection::stream).map(exclusion -> new Ga(exclusion.getGroupId(), exclusion.getArtifactId())).forEach(exclusion -> addExclusion.accept(bomEntry, (Ga)exclusion));
    }

    RequiredGas collectRequiredGas(List<Dependency> constraintsFilteredByOriginPlusAdditionalBoms, List<Dependency> constraintsFilteredByOrigin, List<Dependency> ownManagedDependencies, Map<Ga, Set<Gav>> additionalBomConstraits, GavSet resolveSet) {
        RepositorySystemSession useRepoSession;
        Set ownManagedDependencyGas = ownManagedDependencies.stream().map(FlattenBomTask::toGa).collect(Collectors.toSet());
        MavenSourceTree t = MavenSourceTree.of((Path)this.rootModuleDirectory.resolve("pom.xml"), (Charset)this.charset);
        Set<Gavtcs> requiredDepsToResolve = this.collectDependenciesToResolve(constraintsFilteredByOrigin, resolveSet, t, additionalBomConstraits);
        Parent parent = this.effectivePomModel.getParent();
        DefaultArtifact emptyInstalledArtifact = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), null, "pom", parent.getVersion());
        Set ownGas = t.getModulesByGa().keySet();
        this.log.debug((CharSequence)"Constraints");
        List aetherConstraints = constraintsFilteredByOriginPlusAdditionalBoms.stream().filter(dep -> !ownGas.contains(FlattenBomTask.toGa(dep))).map(dep -> new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getType(), dep.getVersion()), null, Boolean.valueOf(false), (Collection)dep.getExclusions().stream().map(e -> new Exclusion(e.getGroupId(), e.getArtifactId(), "*", "*")).collect(Collectors.toList()))).peek(dep -> this.log.debug((CharSequence)(" - " + dep + " " + dep.getExclusions()))).collect(Collectors.toList());
        GavSet suspects = this.resolutionSuspects == null || this.resolutionSuspects.isEmpty() ? GavSet.excludeAll() : GavSet.builder().includes(this.resolutionSuspects).build();
        GavSet collectorExcludes = GavSet.builder().include(parent.getGroupId() + ":" + parent.getArtifactId()).build();
        TreeSet<Object> allTransitives = new TreeSet<Object>();
        ExpectedExclusions expectedExclusions = new ExpectedExclusions();
        Set constraintsFilteredByOriginGas = constraintsFilteredByOrigin.stream().map(FlattenBomTask::toGa).collect(Collectors.toSet());
        if (this.format) {
            useRepoSession = new DefaultRepositorySystemSession(this.repoSession);
            HashMap<String, Boolean> configProps = new HashMap<String, Boolean>(this.repoSession.getConfigProperties());
            configProps.put("aether.conflictResolver.verbose", true);
            ((DefaultRepositorySystemSession)useRepoSession).setConfigProperties(configProps);
        } else {
            useRepoSession = this.repoSession;
        }
        for (Gavtcs entry : requiredDepsToResolve) {
            DependencyCollector collector = new DependencyCollector(collectorExcludes, expectedExclusions::add, this.bannedDependencies, ownManagedDependencyGas::contains, constraintsFilteredByOriginGas::contains, additionalBomConstraits, suspects, stack -> this.log.warn((CharSequence)("Suspect pulled via\n    - " + stack.stream().map(Ga::toString).collect(Collectors.joining("\n    - ")))), this.log, this.format);
            CollectRequest request = new CollectRequest().setRoot(new org.eclipse.aether.graph.Dependency((Artifact)emptyInstalledArtifact, null)).setRepositories(this.repositories).setManagedDependencies(aetherConstraints).setDependencies(Collections.singletonList(new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(entry.getGroupId(), entry.getArtifactId(), entry.getType(), entry.getVersion()), null)));
            try {
                DependencyNode rootNode = this.repoSystem.collectDependencies(useRepoSession, request).getRoot();
                rootNode.accept((DependencyVisitor)collector);
            }
            catch (IllegalArgumentException | DependencyCollectionException e) {
                throw new RuntimeException("Could not resolve dependencies of " + entry.getGroupId() + ":" + entry.getArtifactId() + ":" + entry.getType() + ":" + entry.getVersion(), e);
            }
            boolean isResolutionEntryPoint = requiredDepsToResolve.contains(entry);
            if (!isResolutionEntryPoint) continue;
            allTransitives.addAll(collector.allTransitives);
        }
        this.checkManagedCamelQuarkusArtifacts(t, constraintsFilteredByOrigin);
        constraintsFilteredByOrigin.stream().map(FlattenBomTask::toGa).forEach(bomEntry -> FlattenBomTask.applyTransformations(bomEntry, this.bomEntryTransformations, expectedExclusions::add));
        allTransitives.addAll(t.getModulesByGa().keySet());
        return new RequiredGas(Collections.unmodifiableSet(allTransitives), FlattenBomTask.unmodifiable(expectedExclusions.expectedExclusions));
    }

    static Map<Ga, Set<Ga>> unmodifiable(Map<Ga, Set<Ga>> map) {
        map.entrySet().stream().forEach(en -> en.setValue(Collections.unmodifiableSet((Set)en.getValue())));
        return Collections.unmodifiableMap(map);
    }

    static void collectTransitiveExternalDependencies(MavenSourceTree t, ExpressionEvaluator evaluator, Ga ga, Predicate<Profile> profiles, Set<String> wantedScopes, Consumer<Gavtcs> dependencyConsumer) {
        t.collectOwnDependencies(ga, profiles).stream().filter(dep -> wantedScopes.contains(dep.getScope())).map(dep -> {
            String groupId = evaluator.evaluate(dep.getGroupId());
            String artifactId = evaluator.evaluate(dep.getArtifactId());
            String type = dep.getType() == null ? "jar" : dep.getType();
            String classifier = dep.getClassifier() == null ? null : evaluator.evaluate(dep.getClassifier());
            return new Gavtcs(groupId, artifactId, null, type, classifier, null);
        }).filter(dep -> {
            if (t.getModulesByGa().containsKey(dep.toGa())) {
                FlattenBomTask.collectTransitiveExternalDependencies(t, evaluator, dep.toGa(), profiles, wantedScopes, dependencyConsumer);
                return false;
            }
            return true;
        }).forEach(dependencyConsumer);
    }

    Set<Gavtcs> collectDependenciesToResolve(List<Dependency> originalConstrains, GavSet entryPoints, MavenSourceTree t, Map<Ga, Set<Gav>> additionalBomConstraits) {
        ExpressionEvaluator evaluator = t.getExpressionEvaluator(this.profiles);
        Map modulesByGa = t.getModulesByGa();
        LinkedHashSet<Gavtcs> result = new LinkedHashSet<Gavtcs>();
        HashSet<String> wantedScopes = new HashSet<String>(Arrays.asList("compile", "provided"));
        originalConstrains.stream().filter(dep -> entryPoints.contains(dep.getGroupId(), dep.getArtifactId(), dep.getVersion())).forEach(mvnDep -> {
            Ga ga = FlattenBomTask.toGa(mvnDep);
            Module module = (Module)modulesByGa.get(ga);
            if (module == null) {
                result.add(FlattenBomTask.toGavtcs(mvnDep));
            } else {
                FlattenBomTask.collectTransitiveExternalDependencies(t, evaluator, ga, this.profiles, wantedScopes, gavtcs -> {
                    Optional<String> version = originalConstrains.stream().filter(d -> gavtcs.getGroupId().equals(d.getGroupId()) && gavtcs.getArtifactId().equals(d.getArtifactId()) && FlattenBomTask.compare(gavtcs.getType(), d.getType(), "jar") && FlattenBomTask.compare(gavtcs.getClassifier(), d.getClassifier(), "")).map(Dependency::getVersion).findFirst();
                    if (version.isPresent()) {
                        SortedSet<Ga> exclusions = FlattenBomTask.getExclusions(mvnDep);
                        result.add(new Gavtcs(gavtcs.getGroupId(), gavtcs.getArtifactId(), version.get(), gavtcs.getType(), gavtcs.getClassifier(), null, exclusions));
                    } else if (!additionalBomConstraits.containsKey(gavtcs.toGa())) {
                        this.log.warn((CharSequence)("Could not assign version to " + gavtcs.toGa() + ". Perhaps a missing BOM entry?"));
                    }
                });
            }
        });
        return result;
    }

    static SortedSet<Ga> getExclusions(Dependency mvnDep) {
        return (mvnDep.getExclusions() == null ? Collections.emptyList() : mvnDep.getExclusions()).stream().map(excl -> new Ga(excl.getGroupId(), excl.getArtifactId())).collect(Collectors.toCollection(TreeSet::new));
    }

    static Ga toGa(Dependency dep) {
        return new Ga(dep.getGroupId(), dep.getArtifactId());
    }

    static Gavtcs toGavtcs(Dependency mvnDep) {
        SortedSet<Ga> exclusions = FlattenBomTask.getExclusions(mvnDep);
        return new Gavtcs(mvnDep.getGroupId(), mvnDep.getArtifactId(), mvnDep.getVersion(), mvnDep.getType(), mvnDep.getClassifier(), null, exclusions);
    }

    void checkManagedCamelQuarkusArtifacts(MavenSourceTree t, List<Dependency> originalConstrains) {
        String missingDeploymentEntries;
        String missingRuntimeEntries;
        Set cqGas = t.getModulesByGa().keySet();
        TreeSet managedCqGas = new TreeSet();
        String staleCqArtifacts = originalConstrains.stream().filter(dep -> dep.getGroupId().equals(ORG_APACHE_CAMEL_QUARKUS_GROUP_ID)).peek(dep -> managedCqGas.add(FlattenBomTask.toGa(dep))).filter(dep -> this.version.equals(dep.getVersion())).map(FlattenBomTask::toGa).filter(ga -> !cqGas.contains(ga)).map(Ga::toString).distinct().sorted().collect(Collectors.joining("\n    "));
        if (!staleCqArtifacts.isEmpty()) {
            String msg = "Please remove these non-existent org.apache.camel.quarkus:* entries managed in camel-quarkus-bom:\n\n    " + staleCqArtifacts + "\n\n";
            this.reportFailure(msg);
        }
        if (!(missingRuntimeEntries = managedCqGas.stream().filter(ga -> ga.getArtifactId().endsWith("-deployment")).map(ga -> new Ga(ga.getGroupId(), FlattenBomTask.toRuntimeArtifactId(ga.getArtifactId()))).filter(ga -> !managedCqGas.contains(ga)).map(Ga::toString).collect(Collectors.joining("\n    "))).isEmpty()) {
            String msg = "Please add these entries to camel-quarkus-bom:\n\n    " + missingRuntimeEntries + "\n\n";
            this.reportFailure(msg);
        }
        if (!(missingDeploymentEntries = managedCqGas.stream().filter(ga -> !ga.getArtifactId().endsWith("-deployment")).map(ga -> new Ga(ga.getGroupId(), ga.getArtifactId() + "-deployment")).filter(ga -> !managedCqGas.contains(ga) && cqGas.contains(ga)).map(Ga::toString).collect(Collectors.joining("\n    "))).isEmpty()) {
            String msg = "Please add these entries to camel-quarkus-bom:\n\n    " + missingDeploymentEntries + "\n\n";
            this.reportFailure(msg);
        }
    }

    static String toRuntimeArtifactId(String deploymentArtifactId) {
        return deploymentArtifactId.substring(0, deploymentArtifactId.length() - "-deployment".length());
    }

    void checkRequiredConstraints(Set<Ga> allTransitives, List<Dependency> originalConstrains) {
        List actualRequiredBomEntries;
        List expectedRequiredBomEntries = allTransitives.stream().filter(ga -> this.requiredBomEntries.contains(ga)).filter(ga -> !this.bannedDependencies.contains(ga)).map(Ga::toString).sorted().collect(Collectors.toList());
        List diffs = DiffUtils.diff(expectedRequiredBomEntries, actualRequiredBomEntries = originalConstrains.stream().filter(dep -> this.requiredBomEntries.contains(dep.getGroupId(), dep.getArtifactId())).map(dep -> dep.getGroupId() + ":" + dep.getArtifactId()).distinct().sorted().collect(Collectors.toList())).getDeltas();
        if (!diffs.isEmpty()) {
            String msg = "Too little or too much required constraints in " + this.project.getArtifactId() + ":\n\n    " + diffs.stream().map(Delta::toString).collect(Collectors.joining("\n    ")) + "\n\nConsider adding, removing or excluding them in the BOM\n\n";
            this.reportFailure(msg);
        }
    }

    void reportFailure(String msg) {
        switch (this.onCheckFailure) {
            case FAIL: {
                throw new RuntimeException(msg);
            }
            case WARN: {
                this.log.warn((CharSequence)msg);
                break;
            }
            case IGNORE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + OnFailure.class + " value " + this.onCheckFailure);
            }
        }
    }

    void checkExclusions(Map<Ga, Set<Ga>> expectedExclusionsMap) {
        Path transformedPomPath;
        Path originalPomPath;
        if (this.format) {
            originalPomPath = this.basePath.resolve("target/original-pom.xml");
            FlattenBomTask.copyPom(this.basePath.resolve("pom.xml"), originalPomPath);
            transformedPomPath = this.basePath.resolve("pom.xml");
        } else {
            originalPomPath = this.basePath.resolve("pom.xml");
            transformedPomPath = this.basePath.resolve("target/transformed-pom.xml");
            FlattenBomTask.copyPom(this.basePath.resolve("pom.xml"), transformedPomPath);
        }
        new PomTransformer(transformedPomPath, this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{(doc, context) -> {
            Set deps = context.getManagedDependencies();
            TreeSet doneMissingBannedDeps = new TreeSet();
            deps.stream().forEach(dep -> {
                Ga bomEntry = dep.toGa();
                doneMissingBannedDeps.add(bomEntry);
                Set expectedExclusionsSet = (Set)expectedExclusionsMap.get(bomEntry);
                if (expectedExclusionsSet != null && !expectedExclusionsSet.isEmpty()) {
                    PomTransformer.ContainerElement exclusionsNode = dep.getNode().getOrAddChildContainerElement("exclusions");
                    expectedExclusionsSet.forEach(missingExclusion -> FlattenBomTask.addExclusion(exclusionsNode, missingExclusion));
                }
            });
            PomTransformer.ContainerElement cqMavenPluginNode = ((PomTransformer.ContainerElement)context.getContainerElement(new String[]{"project", "build", "plugins"}).orElseThrow()).childElementsStream().map(PomTransformer.ContainerElement::asGavtcs).filter(pluginNode -> pluginNode.getGroupId().equals("org.l2x6.cq") && pluginNode.getArtifactId().equals("cq-maven-plugin")).findFirst().orElseThrow(() -> new IllegalStateException("Could not find org.l2x6.cq:cq-maven-plugin in " + context.getXPath())).getNode();
            PomTransformer.ContainerElement flattenBomExecutionNode = ((PomTransformer.ContainerElement)cqMavenPluginNode.getChildContainerElement("executions").orElseThrow(() -> new IllegalStateException("Could not find org.l2x6.cq:cq-maven-plugin/executions in " + context.getXPath()))).childElementsStream().filter(executionNode -> {
                Optional idNode = executionNode.getChildContainerElement("id");
                return idNode.isPresent() && ((PomTransformer.ContainerElement)idNode.get()).getNode().getTextContent().equals("flatten-bom");
            }).findFirst().orElseThrow(() -> new IllegalStateException("Could not find flatten-bom execution of org.l2x6.cq:cq-maven-plugin in " + context.getXPath()));
            PomTransformer.ContainerElement bomEntryTransformationsNode = flattenBomExecutionNode.getOrAddChildContainerElement("configuration").getOrAddChildContainerElement("autogeneratedBomEntryTransformations");
            List missingTransformations = expectedExclusionsMap.entrySet().stream().filter(en -> !doneMissingBannedDeps.contains(en.getKey())).collect(Collectors.toList());
            if (!missingTransformations.isEmpty()) {
                TreeMap transformations = new TreeMap();
                bomEntryTransformationsNode.childElementsStream().map(bomEntryTransformationNode -> new BomEntryTransformationData(new BomEntryTransformation(((PomTransformer.ContainerElement)bomEntryTransformationNode.getChildContainerElement("gavPattern").get()).getNode().getTextContent(), bomEntryTransformationNode.getChildContainerElement("versionReplacement").map(node -> node.getNode().getTextContent()).orElse(null), bomEntryTransformationNode.getChildContainerElement("exclusions").map(node -> node.getNode().getTextContent()).orElse(null), bomEntryTransformationNode.getChildContainerElement("addExclusions").map(node -> node.getNode().getTextContent()).orElse(null)), (PomTransformer.ContainerElement)bomEntryTransformationNode)).forEach(bomEntryTransformationData -> {
                    BomEntryTransformationData oldEntry = (BomEntryTransformationData)transformations.get(bomEntryTransformationData.bomEntryTransformation.getGavPattern());
                    if (oldEntry != null) {
                        throw new IllegalStateException("Cannot handle bomEntryTransformations with the same gavPattern: " + oldEntry.bomEntryTransformation + " vs. " + bomEntryTransformationData.bomEntryTransformation + "; please merge them manually");
                    }
                    transformations.put(bomEntryTransformationData.bomEntryTransformation.getGavPattern(), bomEntryTransformationData);
                });
                missingTransformations.stream().forEach(en -> {
                    GavPattern pattern = GavPattern.of((String)((Ga)en.getKey()).toString());
                    Set missingExclusions = (Set)en.getValue();
                    BomEntryTransformationData oldTransformation = (BomEntryTransformationData)transformations.get(pattern);
                    if (oldTransformation != null) {
                        oldTransformation.addExclusions(missingExclusions);
                    } else {
                        BomEntryTransformationData bomEntryTransformationData = BomEntryTransformationData.create(pattern, missingExclusions, bomEntryTransformationsNode);
                        transformations.put(pattern, bomEntryTransformationData);
                    }
                });
            }
        }});
        try {
            List diffs = DiffUtils.diff(Files.readAllLines(transformedPomPath, this.charset), Files.readAllLines(originalPomPath, this.charset)).getDeltas();
            if (!diffs.isEmpty()) {
                if (this.format) {
                    throw new RuntimeException("Changes were made in " + this.effectivePomModel.getGroupId() + ":" + this.effectivePomModel.getArtifactId() + ". Run\n\n     mvn install\n\nto make them effective.");
                }
                StringBuilder msg = new StringBuilder("Missing exclusions in ").append(this.effectivePomModel.getGroupId()).append(":").append(this.effectivePomModel.getArtifactId()).append(":\n");
                diffs.stream().map(Delta::toString).forEach(str -> msg.append((String)str).append('\n'));
                msg.append("\n\nYou may want to consider running\n\n    mvn process-resources -Dcq.flatten-bom.format\n\nto fix the named issues in this BOM");
                this.reportFailure(msg.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + transformedPomPath + " or " + originalPomPath, e);
        }
    }

    static void copyPom(Path sourcePomPath, Path destinationPomPath) {
        try {
            Files.createDirectories(destinationPomPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create " + destinationPomPath.getParent(), e);
        }
        try {
            Files.copy(sourcePomPath, destinationPomPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy " + sourcePomPath + " to " + destinationPomPath, e);
        }
    }

    static String reformat(String xml, Charset charset) {
        SAXBuilder builder = new SAXBuilder();
        builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
        try {
            Document effectiveDocument = builder.build((Reader)new StringReader(xml));
            StringWriter w = new StringWriter();
            Format format = Format.getPrettyFormat();
            format.setEncoding(charset.name());
            format.setLineSeparator("\n");
            format.setOmitDeclaration(false);
            XMLOutputter out = new XMLOutputter(format);
            out.output(effectiveDocument, (Writer)w);
            return LOCATION_COMMENT_PATTERN.matcher(w.toString()).replaceAll("<!--");
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException("Could not reformat ", e);
        }
    }

    static void addExclusion(PomTransformer.ContainerElement exclusions, Ga newExclusion) {
        Node refNode = null;
        for (PomTransformer.ContainerElement dep : exclusions.childElements()) {
            Ga depGavtcs = dep.asGavtcs().toGa();
            int comparison = newExclusion.compareTo(depGavtcs);
            if (comparison == 0) {
                return;
            }
            if (refNode != null || comparison >= 0) continue;
            refNode = dep.previousSiblingInsertionRefNode();
        }
        if (refNode == null) {
            refNode = exclusions.getOrAddLastIndent();
        }
        PomTransformer.ContainerElement dep = exclusions.addChildContainerElement("exclusion", refNode, false, false);
        dep.addChildTextElement("groupId", newExclusion.getGroupId());
        dep.addChildTextElement("artifactId", newExclusion.getArtifactId());
    }

    static boolean compare(String pomTunerValue, String mavenValue, String defaultValue) {
        if (mavenValue == null || mavenValue.isEmpty() || defaultValue.equals(mavenValue)) {
            return pomTunerValue == null || pomTunerValue.isEmpty() || defaultValue.equals(pomTunerValue);
        }
        return mavenValue.equals(pomTunerValue);
    }

    static void write(List<Dependency> finalConstraints, Path flattenedPomPath, Model project, Charset charset, boolean verbose, InputLocation.StringFormatter formatter) {
        String originalContent;
        Model model = new Model();
        model.setModelVersion(project.getModelVersion());
        model.setGroupId(project.getGroupId());
        model.setArtifactId(project.getArtifactId());
        model.setVersion(project.getVersion());
        model.setPackaging("pom");
        model.setName(project.getName());
        model.setDescription(project.getDescription());
        model.setUrl(project.getUrl());
        model.setLicenses(project.getLicenses());
        model.setDevelopers(project.getDevelopers());
        model.setScm(project.getScm());
        model.setIssueManagement(project.getIssueManagement());
        model.setDistributionManagement(project.getDistributionManagement());
        DependencyManagement dm = new DependencyManagement();
        dm.setDependencies(finalConstraints);
        model.setDependencyManagement(dm);
        try {
            Files.createDirectories(flattenedPomPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create " + flattenedPomPath.getParent(), e);
        }
        StringWriter sw = new StringWriter();
        try {
            if (verbose) {
                MavenXpp3WriterEx xpp3Writer = new MavenXpp3WriterEx();
                xpp3Writer.setStringFormatter(formatter);
                xpp3Writer.write((Writer)sw, model);
            } else {
                new MavenXpp3Writer().write((Writer)sw, model);
            }
        }
        catch (IOException e1) {
            throw new RuntimeException("Could not serialize pom.xml model: \n\n" + model);
        }
        String newContent = FlattenBomTask.reformat(sw.toString(), charset);
        if (Files.exists(flattenedPomPath, new LinkOption[0])) {
            try {
                originalContent = new String(Files.readAllBytes(flattenedPomPath), charset);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + flattenedPomPath, e);
            }
        } else {
            originalContent = "";
        }
        if (!newContent.equals(originalContent)) {
            try (BufferedWriter out = Files.newBufferedWriter(flattenedPomPath, charset, new OpenOption[0]);){
                out.write(newContent);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write " + flattenedPomPath, e);
            }
        }
    }

    public static enum InstallFlavor {
        FULL,
        REDUCED,
        REDUCED_VERBOSE,
        ORIGINAL;

    }

    private static class RequiredGas {
        private final Set<Ga> gas;
        private final Map<Ga, Set<Ga>> expectedExclusions;

        public RequiredGas(Set<Ga> gas, Map<Ga, Set<Ga>> expectedExclusions) {
            this.gas = gas;
            this.expectedExclusions = expectedExclusions;
        }
    }

    private static class InputLocationStringFormatter
    extends InputLocation.StringFormatter {
        private final String versionSuffix;
        private static final String GAV_PREFIX = "org.apache.camel.quarkus:";

        public InputLocationStringFormatter(String version) {
            this.versionSuffix = ":" + version;
        }

        public String toString(InputLocation location) {
            InputSource source = location.getSource();
            String s = source.getModelId();
            if (StringUtils.isBlank((String)s) || s.contains("[unknown-version]")) {
                s = source.toString();
            }
            if (s.startsWith(GAV_PREFIX)) {
                s = s.replace(this.versionSuffix, ":${project.version}");
            }
            return "#} " + s + " ";
        }
    }

    private static class ExpectedExclusions {
        final Map<Ga, Set<Ga>> expectedExclusions = new TreeMap<Ga, Set<Ga>>();

        private ExpectedExclusions() {
        }

        public void add(Ga bomEntry, Ga exclusion) {
            this.expectedExclusions.compute(bomEntry, (k, v) -> {
                (v == null ? (v = new TreeSet<Ga>()) : v).add(exclusion);
                return v;
            });
        }
    }

    static class DependencyCollector
    implements DependencyVisitor {
        private final Set<Ga> allTransitives = new TreeSet<Ga>();
        private final GavSet excludes;
        private final BiConsumer<Ga, Ga> exclusionConsumer;
        private final Deque<Ga> stack = new ArrayDeque<Ga>();
        private final GavSet bannedDependencies;
        private final Predicate<Ga> isCurrentBomEntry;
        private final Predicate<Ga> isCurrentBomOrIncludedEntry;
        private final GavSet suspects;
        private final Consumer<Deque<Ga>> suspectConsumer;
        private final Map<Ga, Set<Gav>> additionalBomConstraits;
        private final Log log;
        private final boolean format;

        public DependencyCollector(GavSet excludes, BiConsumer<Ga, Ga> exclusionConsumer, GavSet bannedDependencies, Predicate<Ga> isCurrentBomEntry, Predicate<Ga> isCurrentBomIncludedEntry, Map<Ga, Set<Gav>> additionalBomConstraits, GavSet suspects, Consumer<Deque<Ga>> suspectConsumer, Log log, boolean format) {
            this.excludes = excludes;
            this.exclusionConsumer = exclusionConsumer;
            this.bannedDependencies = bannedDependencies;
            this.isCurrentBomEntry = isCurrentBomEntry;
            this.isCurrentBomOrIncludedEntry = isCurrentBomIncludedEntry;
            this.additionalBomConstraits = additionalBomConstraits;
            this.suspects = suspects;
            this.suspectConsumer = suspectConsumer;
            this.log = log;
            this.format = format;
        }

        public boolean visitLeave(DependencyNode node) {
            if (!this.format || node.getData().get("conflict.winner") == null) {
                this.stack.pop();
            }
            return true;
        }

        public boolean visitEnter(DependencyNode node) {
            DependencyNode winner;
            Artifact a = node.getArtifact();
            Ga ga = new Ga(a.getGroupId(), a.getArtifactId());
            if (this.format && (winner = (DependencyNode)node.getData().get("conflict.winner")) != null) {
                if (!this.stack.contains(ga)) {
                    winner.accept((DependencyVisitor)this);
                }
                return false;
            }
            boolean result = true;
            if (!this.excludes.contains(a.getGroupId(), a.getArtifactId())) {
                if (this.bannedDependencies.contains(ga)) {
                    Optional<Ga> includedDependent;
                    result = false;
                    Optional<Ga> dependent = this.stack.stream().filter(this.isCurrentBomEntry).findFirst();
                    if (dependent.isPresent()) {
                        this.exclusionConsumer.accept(dependent.get(), ga);
                    }
                    if ((includedDependent = this.stack.stream().filter(this.isCurrentBomOrIncludedEntry).findFirst()).isPresent() && !Objects.equals(includedDependent.get(), dependent.orElse(null))) {
                        this.exclusionConsumer.accept(includedDependent.get(), ga);
                    } else if (!dependent.isPresent() && !includedDependent.isPresent()) {
                        TreeMap<Gav, Map.Entry> missingAddionalBomExclusions = new TreeMap<Gav, Map.Entry>();
                        this.stack.stream().forEach(stackEntry -> Optional.ofNullable(this.additionalBomConstraits.get(stackEntry)).ifPresent(additionalBomGavs -> additionalBomGavs.stream().forEach(bomGav -> missingAddionalBomExclusions.put((Gav)bomGav, new AbstractMap.SimpleImmutableEntry<Ga, Ga>((Ga)stackEntry, ga)))));
                        if (!missingAddionalBomExclusions.isEmpty()) {
                            missingAddionalBomExclusions.forEach((additionalBomGav, entry) -> this.log.warn((CharSequence)(additionalBomGav + " is possibly missing an exclusion on " + entry.getKey() + ":\n\n    <exclusion>\n        <groupId>" + ((Ga)entry.getValue()).getGroupId() + "</groupId>\n        <artifactId>" + ((Ga)entry.getValue()).getArtifactId() + "</artifactId>\n    </exclusion>\n")));
                        } else {
                            throw new IllegalStateException("Cannot link banned dependency to any own or included BOM entry:\n    " + ga + "\n    -> " + this.stack.stream().map(Ga::toString).collect(Collectors.joining("\n    -> ")));
                        }
                    }
                }
                this.allTransitives.add(ga);
            }
            this.stack.push(ga);
            if (this.suspects.contains(ga)) {
                this.suspectConsumer.accept(this.stack);
            }
            return result;
        }
    }

    private static class BomEntryTransformationData {
        final BomEntryTransformation bomEntryTransformation;
        final PomTransformer.ContainerElement containerElement;

        public BomEntryTransformationData(BomEntryTransformation bomEntryTransformation, PomTransformer.ContainerElement containerElement) {
            this.bomEntryTransformation = bomEntryTransformation;
            this.containerElement = containerElement;
        }

        public void addExclusions(Set<Ga> missingExclusions) {
            Set<Ga> existingExclusions = this.bomEntryTransformation.internalExclusions;
            if (!existingExclusions.containsAll(missingExclusions)) {
                existingExclusions.addAll(missingExclusions);
                this.containerElement.addOrSetChildTextElement("addExclusions", existingExclusions.stream().map(Ga::toString).collect(Collectors.joining(",")));
                Optional exclusions = this.containerElement.getChildContainerElement("exclusions");
                if (exclusions.isPresent()) {
                    ((PomTransformer.ContainerElement)exclusions.get()).remove(true, true);
                }
            }
        }

        public static BomEntryTransformationData create(GavPattern pattern, Set<Ga> missingExclusions, PomTransformer.ContainerElement parent) {
            BomEntryTransformation transformation = new BomEntryTransformation();
            transformation.setGavPattern(pattern.toString());
            String exclusions = missingExclusions.stream().map(Ga::toString).collect(Collectors.joining(","));
            transformation.setAddExclusions(exclusions);
            PomTransformer.ContainerElement node = parent.addChildContainerElement("autogeneratedBomEntryTransformation");
            node.addChildTextElement("gavPattern", pattern.toString());
            node.addChildTextElement("addExclusions", exclusions);
            return new BomEntryTransformationData(transformation, node);
        }
    }

    public static class BomEntryTransformation {
        private GavPattern gavPattern;
        private Set<Ga> internalExclusions = new TreeSet<Ga>();
        private Pattern versionPattern;
        private String versionReplace;

        public BomEntryTransformation() {
        }

        public BomEntryTransformation(String gavPattern, String versionReplacement, String exclusions, String addExclusions) {
            if (gavPattern != null) {
                this.setGavPattern(gavPattern);
            }
            if (versionReplacement != null) {
                this.setVersionReplacement(versionReplacement);
            }
            if (exclusions != null) {
                this.setExclusions(exclusions);
            }
            if (addExclusions != null) {
                this.setAddExclusions(addExclusions);
            }
        }

        public List<org.apache.maven.model.Exclusion> getAddExclusions() {
            return this.internalExclusions.stream().map(ga -> {
                org.apache.maven.model.Exclusion excl = new org.apache.maven.model.Exclusion();
                excl.setGroupId(ga.getGroupId());
                excl.setArtifactId(ga.getArtifactId());
                return excl;
            }).collect(Collectors.toList());
        }

        public void setAddExclusions(String exclusions) {
            for (String rawExcl : exclusions.split("[,\\s]+")) {
                this.internalExclusions.add(GavPattern.of((String)rawExcl).asWildcardGa());
            }
        }

        @Deprecated
        public void setExclusions(String exclusions) {
            this.setAddExclusions(exclusions);
        }

        public GavPattern getGavPattern() {
            return this.gavPattern;
        }

        public void setGavPattern(String gavPattern) {
            this.gavPattern = GavPattern.of((String)gavPattern);
        }

        public String replaceVersion(String version) {
            return this.versionPattern == null ? version : this.versionPattern.matcher(version).replaceAll(this.versionReplace);
        }

        public void setVersionReplacement(String versionReplacement) {
            int slashPos = versionReplacement.indexOf(47);
            if (slashPos < 1) {
                throw new IllegalStateException("versionReplacement is expected to contain exactly one slash (/); found " + versionReplacement);
            }
            this.versionPattern = Pattern.compile(versionReplacement.substring(0, slashPos));
            this.versionReplace = versionReplacement.substring(slashPos + 1);
        }

        public String toString() {
            return "BomEntryTransformation [gavPattern=" + this.gavPattern + ", internalExclusions=" + this.internalExclusions + ", versionReplace=" + this.versionReplace + "]";
        }
    }
}

