/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.common.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.l2x6.pom.tuner.model.Gav;
import org.w3c.dom.Element;

public class SyncExpression {
    static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(?<property>[^\\}]*)\\}");
    static final Pattern SYNC_INSTRUCTION_PATTERN = Pattern.compile("\\s*@sync (?<groupId>[^:]*):(?<artifactId>[^:]*):(?<version>[^:]*) (?<method>[^:]+):(?<element>[^ ]+)\\s*");
    private final String groupId;
    private final String artifactId;
    private final String rawVersion;
    private final String element;
    private final String method;
    private final Set<String> requiredProperties;
    private final Element propertyNode;

    public static Optional<SyncExpression> parse(Element propertyNode, String commentText) {
        Matcher m = SYNC_INSTRUCTION_PATTERN.matcher(commentText);
        if (m.matches()) {
            String groupId = m.group("groupId");
            String artifactId = m.group("artifactId");
            String rawVersion = m.group("version");
            String element = m.group("element");
            String method = m.group("method");
            return Optional.of(new SyncExpression(propertyNode, groupId, artifactId, rawVersion, method, element));
        }
        return Optional.empty();
    }

    SyncExpression(Element propertyNode, String groupId, String artifactId, String rawVersion, String method, String element) {
        this.propertyNode = propertyNode;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.rawVersion = rawVersion;
        this.element = element;
        this.method = method;
        Set<String> requiredProperties = SyncExpression.collectRequiredProperties(rawVersion);
        this.requiredProperties = Collections.unmodifiableSet(requiredProperties);
    }

    static Set<String> collectRequiredProperties(String rawVersion) {
        LinkedHashSet<String> requiredProperties = new LinkedHashSet<String>();
        Matcher m = PROPERTY_PATTERN.matcher(rawVersion);
        while (m.find()) {
            requiredProperties.add(m.group("property"));
        }
        return requiredProperties;
    }

    public Set<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public String evaluate(Function<String, String> evaluator, Function<Gav, Model> pomModels) {
        String resolvedVersion = evaluator.apply(this.rawVersion);
        Model sourceModel = pomModels.apply(new Gav(this.groupId, this.artifactId, resolvedVersion));
        return switch (this.method) {
            case "prop" -> {
                Properties sourceProps = sourceModel.getProperties();
                String sourceProperty = this.element;
                yield sourceProps.getProperty(sourceProperty);
            }
            case "dep" -> SyncExpression.dependencyVersion(sourceModel, this.element, this.groupId, this.artifactId, resolvedVersion);
            default -> throw new IllegalStateException("Unexpected method " + this.method + "; expected prop or dep");
        };
    }

    static String dependencyVersion(Model model, String element, String groupId, String artifactId, String resolvedVersion) {
        String[] ga = element.split(":");
        ArrayList<List> depStreams = new ArrayList<List>();
        if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
            depStreams.add(model.getDependencyManagement().getDependencies());
        }
        if (model.getDependencies() != null) {
            depStreams.add(model.getDependencies());
        }
        return depStreams.stream().flatMap(Collection::stream).filter(d -> ga[0].equals(d.getGroupId()) && ga[1].equals(d.getArtifactId()) && d.getVersion() != null).map(Dependency::getVersion).findFirst().orElseThrow(() -> new IllegalStateException("No such dependency " + element + " in " + groupId + ":" + artifactId + ":" + resolvedVersion + ":pom"));
    }

    public Element getPropertyNode() {
        return this.propertyNode;
    }
}

