/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.common;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.l2x6.cq.common.CqCommonUtils;
import org.l2x6.pom.tuner.model.Gav;

public class PomModelCache
implements Function<Gav, Model> {
    private final Map<Gav, Model> items = new HashMap<Gav, Model>();
    private final Path localRepositoryPath;
    private final List<RemoteRepository> remoteRepositories;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private Model self;

    public PomModelCache(Path localRepositoryPath, List<RemoteRepository> remoteRepositories, RepositorySystem repoSystem, RepositorySystemSession repoSession, Model self) {
        this.localRepositoryPath = localRepositoryPath;
        this.remoteRepositories = remoteRepositories;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.self = self;
    }

    @Override
    public Model apply(Gav key) {
        if ("::".equals(key.toString())) {
            return this.self;
        }
        return this.items.computeIfAbsent(key, k -> {
            Path cqPomPath = CqCommonUtils.resolveArtifact(this.localRepositoryPath, k.getGroupId(), k.getArtifactId(), k.getVersion(), "pom", this.remoteRepositories, this.repoSystem, this.repoSession);
            Model model = CqCommonUtils.readPom(cqPomPath, StandardCharsets.UTF_8);
            return model;
        });
    }
}

