/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.common.sync;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.l2x6.cq.common.sync.SyncExpression;
import org.l2x6.pom.tuner.model.Gav;

public class SyncExpressions {
    private final Map<String, SyncExpression> expressions;

    private SyncExpressions(Map<String, SyncExpression> expressions) {
        this.expressions = expressions;
    }

    public void evaluate(Function<String, String> mavenExpressionEvaluator, Function<Gav, Model> pomModels, BiConsumer<SyncExpression, String> newValuesConsumer) {
        LinkedHashMap<String, SyncExpression> expressionsCopy = new LinkedHashMap<String, SyncExpression>(this.expressions);
        while (!expressionsCopy.isEmpty()) {
            int oldSize = expressionsCopy.size();
            Iterator it = expressionsCopy.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                SyncExpression expression = (SyncExpression)entry.getValue();
                Set<String> requiredProps = expression.getRequiredProperties();
                if (!requiredProps.isEmpty()) {
                    if (!expressionsCopy.keySet().stream().noneMatch(requiredProps::contains)) continue;
                }
                String newValue = expression.evaluate(mavenExpressionEvaluator, pomModels);
                newValuesConsumer.accept(expression, newValue);
                it.remove();
            }
            if (oldSize != expressionsCopy.size()) continue;
            throw new IllegalStateException("Cannot resolve @sync properties " + expressionsCopy.entrySet() + ". Is there perhaps a dependency cycle there?");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, SyncExpression> expressions = new LinkedHashMap<String, SyncExpression>();

        public Builder expression(SyncExpression expression) {
            this.expressions.put(expression.getPropertyNode().getLocalName(), expression);
            return this;
        }

        public SyncExpressions build() {
            Map<String, SyncExpression> exprs = Collections.unmodifiableMap(this.expressions);
            this.expressions = null;
            return new SyncExpressions(exprs);
        }
    }
}

