/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.rpkgtests;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.l2x6.rpkgtests.Gas;
import org.l2x6.rpkgtests.Gav;

public abstract class AbstractTestJarsConsumerMojo
extends AbstractMojo {
    @Parameter(property="rpkgtests.testJars")
    protected List<Gav> testJars;
    @Parameter(property="rpkgtests.testJarXmls")
    protected List<Gav> testJarXmls;
    @Parameter(property="rpkgtests.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    protected Path baseDir;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    private Charset charset;

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = this.encoding != null ? Charset.forName(this.encoding) : StandardCharsets.UTF_8;
        }
        return this.charset;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir.toPath();
    }

    protected Set<Gav> getTestJarsOrFail() throws MojoFailureException {
        Set<Gav> result = this.getTestJars();
        if (result.isEmpty()) {
            throw new MojoFailureException("No testJars found. Please check testJars and testJarArtifacts configuration options");
        }
        return result;
    }

    protected Set<Gav> getTestJars() {
        TreeSet<Gav> result = new TreeSet<Gav>();
        if (this.testJars != null && !this.testJars.isEmpty()) {
            result.addAll(this.testJars);
        }
        for (Gav testJarXml : this.testJarXmls) {
            Artifact aetherArtifact = testJarXml.asAetherArtifact("xml", null);
            ArtifactRequest req = new ArtifactRequest().setRepositories(this.repositories).setArtifact(aetherArtifact);
            try {
                ArtifactResult resolutionResult = this.repoSystem.resolveArtifact(this.repoSession, req);
                Path testJarsPath = resolutionResult.getArtifact().getFile().toPath();
                try {
                    BufferedReader reader = Files.newBufferedReader(testJarsPath, this.getCharset());
                    Throwable throwable = null;
                    try {
                        Gas tj = Gas.read(reader, testJarsPath.toString());
                        tj.getGas().stream().map(ga -> ga.toGav(testJarXml.getVersion())).forEach(result::add);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read from " + testJarsPath);
                }
            }
            catch (ArtifactResolutionException e) {
                throw new RuntimeException("Could not resolve " + aetherArtifact, e);
            }
        }
        return result;
    }
}

