/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.rpkgtests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.l2x6.rpkgtests.Gav;

@XmlRootElement(name="testArtifact")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Ga
implements Comparable<Ga> {
    String groupId;
    String artifactId;

    public Ga() {
    }

    public Ga(String groupId, String artifactId) {
        Objects.requireNonNull(groupId, "groupId");
        Objects.requireNonNull(artifactId, "artifactId");
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public Ga withArtifactId(String artifactId) {
        return new Ga(this.groupId, artifactId);
    }

    public Gav toGav(String version) {
        return new Gav(this.groupId, this.artifactId, version);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ga other = (Ga)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ga read(Path pomPath, Charset charset) {
        try (BufferedReader r = Files.newBufferedReader(pomPath, charset);){
            Model pom = new MavenXpp3Reader().read((Reader)r);
            String groupId = pom.getGroupId() != null ? pom.getGroupId() : pom.getParent().getGroupId();
            String artifactId = pom.getArtifactId();
            Ga ga = new Ga(groupId, artifactId);
            return ga;
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException("Could not read or parse " + pomPath, e);
        }
    }

    @Override
    public int compareTo(Ga other) {
        int groupCompare = this.groupId.compareTo(other.groupId);
        if (groupCompare != 0) {
            return groupCompare;
        }
        return this.artifactId.compareTo(other.artifactId);
    }
}

