/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.rpkgtests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Gav
implements Comparable<Gav> {
    String groupId;
    String artifactId;
    String version;

    public Gav() {
    }

    public Gav(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ArtifactCoordinate asArtifactCoordinate(String artifactId, String type, String classifier) {
        DefaultArtifactCoordinate result = new DefaultArtifactCoordinate();
        result.setGroupId(this.groupId);
        result.setArtifactId(artifactId);
        result.setVersion(this.version);
        result.setExtension(type);
        if (classifier != null) {
            result.setClassifier(classifier);
        }
        return result;
    }

    public Gav withArtifactId(String artifactId) {
        return new Gav(this.groupId, artifactId, this.version);
    }

    public DependableCoordinate asDependableCoordinate() {
        DefaultDependableCoordinate result = new DefaultDependableCoordinate();
        result.setGroupId(this.groupId);
        result.setArtifactId(this.artifactId);
        result.setVersion(this.version);
        result.setType("test-jar");
        result.setClassifier("tests");
        return result;
    }

    public Artifact asAetherArtifact(String type, String classifier) {
        return new DefaultArtifact(this.groupId, this.artifactId, classifier, type, this.version);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Gav other = (Gav)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Gav read(Path pomPath, Charset charset) {
        try (BufferedReader r = Files.newBufferedReader(pomPath, charset);){
            Model pom = new MavenXpp3Reader().read((Reader)r);
            String groupId = pom.getGroupId() != null ? pom.getGroupId() : pom.getParent().getGroupId();
            String version = pom.getVersion() != null ? pom.getVersion() : pom.getParent().getVersion();
            String artifactId = pom.getArtifactId();
            Gav gav = new Gav(groupId, artifactId, version);
            return gav;
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException("Could not read or parse " + pomPath, e);
        }
    }

    @Override
    public int compareTo(Gav other) {
        int groupCompare = this.groupId.compareTo(other.groupId);
        if (groupCompare != 0) {
            return groupCompare;
        }
        int artifactCompare = this.artifactId.compareTo(other.artifactId);
        if (artifactCompare != 0) {
            return artifactCompare;
        }
        return this.version.compareTo(other.version);
    }
}

