/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.rpkgtests;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.l2x6.rpkgtests.AbstractTestJarsConsumerMojo;
import org.l2x6.rpkgtests.Gav;

@Mojo(name="create-test-modules", requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateTestModulesMojo
extends AbstractTestJarsConsumerMojo {
    static final String DEFAULT_TEMPLATES_URI_BASE = "classpath:/create-test-modules-templates";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";
    private static final Pattern INDENT_PATTERN = Pattern.compile("<project[^>]*>[\r\n]*([ \t]*)<");
    private static final String MANAGED_MODULES_START = "<!-- START: modules generated by rpkgtests-maven-plugin -->";
    private static final String MANAGED_MODULES_END = "<!-- END: modules generated by rpkgtests-maven-plugin -->";
    @Parameter(property="rpkgtests.testModulesParentDir", defaultValue="${project.basedir}")
    private Path testModulesParentDir;
    @Parameter(defaultValue="classpath:/create-test-modules-templates", required=true, property="rpkgtests.templatesUriBase")
    private String templatesUriBase;
    @Parameter(property="rpkgtests.testModuleArtifactIdReplacers")
    private String testModuleArtifactIdReplacers;
    @Parameter(property="rpkgtests.testModuleDirReplacers")
    private String testModuleDirReplacers;
    @Parameter(property="rpkgtests.clean", defaultValue="true")
    private boolean clean;
    @Parameter(property="rpkgtests.rpkgModulePomXmlPath")
    private Path rpkgModulePomXmlPath;
    @Parameter(property="rpkgtests.rpkgtestsPluginVersion")
    private String rpkgtestsPluginVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Gav> gavs = this.getTestJarsOrFail();
        Path testsParentPath = this.testModulesParentDir.resolve("pom.xml");
        Gav parentPom = Gav.read(testsParentPath, this.getCharset());
        Replacers artifactIdReplacers = Replacers.parse(this.testModuleArtifactIdReplacers);
        Replacers dirReplacers = Replacers.parse(this.testModuleDirReplacers);
        Gav rpkgPom = Gav.read(this.rpkgModulePomXmlPath, this.getCharset());
        if (this.clean) {
            try (Stream<Path> files = Files.list(this.testModulesParentDir);){
                files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> Files.isRegularFile(p.resolve("pom.xml"), new LinkOption[0])).forEach(p -> {
                    try {
                        FileUtils.deleteDirectory((File)p.toFile());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not delete " + p, e);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Could not walk " + this.testModulesParentDir, e);
            }
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setTemplateLoader(GenerateTestModulesMojo.createTemplateLoader(this.baseDir, this.templatesUriBase));
        cfg.setDefaultEncoding(this.getCharset().name());
        cfg.setInterpolationSyntax(22);
        cfg.setTagSyntax(2);
        ArrayList<String> modules = new ArrayList<String>();
        for (Gav gav : gavs) {
            String artifactId = artifactIdReplacers.apply(gav.getArtifactId());
            String dir = dirReplacers.apply(gav.getArtifactId());
            Path moduleDir = this.testModulesParentDir.resolve(dir);
            modules.add(dir);
            try {
                Files.createDirectories(moduleDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create " + moduleDir, (Exception)e);
            }
            Path pomXmlPath = moduleDir.resolve("pom.xml");
            Gav runTestsModule = parentPom.withArtifactId(artifactId);
            TemplateParams model = new TemplateParams(parentPom, "../pom.xml", runTestsModule, rpkgPom, gav, gavs, this.rpkgtestsPluginVersion);
            try {
                GenerateTestModulesMojo.evalTemplate(cfg, "run-tests-module-pom.xml", pomXmlPath, this.getCharset(), model);
            }
            catch (TemplateException | IOException e) {
                throw new RuntimeException(e);
            }
        }
        TemplateParams model = new TemplateParams(parentPom, "../pom.xml", null, rpkgPom, null, gavs, this.rpkgtestsPluginVersion);
        try {
            GenerateTestModulesMojo.evalTemplate(cfg, "rpkg-module-pom.xml", this.rpkgModulePomXmlPath, this.getCharset(), model);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        try {
            String testsParentSource = new String(Files.readAllBytes(testsParentPath), this.getCharset());
            testsParentSource = GenerateTestModulesMojo.addModules(testsParentSource, testsParentPath, modules);
            Files.write(testsParentPath, testsParentSource.getBytes(this.getCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + testsParentPath, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String addModules(String testsParentSource, Path path, List<String> modules) {
        StringBuilder result = new StringBuilder(testsParentSource);
        String eol = result.indexOf("\r") >= 0 ? "\r\n" : "\n";
        Matcher m = INDENT_PATTERN.matcher(result);
        String indent = m.find() ? m.group(1) : "    ";
        int insertPos = result.indexOf(MANAGED_MODULES_START);
        if (insertPos < 0) {
            insertPos = result.indexOf("<modules>");
            if (insertPos < 0) {
                int endProjectPos = result.lastIndexOf("</project>");
                if (endProjectPos < 0) throw new IllegalStateException("Could not find </project> in " + path);
                result.insert(endProjectPos, indent + "<modules>" + eol + indent + indent + MANAGED_MODULES_START + eol + indent + indent + MANAGED_MODULES_END + eol + indent + "</modules>" + eol);
                insertPos = result.indexOf(MANAGED_MODULES_START);
            } else {
                insertPos += "<modules>".length();
                insertPos = GenerateTestModulesMojo.consumeEol(result, insertPos);
                result.insert(insertPos, indent + indent + MANAGED_MODULES_START + eol + indent + indent + MANAGED_MODULES_END + eol);
                insertPos = result.indexOf(MANAGED_MODULES_START);
            }
        }
        int delPos = result.indexOf(MANAGED_MODULES_END);
        result.replace(insertPos += MANAGED_MODULES_START.length(), delPos, eol + indent + indent);
        for (int i = modules.size() - 1; i >= 0; --i) {
            String module = modules.get(i);
            result.insert(insertPos, eol + indent + indent + "<module>" + module + "</module>");
        }
        return result.toString();
    }

    private static int consumeEol(StringBuilder result, int insertPos) {
        block3: while (insertPos < result.length()) {
            switch (result.charAt(insertPos)) {
                case '\n': 
                case '\r': {
                    ++insertPos;
                    continue block3;
                }
            }
            return insertPos;
        }
        return insertPos;
    }

    static TemplateLoader createTemplateLoader(Path basedir, String templatesUriBase) {
        ClassTemplateLoader defaultLoader = new ClassTemplateLoader(GenerateTestModulesMojo.class, DEFAULT_TEMPLATES_URI_BASE.substring(CLASSPATH_PREFIX.length()));
        if (DEFAULT_TEMPLATES_URI_BASE.equals(templatesUriBase)) {
            return defaultLoader;
        }
        if (templatesUriBase.startsWith(CLASSPATH_PREFIX)) {
            return new MultiTemplateLoader(new TemplateLoader[]{new ClassTemplateLoader(GenerateTestModulesMojo.class, templatesUriBase.substring(CLASSPATH_PREFIX.length())), defaultLoader});
        }
        if (templatesUriBase.startsWith(FILE_PREFIX)) {
            try {
                return new MultiTemplateLoader(new TemplateLoader[]{new FileTemplateLoader(basedir.resolve(templatesUriBase.substring(FILE_PREFIX.length())).toFile()), defaultLoader});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException(String.format("Cannot handle templatesUriBase '%s'; only value starting with '%s' or '%s' are supported", templatesUriBase, CLASSPATH_PREFIX, FILE_PREFIX));
    }

    public void setTestModulesParentDir(File testModulesParentDir) {
        this.testModulesParentDir = testModulesParentDir.toPath();
    }

    public void setRpkgModulePomXmlPath(File rpkgModulePomXmlPath) {
        this.rpkgModulePomXmlPath = rpkgModulePomXmlPath.toPath();
    }

    static void evalTemplate(Configuration cfg, String templateUri, Path dest, Charset charset, TemplateParams model) throws IOException, TemplateException {
        Template template = cfg.getTemplate(templateUri);
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        try (BufferedWriter out = Files.newBufferedWriter(dest, new OpenOption[0]);){
            template.process((Object)model, (Writer)out);
        }
    }

    static class Replacers {
        private final List<Replacer> replacers;

        public static Replacers parse(String replacers) {
            if (replacers == null) {
                return new Replacers(Collections.emptyList());
            }
            return new Replacers(Arrays.stream(replacers.split(",\\s")).map(Replacer::parse).collect(Collectors.toList()));
        }

        Replacers(List<Replacer> replacers) {
            this.replacers = replacers;
        }

        public String apply(String input) {
            for (Replacer replacer : this.replacers) {
                input = replacer.apply(input);
            }
            return input;
        }

        static class Replacer {
            private final Pattern pattern;
            private final String replacement;

            public static Replacer parse(String rawReplacer) {
                if (!rawReplacer.startsWith("/")) {
                    throw new IllegalArgumentException("Replacer must start with a slash; found " + rawReplacer);
                }
                if (!rawReplacer.endsWith("/")) {
                    throw new IllegalArgumentException("Replacer must end with a slash; found " + rawReplacer);
                }
                String trimmed = rawReplacer.substring(1, rawReplacer.length() - 1);
                int slashPos = trimmed.indexOf(47);
                if (slashPos < 0) {
                    throw new IllegalArgumentException("Replacer must contain three slashes; found " + rawReplacer);
                }
                return new Replacer(Pattern.compile(trimmed.substring(0, slashPos)), trimmed.substring(slashPos + 1));
            }

            Replacer(Pattern pattern, String replacement) {
                this.pattern = pattern;
                this.replacement = replacement;
            }

            public String apply(String artifactId) {
                return this.pattern.matcher(artifactId).replaceAll(this.replacement);
            }
        }
    }

    public static class TemplateParams {
        final Gav parent;
        final String parentRelativePath;
        final Gav runTestsModule;
        final Gav rpkgModule;
        final Gav gav;
        final Set<Gav> gavs;
        final String rpkgtestsPluginVersion;

        public TemplateParams(Gav parent, String parentRelativePath, Gav runTestsModule, Gav rpkgModule, Gav gav, Set<Gav> gavs, String rpkgtestsPluginVersion) {
            this.parent = parent;
            this.parentRelativePath = parentRelativePath;
            this.runTestsModule = runTestsModule;
            this.rpkgModule = rpkgModule;
            this.gav = gav;
            this.gavs = gavs;
            this.rpkgtestsPluginVersion = rpkgtestsPluginVersion;
        }

        public Gav getParent() {
            return this.parent;
        }

        public String getParentRelativePath() {
            return this.parentRelativePath;
        }

        public Gav getRunTestsModule() {
            return this.runTestsModule;
        }

        public Gav getRpkgModule() {
            return this.rpkgModule;
        }

        public Gav getTestJar() {
            return this.gav;
        }

        public Set<Gav> getTestJars() {
            return this.gavs;
        }

        public String getRpkgtestsPluginVersion() {
            return this.rpkgtestsPluginVersion;
        }
    }
}

