/*
 * Decompiled with CFR 0.152.
 */
package org.l6n.sendlog;

import android.util.Log;
import org.l6n.sendlog.library.SendLogActivityBase;

public class SendLog
extends SendLogActivityBase {
    private static final String TAG = "SendLog";
    static final String FORMAT_SEPARATOR = "|";
    private String mFormatString;
    private String mDestination;
    private String mSender;
    private String mExtra;
    private String mSubject;

    public String getSubject() {
        return this.mSubject;
    }

    protected String getLogFormat() {
        return this.mFormatString;
    }

    protected void setLogFormat(int pFormat) {
        super.setLogFormat(pFormat);
        this.mFormatString = super.getLogFormat();
    }

    protected String getSenderApp() {
        return this.mSender;
    }

    public String[] getCommands() {
        StringBuilder sb = new StringBuilder();
        sb.append("logcat -v ");
        sb.append(this.mFormatString);
        sb.append(" -d ");
        if (this.mExtra != null) {
            sb.append(this.mExtra);
        }
        String logcatCommand = sb.toString();
        return new String[]{"top -n 1", logcatCommand};
    }

    protected String getDestinationAddress() {
        return this.mDestination;
    }

    protected void onResume() {
        int i;
        Log.v((String)TAG, (String)"onResume");
        String type = this.getIntent().getType();
        int n = i = type == null ? -1 : type.indexOf(FORMAT_SEPARATOR);
        if (i == -1) {
            this.mDestination = type;
        } else {
            try {
                this.setLogFormat(Integer.parseInt(type.substring(0, i)));
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Error parsing format: ", (Throwable)e);
            }
            type = type.substring(i + 1);
            i = type.indexOf(FORMAT_SEPARATOR);
            if (i == -1) {
                this.mDestination = type;
            } else {
                this.mSender = type.substring(0, i);
                this.mDestination = type.substring(i + 1);
            }
        }
        Log.d((String)TAG, (String)("mFormat=" + this.mFormatString + " mSender=" + this.mSender + " mDestination=" + this.mDestination));
        this.mExtra = this.getIntent().getStringExtra("filter");
        this.mSubject = this.getIntent().getStringExtra("android.intent.extra.SUBJECT");
        Log.d((String)TAG, (String)("mExtra=" + this.mExtra + " mSubject=" + this.mSubject));
        super.onResume();
    }

    public boolean hasReadLogsPermission() {
        boolean hasPermission = this.getPackageManager().checkPermission("android.permission.READ_LOGS", this.getPackageName()) == 0;
        Log.d((String)TAG, (String)("Has READ_LOGS permission: " + hasPermission));
        return hasPermission;
    }
}

