/*
 * Decompiled with CFR 0.152.
 */
package org.l6n.sendlog.library;

import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.l6n.sendlog.library.ISendLog;

public class LogcatThread
implements Runnable {
    private static final String TAG = "LogcatThread";
    private static final int BUFFER_SIZE = 8000;
    private ISendLog mSendLog;

    public LogcatThread(ISendLog pSendLog) {
        Log.d((String)TAG, (String)"LogcatThread()");
        this.mSendLog = pSendLog;
    }

    public void run() {
        try {
            Process process;
            String state = Environment.getExternalStorageState();
            File file = "mounted".equals(state) ? new File(Environment.getExternalStorageDirectory(), "SendLog.txt") : new File(this.mSendLog.getNonSdCardFolder(), "SendLog.txt");
            boolean hasReadLogsPermission = this.mSendLog.hasReadLogsPermission();
            try {
                process = this.getProcess(hasReadLogsPermission ? "sh" : "su");
            }
            catch (IOException e) {
                if (!hasReadLogsPermission) {
                    throw new IOException(this.mSendLog.getNoPermissionMessage());
                }
                throw e;
            }
            boolean success = this.runProcess(file, process);
            if (!success) {
                if (!hasReadLogsPermission) {
                    throw new IOException(this.mSendLog.getNoPermissionMessage());
                }
                throw new IOException(this.mSendLog.getBadExitCodeMessage());
            }
            this.mSendLog.finished(file);
            Log.d((String)TAG, (String)"Finished");
        }
        catch (Exception e) {
            this.mSendLog.error(e);
        }
    }

    private boolean runProcess(File pFile, final Process pProcess) throws IOException, InterruptedException {
        final BufferedWriter fileStream = new BufferedWriter(new FileWriter(pFile), 8000);
        Thread readerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(pProcess.getInputStream()), 8000);
                    while ((line = reader.readLine()) != null) {
                        fileStream.write(line);
                        fileStream.newLine();
                    }
                }
                catch (Exception e) {
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
        };
        readerThread.start();
        final BufferedWriter processWriteStream = new BufferedWriter(new OutputStreamWriter(pProcess.getOutputStream()));
        Thread writerThread = new Thread(){

            public void run() {
                try {
                    for (String command : LogcatThread.this.mSendLog.getCommands()) {
                        processWriteStream.write(command);
                        processWriteStream.newLine();
                        processWriteStream.write("echo");
                        processWriteStream.newLine();
                        processWriteStream.write("echo");
                        processWriteStream.newLine();
                    }
                    processWriteStream.write("exit");
                    processWriteStream.newLine();
                    processWriteStream.close();
                }
                catch (IOException e) {
                    Log.d((String)LogcatThread.TAG, (String)("Error writing to process: " + e.getMessage()));
                }
            }
        };
        writerThread.start();
        pProcess.waitFor();
        readerThread.join();
        writerThread.join();
        pProcess.destroy();
        fileStream.write(this.mSendLog.getFooter());
        fileStream.newLine();
        fileStream.close();
        return pProcess.exitValue() == 0;
    }

    private Process getProcess(String pShell) throws IOException {
        return new ProcessBuilder(new String[0]).command(pShell).redirectErrorStream(true).start();
    }
}

