/*
 * Decompiled with CFR 0.152.
 */
package org.l6n.sendlog.library;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.l6n.sendlog.library.ISendLog;
import org.l6n.sendlog.library.LogcatThread;
import org.l6n.sendlog.library.R;

public abstract class SendLogActivityBase
extends Activity
implements ISendLog {
    private static final String TAG = "SendLogActivityBase";
    private static final int BUFFER_SIZE = 8000;
    public static final String FORMAT_PREFERENCE = "FORMAT";
    public static final int FORMAT_DEFAULT = 5;
    private int mFormat = 5;
    private ProgressDialog mProgressDialog;
    private boolean mFinishLater = false;
    private final DialogInterface.OnClickListener mFormatDialogClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)SendLogActivityBase.this);
            if (which == -1) {
                SendLogActivityBase.this.setLogFormat(sp.getInt(SendLogActivityBase.FORMAT_PREFERENCE, 5));
                Log.d((String)SendLogActivityBase.TAG, (String)("Send the email with format " + SendLogActivityBase.this.mFormat));
                SendLogActivityBase.this.sendLog();
                SendLogActivityBase.this.mFinishLater = true;
            }
            if (which >= 0) {
                sp.edit().putInt(SendLogActivityBase.FORMAT_PREFERENCE, which).commit();
            }
        }
    };
    private final DialogInterface.OnDismissListener mFormatDialogDismissListener = new DialogInterface.OnDismissListener(){

        public void onDismiss(DialogInterface dialog) {
            Log.d((String)SendLogActivityBase.TAG, (String)("onDismiss mFinishLater=" + SendLogActivityBase.this.mFinishLater));
            if (!SendLogActivityBase.this.mFinishLater) {
                Log.d((String)SendLogActivityBase.TAG, (String)"call finish()");
                SendLogActivityBase.this.finish();
            }
        }
    };

    protected String getSenderApp() {
        return null;
    }

    protected abstract String getDestinationAddress();

    protected String getSubject() {
        return this.getString(R.string.app_name);
    }

    protected String getLogFormat() {
        String[] formats = this.getResources().getStringArray(R.array.format_list);
        if (this.mFormat >= 0 && this.mFormat < formats.length) {
            return formats[this.mFormat];
        }
        return formats[5];
    }

    protected void setLogFormat(int pFormat) {
        this.mFormat = pFormat;
    }

    protected String getMessageText(File pZipFile, PackageManager pPackageManager) {
        String version = "";
        try {
            PackageInfo pi = pPackageManager.getPackageInfo(this.getPackageName(), 0);
            version = " " + pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Version name not found", (Throwable)e);
        }
        return this.getString(R.string.email_text, new Object[]{version, Build.MODEL, Build.DEVICE, Build.VERSION.RELEASE, Build.ID, pZipFile.getName(), (pZipFile.length() + 512L) / 1024L});
    }

    public String[] getCommands() {
        String logcatCommand = "logcat -v " + this.getLogFormat() + " -d ";
        return new String[]{"top -n 1", logcatCommand};
    }

    public String getFooter() {
        return this.getString(R.string.footer);
    }

    public boolean hasReadLogsPermission() {
        return true;
    }

    public String getNoPermissionMessage() {
        return this.getString(R.string.no_permission);
    }

    public String getBadExitCodeMessage() {
        return this.getString(R.string.bad_exit_code);
    }

    public File getNonSdCardFolder() {
        return this.getFilesDir();
    }

    protected void onResume() {
        Log.v((String)TAG, (String)("onResume mFinishLater=" + this.mFinishLater));
        super.onResume();
        if (this.mFinishLater) {
            return;
        }
        this.mFinishLater = false;
        String format = this.getLogFormat();
        if (TextUtils.isEmpty((CharSequence)format)) {
            AlertDialog ad = new AlertDialog.Builder((Context)this).setTitle(R.string.format_dialog_title).setSingleChoiceItems(R.array.format_list, this.mFormat, this.mFormatDialogClickListener).setPositiveButton(R.string.format_dialog_send, this.mFormatDialogClickListener).setNegativeButton(R.string.format_dialog_cancel, this.mFormatDialogClickListener).create();
            ad.setOnDismissListener(this.mFormatDialogDismissListener);
            ad.show();
        } else {
            Log.d((String)TAG, (String)("Send the email with format " + format));
            this.sendLog();
            this.mFinishLater = true;
        }
    }

    protected void onDestroy() {
        this.mFinishLater = false;
        super.onDestroy();
    }

    public void finished(File pFile) {
        String destination;
        Log.d((String)TAG, (String)("finished(" + pFile + ")"));
        File zipFile = this.createZipFile(pFile);
        PackageManager pm = this.getPackageManager();
        String emailText = this.getMessageText(zipFile, pm);
        this.mProgressDialog.dismiss();
        Intent sendIntent = new Intent("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.SUBJECT", this.getSubject());
        sendIntent.setType("message/rfc822");
        sendIntent.putExtra("android.intent.extra.TEXT", emailText);
        sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)zipFile));
        boolean chooser = true;
        String sender = this.getSenderApp();
        if (sender != null) {
            List ri = pm.queryIntentActivities(sendIntent, 65536);
            for (ResolveInfo info : ri) {
                if (!sender.equals(info.activityInfo.name)) continue;
                sendIntent.setComponent(new ComponentName(info.activityInfo.applicationInfo.packageName, info.activityInfo.name));
                chooser = false;
                break;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(destination = this.getDestinationAddress()))) {
            sendIntent.putExtra("android.intent.extra.EMAIL", new String[]{destination});
        }
        if (chooser) {
            this.startActivity(Intent.createChooser((Intent)sendIntent, (CharSequence)this.getString(R.string.app_name)));
        } else {
            this.startActivity(sendIntent);
        }
        Log.d((String)TAG, (String)"call finish()");
        this.finish();
    }

    public void error(final Exception e) {
        Log.e((String)TAG, (String)"Error", (Throwable)e);
        this.mProgressDialog.dismiss();
        this.runOnUiThread(new Runnable(){

            public void run() {
                new AlertDialog.Builder((Context)SendLogActivityBase.this).setMessage((CharSequence)e.getMessage()).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SendLogActivityBase.this.finish();
                    }
                }).show();
            }
        });
    }

    private File createZipFile(File pFile) {
        try {
            int length;
            File file = new File(pFile.getAbsolutePath().replace(".txt", ".zip"));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry entry = new ZipEntry(pFile.getName());
            zipOutputStream.putNextEntry(entry);
            FileInputStream fileInputStream = new FileInputStream(pFile);
            byte[] buffer = new byte[8000];
            while ((length = fileInputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, length);
            }
            zipOutputStream.close();
            fileInputStream.close();
            return file;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error creating zip file", (Throwable)e);
            return pFile;
        }
    }

    private void sendLog() {
        String format = this.getLogFormat();
        Log.d((String)TAG, (String)("sendLog(" + format + ")"));
        this.mProgressDialog = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(R.string.progress_dialog_text));
        LogcatThread lt = new LogcatThread(this);
        Thread t = new Thread(lt);
        t.start();
    }
}

