/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.app.authentication.openid;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ladsn.security.app.authentication.openid.OpenIdAuthenticationToken;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class OpenIdAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private String openIdParameter = "openId";
    private String providerIdParameter = "providerId";
    private boolean postOnly = true;

    public OpenIdAuthenticationFilter() {
        super((RequestMatcher)new AntPathRequestMatcher("/authentication/openid", "POST"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String openid = this.obtainOpenId(request);
        String providerId = this.obtainProviderId(request);
        if (openid == null) {
            openid = "";
        }
        if (providerId == null) {
            providerId = "";
        }
        openid = openid.trim();
        providerId = providerId.trim();
        OpenIdAuthenticationToken authRequest = new OpenIdAuthenticationToken(openid, providerId);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected String obtainOpenId(HttpServletRequest request) {
        return request.getParameter(this.openIdParameter);
    }

    protected String obtainProviderId(HttpServletRequest request) {
        return request.getParameter(this.providerIdParameter);
    }

    protected void setDetails(HttpServletRequest request, OpenIdAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setOpenIdParameter(String openIdParameter) {
        Assert.hasText((String)openIdParameter, (String)"Username parameter must not be empty or null");
        this.openIdParameter = openIdParameter;
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public final String getOpenIdParameter() {
        return this.openIdParameter;
    }

    public String getProviderIdParameter() {
        return this.providerIdParameter;
    }

    public void setProviderIdParameter(String providerIdParameter) {
        this.providerIdParameter = providerIdParameter;
    }
}

