/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.app.social;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.ladsn.security.app.AppSecretException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.WebRequest;

@Component
public class AppSingUpUtils {
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private UsersConnectionRepository usersConnectionRepository;
    @Autowired
    private ConnectionFactoryLocator connectionFactoryLocator;

    public void saveConnectionData(WebRequest request, ConnectionData connectionData) {
        this.redisTemplate.opsForValue().set((Object)this.getKey(request), (Object)connectionData, 10L, TimeUnit.MINUTES);
    }

    public void doPostSignUp(WebRequest request, String userId) {
        String key = this.getKey(request);
        if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
            throw new AppSecretException("\u65e0\u6cd5\u627e\u5230\u7f13\u5b58\u7684\u7528\u6237\u793e\u4ea4\u8d26\u53f7\u4fe1\u606f");
        }
        ConnectionData connectionData = (ConnectionData)this.redisTemplate.opsForValue().get((Object)key);
        Connection connection = this.connectionFactoryLocator.getConnectionFactory(connectionData.getProviderId()).createConnection(connectionData);
        this.usersConnectionRepository.createConnectionRepository(userId).addConnection(connection);
        this.redisTemplate.delete((Object)key);
    }

    private String getKey(WebRequest request) {
        String deviceId = request.getHeader("deviceId");
        if (StringUtils.isBlank((String)deviceId)) {
            throw new AppSecretException("\u8bbe\u5907id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return "ladsn:security:social.connect." + deviceId;
    }
}

