/*
 * Decompiled with CFR 0.152.
 */
package org.ladsn.security.app.validate.code.impl;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.ladsn.security.core.validate.code.ValidateCode;
import org.ladsn.security.core.validate.code.ValidateCodeException;
import org.ladsn.security.core.validate.code.ValidateCodeRepository;
import org.ladsn.security.core.validate.code.ValidateCodeType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;

@Component
public class RedisValidateCodeRepository
implements ValidateCodeRepository {
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    public void save(ServletWebRequest request, ValidateCode code, ValidateCodeType type) {
        this.redisTemplate.opsForValue().set((Object)this.buildKey(request, type), (Object)code, 30L, TimeUnit.MINUTES);
    }

    public ValidateCode get(ServletWebRequest request, ValidateCodeType type) {
        Object value = this.redisTemplate.opsForValue().get((Object)this.buildKey(request, type));
        if (value == null) {
            return null;
        }
        return (ValidateCode)value;
    }

    public void remove(ServletWebRequest request, ValidateCodeType type) {
        this.redisTemplate.delete((Object)this.buildKey(request, type));
    }

    private String buildKey(ServletWebRequest request, ValidateCodeType type) {
        String deviceId = request.getHeader("deviceId");
        if (StringUtils.isBlank((String)deviceId)) {
            throw new ValidateCodeException("\u8bf7\u5728\u8bf7\u6c42\u5934\u4e2d\u643a\u5e26deviceId\u53c2\u6570");
        }
        return "code:" + type.toString().toLowerCase() + ":" + deviceId;
    }
}

