/*
 * Decompiled with CFR 0.152.
 */
package org.lance.namespace.client.apache.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.lance.namespace.client.apache.ApiClient;
import org.lance.namespace.client.apache.ApiException;
import org.lance.namespace.client.apache.BaseApi;
import org.lance.namespace.client.apache.Configuration;
import org.lance.namespace.client.apache.Pair;
import org.lance.namespace.model.CreateTableIndexRequest;
import org.lance.namespace.model.CreateTableIndexResponse;
import org.lance.namespace.model.DescribeTableIndexStatsRequest;
import org.lance.namespace.model.DescribeTableIndexStatsResponse;
import org.lance.namespace.model.DropTableIndexRequest;
import org.lance.namespace.model.DropTableIndexResponse;
import org.lance.namespace.model.ListTableIndicesRequest;
import org.lance.namespace.model.ListTableIndicesResponse;

public class IndexApi
extends BaseApi {
    public IndexApi() {
        super(Configuration.getDefaultApiClient());
    }

    public IndexApi(ApiClient apiClient) {
        super(apiClient);
    }

    public CreateTableIndexResponse createTableIndex(String id, CreateTableIndexRequest createTableIndexRequest, String delimiter) throws ApiException {
        return this.createTableIndex(id, createTableIndexRequest, delimiter, Collections.emptyMap());
    }

    public CreateTableIndexResponse createTableIndex(String id, CreateTableIndexRequest createTableIndexRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        CreateTableIndexRequest localVarPostBody = createTableIndexRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling createTableIndex");
        }
        if (createTableIndexRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createTableIndexRequest' when calling createTableIndex");
        }
        String localVarPath = "/v1/table/{id}/create_index".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<CreateTableIndexResponse> localVarReturnType = new TypeReference<CreateTableIndexResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DescribeTableIndexStatsResponse describeTableIndexStats(String id, String indexName, DescribeTableIndexStatsRequest describeTableIndexStatsRequest, String delimiter) throws ApiException {
        return this.describeTableIndexStats(id, indexName, describeTableIndexStatsRequest, delimiter, Collections.emptyMap());
    }

    public DescribeTableIndexStatsResponse describeTableIndexStats(String id, String indexName, DescribeTableIndexStatsRequest describeTableIndexStatsRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DescribeTableIndexStatsRequest localVarPostBody = describeTableIndexStatsRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling describeTableIndexStats");
        }
        if (indexName == null) {
            throw new ApiException(400, "Missing the required parameter 'indexName' when calling describeTableIndexStats");
        }
        if (describeTableIndexStatsRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'describeTableIndexStatsRequest' when calling describeTableIndexStats");
        }
        String localVarPath = "/v1/table/{id}/index/{index_name}/stats".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{index_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(indexName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<DescribeTableIndexStatsResponse> localVarReturnType = new TypeReference<DescribeTableIndexStatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DropTableIndexResponse dropTableIndex(String id, String indexName, DropTableIndexRequest dropTableIndexRequest, String delimiter) throws ApiException {
        return this.dropTableIndex(id, indexName, dropTableIndexRequest, delimiter, Collections.emptyMap());
    }

    public DropTableIndexResponse dropTableIndex(String id, String indexName, DropTableIndexRequest dropTableIndexRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DropTableIndexRequest localVarPostBody = dropTableIndexRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling dropTableIndex");
        }
        if (indexName == null) {
            throw new ApiException(400, "Missing the required parameter 'indexName' when calling dropTableIndex");
        }
        if (dropTableIndexRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'dropTableIndexRequest' when calling dropTableIndex");
        }
        String localVarPath = "/v1/table/{id}/index/{index_name}/drop".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{index_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(indexName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<DropTableIndexResponse> localVarReturnType = new TypeReference<DropTableIndexResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListTableIndicesResponse listTableIndices(String id, ListTableIndicesRequest listTableIndicesRequest, String delimiter) throws ApiException {
        return this.listTableIndices(id, listTableIndicesRequest, delimiter, Collections.emptyMap());
    }

    public ListTableIndicesResponse listTableIndices(String id, ListTableIndicesRequest listTableIndicesRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        ListTableIndicesRequest localVarPostBody = listTableIndicesRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling listTableIndices");
        }
        if (listTableIndicesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'listTableIndicesRequest' when calling listTableIndices");
        }
        String localVarPath = "/v1/table/{id}/index/list".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ListTableIndicesResponse> localVarReturnType = new TypeReference<ListTableIndicesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

