/*
 * Decompiled with CFR 0.152.
 */
package org.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lance.namespace.model.FtsQuery;

@JsonPropertyOrder(value={"positive", "negative", "negative_boost"})
public class BoostQuery {
    public static final String JSON_PROPERTY_POSITIVE = "positive";
    @Nonnull
    private FtsQuery positive;
    public static final String JSON_PROPERTY_NEGATIVE = "negative";
    @Nonnull
    private FtsQuery negative;
    public static final String JSON_PROPERTY_NEGATIVE_BOOST = "negative_boost";
    @Nullable
    private Float negativeBoost = Float.valueOf(0.5f);

    public BoostQuery positive(@Nonnull FtsQuery positive) {
        this.positive = positive;
        return this;
    }

    @Nonnull
    @JsonProperty(value="positive")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FtsQuery getPositive() {
        return this.positive;
    }

    @JsonProperty(value="positive")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPositive(@Nonnull FtsQuery positive) {
        this.positive = positive;
    }

    public BoostQuery negative(@Nonnull FtsQuery negative) {
        this.negative = negative;
        return this;
    }

    @Nonnull
    @JsonProperty(value="negative")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FtsQuery getNegative() {
        return this.negative;
    }

    @JsonProperty(value="negative")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNegative(@Nonnull FtsQuery negative) {
        this.negative = negative;
    }

    public BoostQuery negativeBoost(@Nullable Float negativeBoost) {
        this.negativeBoost = negativeBoost;
        return this;
    }

    @Nullable
    @JsonProperty(value="negative_boost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getNegativeBoost() {
        return this.negativeBoost;
    }

    @JsonProperty(value="negative_boost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNegativeBoost(@Nullable Float negativeBoost) {
        this.negativeBoost = negativeBoost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostQuery boostQuery = (BoostQuery)o;
        return Objects.equals(this.positive, boostQuery.positive) && Objects.equals(this.negative, boostQuery.negative) && Objects.equals(this.negativeBoost, boostQuery.negativeBoost);
    }

    public int hashCode() {
        return Objects.hash(this.positive, this.negative, this.negativeBoost);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BoostQuery {\n");
        sb.append("    positive: ").append(this.toIndentedString(this.positive)).append("\n");
        sb.append("    negative: ").append(this.toIndentedString(this.negative)).append("\n");
        sb.append("    negativeBoost: ").append(this.toIndentedString(this.negativeBoost)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPositive() != null) {
            joiner.add(this.getPositive().toUrlQueryString(prefix + JSON_PROPERTY_POSITIVE + suffix));
        }
        if (this.getNegative() != null) {
            joiner.add(this.getNegative().toUrlQueryString(prefix + JSON_PROPERTY_NEGATIVE + suffix));
        }
        if (this.getNegativeBoost() != null) {
            try {
                joiner.add(String.format("%snegative_boost%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNegativeBoost()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

