/*
 * Decompiled with CFR 0.152.
 */
package org.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lance.namespace.model.TableVersion;

@JsonPropertyOrder(value={"versions", "page_token"})
public class ListTableVersionsResponse {
    public static final String JSON_PROPERTY_VERSIONS = "versions";
    @Nonnull
    private List<TableVersion> versions = new ArrayList<TableVersion>();
    public static final String JSON_PROPERTY_PAGE_TOKEN = "page_token";
    @Nullable
    private String pageToken;

    public ListTableVersionsResponse versions(@Nonnull List<TableVersion> versions) {
        this.versions = versions;
        return this;
    }

    public ListTableVersionsResponse addVersionsItem(TableVersion versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<TableVersion>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="versions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TableVersion> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersions(@Nonnull List<TableVersion> versions) {
        this.versions = versions;
    }

    public ListTableVersionsResponse pageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTableVersionsResponse listTableVersionsResponse = (ListTableVersionsResponse)o;
        return Objects.equals(this.versions, listTableVersionsResponse.versions) && Objects.equals(this.pageToken, listTableVersionsResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.versions, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTableVersionsResponse {\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVersions() != null) {
            for (int i = 0; i < this.getVersions().size(); ++i) {
                if (this.getVersions().get(i) == null) continue;
                joiner.add(this.getVersions().get(i).toUrlQueryString(String.format("%sversions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getPageToken() != null) {
            try {
                joiner.add(String.format("%spage_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageToken()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

