/*
 * Decompiled with CFR 0.152.
 */
package org.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"tables", "page_token"})
public class ListTablesResponse {
    public static final String JSON_PROPERTY_TABLES = "tables";
    @Nonnull
    private Set<String> tables = new LinkedHashSet<String>();
    public static final String JSON_PROPERTY_PAGE_TOKEN = "page_token";
    @Nullable
    private String pageToken;

    public ListTablesResponse tables(@Nonnull Set<String> tables) {
        this.tables = tables;
        return this;
    }

    public ListTablesResponse addTablesItem(String tablesItem) {
        if (this.tables == null) {
            this.tables = new LinkedHashSet<String>();
        }
        this.tables.add(tablesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="tables")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Set<String> getTables() {
        return this.tables;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="tables")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTables(@Nonnull Set<String> tables) {
        this.tables = tables;
    }

    public ListTablesResponse pageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTablesResponse listTablesResponse = (ListTablesResponse)o;
        return Objects.equals(this.tables, listTablesResponse.tables) && Objects.equals(this.pageToken, listTablesResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.tables, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTablesResponse {\n");
        sb.append("    tables: ").append(this.toIndentedString(this.tables)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTables() != null) {
            int i = 0;
            for (String _item : this.getTables()) {
                try {
                    joiner.add(String.format("%stables%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        if (this.getPageToken() != null) {
            try {
                joiner.add(String.format("%spage_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageToken()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

