/*
 * Decompiled with CFR 0.152.
 */
package org.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lance.namespace.model.Operator;

@JsonPropertyOrder(value={"boost", "column", "fuzziness", "max_expansions", "operator", "prefix_length", "terms"})
public class MatchQuery {
    public static final String JSON_PROPERTY_BOOST = "boost";
    @Nullable
    private Float boost;
    public static final String JSON_PROPERTY_COLUMN = "column";
    @Nonnull
    private String column;
    public static final String JSON_PROPERTY_FUZZINESS = "fuzziness";
    @Nullable
    private Integer fuzziness;
    public static final String JSON_PROPERTY_MAX_EXPANSIONS = "max_expansions";
    @Nullable
    private Integer maxExpansions;
    public static final String JSON_PROPERTY_OPERATOR = "operator";
    @Nullable
    private Operator operator;
    public static final String JSON_PROPERTY_PREFIX_LENGTH = "prefix_length";
    @Nullable
    private Integer prefixLength;
    public static final String JSON_PROPERTY_TERMS = "terms";
    @Nonnull
    private String terms;

    public MatchQuery boost(@Nullable Float boost) {
        this.boost = boost;
        return this;
    }

    @Nullable
    @JsonProperty(value="boost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getBoost() {
        return this.boost;
    }

    @JsonProperty(value="boost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBoost(@Nullable Float boost) {
        this.boost = boost;
    }

    public MatchQuery column(@Nonnull String column) {
        this.column = column;
        return this;
    }

    @Nonnull
    @JsonProperty(value="column")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getColumn() {
        return this.column;
    }

    @JsonProperty(value="column")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setColumn(@Nonnull String column) {
        this.column = column;
    }

    public MatchQuery fuzziness(@Nullable Integer fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    @Nullable
    @JsonProperty(value="fuzziness")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFuzziness() {
        return this.fuzziness;
    }

    @JsonProperty(value="fuzziness")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFuzziness(@Nullable Integer fuzziness) {
        this.fuzziness = fuzziness;
    }

    public MatchQuery maxExpansions(@Nullable Integer maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    @Nullable
    @JsonProperty(value="max_expansions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxExpansions() {
        return this.maxExpansions;
    }

    @JsonProperty(value="max_expansions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxExpansions(@Nullable Integer maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public MatchQuery operator(@Nullable Operator operator) {
        this.operator = operator;
        return this;
    }

    @Nullable
    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperator(@Nullable Operator operator) {
        this.operator = operator;
    }

    public MatchQuery prefixLength(@Nullable Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    @Nullable
    @JsonProperty(value="prefix_length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    @JsonProperty(value="prefix_length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrefixLength(@Nullable Integer prefixLength) {
        this.prefixLength = prefixLength;
    }

    public MatchQuery terms(@Nonnull String terms) {
        this.terms = terms;
        return this;
    }

    @Nonnull
    @JsonProperty(value="terms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTerms() {
        return this.terms;
    }

    @JsonProperty(value="terms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTerms(@Nonnull String terms) {
        this.terms = terms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchQuery matchQuery = (MatchQuery)o;
        return Objects.equals(this.boost, matchQuery.boost) && Objects.equals(this.column, matchQuery.column) && Objects.equals(this.fuzziness, matchQuery.fuzziness) && Objects.equals(this.maxExpansions, matchQuery.maxExpansions) && Objects.equals((Object)this.operator, (Object)matchQuery.operator) && Objects.equals(this.prefixLength, matchQuery.prefixLength) && Objects.equals(this.terms, matchQuery.terms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.boost, this.column, this.fuzziness, this.maxExpansions, this.operator, this.prefixLength, this.terms});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchQuery {\n");
        sb.append("    boost: ").append(this.toIndentedString(this.boost)).append("\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    fuzziness: ").append(this.toIndentedString(this.fuzziness)).append("\n");
        sb.append("    maxExpansions: ").append(this.toIndentedString(this.maxExpansions)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    prefixLength: ").append(this.toIndentedString(this.prefixLength)).append("\n");
        sb.append("    terms: ").append(this.toIndentedString(this.terms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getBoost() != null) {
            try {
                joiner.add(String.format("%sboost%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBoost()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getColumn() != null) {
            try {
                joiner.add(String.format("%scolumn%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getColumn()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFuzziness() != null) {
            try {
                joiner.add(String.format("%sfuzziness%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFuzziness()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMaxExpansions() != null) {
            try {
                joiner.add(String.format("%smax_expansions%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMaxExpansions()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOperator() != null) {
            try {
                joiner.add(String.format("%soperator%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOperator()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPrefixLength() != null) {
            try {
                joiner.add(String.format("%sprefix_length%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrefixLength()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTerms() != null) {
            try {
                joiner.add(String.format("%sterms%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTerms()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

